/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasBankDao;
import com.ustc.base.entity.BasBank;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasBankService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BasBankDao basbankDao;
    @Autowired
    private BeetlSQLHelper bSqlHelper;

    public BasBank findBasBank(Long id) {
        BasBank entity = (BasBank)this.basbankDao.findById(id).get();
        return entity;
    }

    public JsonMsg checkRepeat(BasBank entity) {
        JsonMsg msg = new JsonMsg();
        List<BasBank> list = this.basbankDao.findByBankNameAndIsUse(entity.getBankName(), "Y");
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u94f6\u884c\u540d\u79f0\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getBankId().equals(entity.getBankId())) {
            msg.setSuccess(false);
            msg.setMsg("\u94f6\u884c\u540d\u79f0\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    public void saveBasBank(BasBank entity) {
        this.basbankDao.save(entity);
    }

    public void delBasBank(Long id) {
        this.basbankDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasBank.select", params, PageRequest.of((int)page, (int)rows));
    }

    public void delBasBankAndChild(Long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tBAS_BANK T \n\tSET\t\tT.IS_USE='N' \n\tWHERE \tT.BANK_ID in ( WITH recursive temp AS (\r\n\tSELECT\r\n\tA.BANK_ID \r\nFROM\r\n\tBAS_BANK A WHERE A.BANK_ID = ?1\r\n\tUNION ALL\r\nSELECT\r\n\tA.BANK_ID \r\nFROM\r\n\tBAS_BANK A,temp WHERE temp.BANK_ID = A.BANK_PID\r\n)select * from temp ) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    public List<ComBoxTreeNode> treeBasBank(Long pid, String bankType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        if (!StringUtils.isEmpty((String)bankType)) {
            params.put("bankType", bankType);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasBank.selectTree", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String BasBankParentName(Long bankid) {
        if (bankid == 0L) {
            return "";
        }
        BasBank bankEntity = (BasBank)this.basbankDao.findById(bankid).get();
        if (bankEntity == null) {
            return "";
        }
        return bankEntity.getBankAbbr();
    }
}

