/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasAccountDao;
import com.ustc.base.entity.BasAccount;
import com.ustc.base.service.CommonService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasAccountService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasAccountDao basaccountDao;

    public BasAccount findBasAccount(Long id) {
        BasAccount entity = (BasAccount)this.basaccountDao.findById(id).get();
        return entity;
    }

    public void saveBasAccount(BasAccount entity) {
        this.basaccountDao.save(entity);
    }

    public void delBasAccount(Long id, Long userId) {
        BasAccount entity = (BasAccount)this.basaccountDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.basaccountDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*\n");
        sql.append("from BAS_ACCOUNT t \n");
        sql.append(" where t.is_use=:isUse \n");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.FCOMPANYID) like :search ");
            sql.append(" or upper(t.FCURRENCYID) like :search ");
            sql.append(" or upper(t.FDC) like :search ");
            sql.append(" or upper(t.FISCHANGECURRENCY) like :search ");
            sql.append(" or upper(t.FISCASHEQUIVALENT) like :search ");
            sql.append(" or upper(t.FISCOUNTACCRUAL) like :search ");
            sql.append(" or upper(t.FACCRUALPER) like :search ");
            sql.append(" or upper(t.FISQTY) like :search ");
            sql.append(" or upper(t.FMEASUREUNITGROUPID) like :search ");
            sql.append(" or upper(t.FMEASUREUNITID) like :search ");
            sql.append(" or upper(t.FAC) like :search ");
            sql.append(" or upper(t.FPLTYPE) like :search ");
            sql.append(" or upper(t.FCONTROL) like :search ");
            sql.append(" or upper(t.FCAA) like :search ");
            sql.append(" or upper(t.FACCTCURRENCY) like :search ");
            sql.append(" or upper(t.FISBANK) like :search ");
            sql.append(" or upper(t.FISCASH) like :search ");
            sql.append(" or upper(t.FHASUSERPROPERTY) like :search ");
            sql.append(" or upper(t.FACCOUNTID) like :search ");
            sql.append(" or upper(t.FGLEVEL) like :search ");
            sql.append(" or upper(t.FISALLOWCA) like :search ");
            sql.append(" or upper(t.FCONTROLUNITID) like :search ");
            sql.append(" or upper(t.FUPPERID) like :search ");
            sql.append(" or upper(t.FPARENTAAID) like :search ");
            sql.append(" or upper(t.FISUPPERALLOWCA) like :search ");
            sql.append(" or upper(t.FISSELFFREEZE) like :search ");
            sql.append(" or upper(t.FISPARENTFREEZE) like :search ");
            sql.append(" or upper(t.FREFID) like :search ");
            sql.append(" or upper(t.FCONTROLLEVEL) like :search ");
            sql.append(" or upper(t.FISOUTDAILYACCOUNT) like :search ");
            sql.append(" or upper(t.FDISPLAYNAME_L1) like :search ");
            sql.append(" or upper(t.FDISPLAYNAME_L2) like :search ");
            sql.append(" or upper(t.FDISPLAYNAME_L3) like :search ");
            sql.append(" or upper(t.FACNOTICE) like :search ");
            sql.append(" or upper(t.FBW) like :search ");
            sql.append(" or upper(t.FMAINCASHFLOWITEMID) like :search ");
            sql.append(" or upper(t.FATTCASHFLOWITEMID) like :search ");
            sql.append(" or upper(t.FBORROWERMAINCASHFLOWITEMID) like :search ");
            sql.append(" or upper(t.FBORROWERATTCASHFLOWITEMID) like :search ");
            sql.append(" or upper(t.FLENDERMAINCASHFLOWITEMID) like :search ");
            sql.append(" or upper(t.FLENDERATTCASHFLOWITEMID) like :search ");
            sql.append(" or upper(t.FCREATORID) like :search ");
            sql.append(" or upper(t.FCREATETIME) like :search ");
            sql.append(" or upper(t.FLASTUPDATEUSERID) like :search ");
            sql.append(" or upper(t.FLASTUPDATETIME) like :search ");
            sql.append(" or upper(t.REMARK) like :search ");
            sql.append(" or upper(t.MODIFY_ACCOUNT) like :search ");
            sql.append(" or upper(t.MODIFY_TIME) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(" or upper(t.FPARENTID) like :search ");
            sql.append(" or upper(t.FISGFREEZE) like :search ");
            sql.append(" or upper(t.FGAA) like :search ");
            sql.append(" or upper(t.FISCFREEZE) like :search ");
            sql.append(" or upper(t.FHELPCODE) like :search ");
            sql.append(" or upper(t.ACCOUNT_ID) like :search ");
            sql.append(" or upper(t.ORG_ID) like :search ");
            sql.append(" or upper(t.FID) like :search ");
            sql.append(" or upper(t.FNAME_L1) like :search ");
            sql.append(" or upper(t.FNAME_L2) like :search ");
            sql.append(" or upper(t.FNAME_L3) like :search ");
            sql.append(" or upper(t.FNUMBER) like :search ");
            sql.append(" or upper(t.FDESCRIPTION_L3) like :search ");
            sql.append(" or upper(t.FDESCRIPTION_L1) like :search ");
            sql.append(" or upper(t.FDESCRIPTION_L2) like :search ");
            sql.append(" or upper(t.FSIMPLENAME) like :search ");
            sql.append(" or upper(t.FLEVEL) like :search ");
            sql.append(" or upper(t.FISLEAF) like :search ");
            sql.append(" or upper(t.FACCOUNTTABLEID) like :search ");
            sql.append(" or upper(t.FACCOUNTTYPEID) like :search ");
            sql.append(" or upper(t.FLONGNAME_L1) like :search ");
            sql.append(" or upper(t.FLONGNAME_L2) like :search ");
            sql.append(" or upper(t.FLONGNAME_L3) like :search ");
            sql.append(" or upper(t.FLONGNUMBER) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ACCOUNT_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComBoxTreeNode> getAccountTree(Long orgId, String subjtype) {
        if (orgId == null) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select * from (select distinct  (case when length(t.subjcode) > 4 then  substr(t.subjcode, 0, length(t.subjcode) - 3)    else '0' end) pid,\n  t.subjcode id,t.Dispname||'('||t.subjcode||')' text,t.SUBJNAME, \n  t.account_id, t.subjcode,t.pk_subjtype, \n  t.pk_glorgbook, 'open' as state \n   from bas_account t \n    where t.is_use = 'Y' \n    and t.pk_glorgbook = :orgId) p\n   where 1=1 \n");
        params.put("orgId", orgId);
        if (StringUtils.isNotBlank((String)subjtype)) {
            sql.append(" and p.pk_subjtype=:subjtype");
            params.put("subjtype", subjtype);
        }
        sql.append(" START WITH p.pid =0 \n CONNECT BY PRIOR p.id = p.pid \n ORDER BY p.Subjcode");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }
}

