/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.UnsupportedEncodingException;
import java.security.SignatureException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Encoder;

@RequestMapping(value={"/weather"})
@RestController
public class WeatherController {
    private String TIANQI_DAILY_WEATHER_URL = "https://api.seniverse.com/v3/weather/now.json";
    private String TIANQI_API_SECRET_KEY = "SXmIaI91D6raGSox3";
    private String TIANQI_API_USER_ID = "PREpTKRExoTypMgGD";
    private LoadingCache<String, String> caches;
    @Autowired
    private RestTemplate restTemplate;
    protected static ListeningExecutorService refreshPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));

    @PostConstruct
    public void init() {
        this.caches = CacheBuilder.newBuilder().maximumSize(100L).refreshAfterWrite(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                return WeatherController.this.generateValueByKey(key);
            }

            public ListenableFuture<String> reload(String key, String oldValue) {
                return refreshPool.submit(() -> WeatherController.this.generateValueByKey(key));
            }
        });
    }

    @RequestMapping(value={"/city/{city}"})
    public String getCityWeather(@PathVariable(name="city") String city) throws ExecutionException {
        return (String)this.caches.get((Object)city);
    }

    private String generateValueByKey(String key) throws Exception {
        return (String)this.restTemplate.getForObject(this.generateGetNowWeatherURL(key, "zh-Hans", "c"), String.class, new Object[0]);
    }

    private String generateSignature(String data, String key) throws SignatureException {
        String result;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
            result = new BASE64Encoder().encode(rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    public String generateGetNowWeatherURL(String location, String language, String unit) throws SignatureException, UnsupportedEncodingException {
        String timestamp = String.valueOf(new Date().getTime());
        String params = "ts=" + timestamp + "&ttl=1800&uid=" + this.TIANQI_API_USER_ID;
        String signature = this.generateSignature(params, this.TIANQI_API_SECRET_KEY);
        return this.TIANQI_DAILY_WEATHER_URL + "?" + params + "&sig=" + signature + "&location=" + location + "&language=" + language + "&unit=" + unit;
    }
}

