/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.DailyRecord;
import com.ustc.base.entity.GcMealsCost;
import com.ustc.base.service.GcMealsCostService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/GcMealsCost"})
public class GcMealsCostController
extends BaseController {
    @Autowired
    private GcMealsCostService gcmealscostService;

    @RequestMapping(value={"/pageGcMealsCost"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageGcMealsCost(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.gcmealscostService.PageAll(search, page, rows, sort, order);
    }

    @RequestMapping(value={"/findGcMealsCost"})
    @ResponseBody
    public Object findGcMealsCost(Long id) {
        GcMealsCost entity = this.gcmealscostService.findGcMealsCost(id);
        return entity;
    }

    @RequestMapping(value={"/saveGcMealsCost"})
    @ResponseBody
    public Object saveGcMealsCost(HttpServletRequest request, GcMealsCost entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.gcmealscostService.saveGcMealsCost(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delGcMealsCost"})
    @ResponseBody
    public Object delGcMealsCost(Long id) {
        this.gcmealscostService.delGcMealsCost(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/getCalendar"})
    @ResponseBody
    public JsonMsg getCalendar(String ym, Integer op) throws ParseException {
        Calendar cal = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        now.add(5, 1);
        if (StringUtils.isBlank((CharSequence)ym)) {
            cal.set(5, 1);
            ym = DateUtils.parse(cal.getTime(), "yyyy-MM");
        } else {
            Date d = DateUtils.strToDate(ym, "yyyy-MM");
            cal.setTime(d);
            if (op != 0) {
                cal.add(2, op);
            }
            ym = DateUtils.parse(cal.getTime(), "yyyy-MM");
        }
        Calendar end = Calendar.getInstance();
        end.setTime(cal.getTime());
        end.add(2, 1);
        ArrayList<DailyRecord> days = new ArrayList<DailyRecord>();
        while (cal.before(end)) {
            int top = cal.get(4) - 1;
            int xq = cal.get(7) - 1;
            String day = DateUtils.parse(cal.getTime(), "yyyy-MM-dd");
            DailyRecord record = new DailyRecord(day, top, xq);
            List<GcMealsCost> costs = this.gcmealscostService.findByBizDate(DateUtils.strToDate(day, "yyyy-MM-dd"));
            Object money1 = 0L;
            Long money2 = 0L;
            if (costs != null && !costs.isEmpty()) {
                for (GcMealsCost cost : costs) {
                    if ("1".equals(cost.getDirection())) {
                        money2 = money2 + cost.getMoney() * (long)cost.getParticipants().split(",").length;
                        continue;
                    }
                    money1 = (Long)money1 + cost.getMoney() * (long)cost.getParticipants().split(",").length;
                }
            }
            if ((Long)money1 != 0L) {
                record.setRemark("<span style=\"color:red;\">\u6d88\u8d39:" + money1 + "\u5143<span><br>");
            } else {
                record.setRemark("");
            }
            if (money2 != 0L) {
                record.setRemark(record.getRemark() + "<span style=\"color:green;\">\u5145\u503c:" + money2 + "\u5143<span>");
            }
            days.add(record);
            cal.add(5, 1);
        }
        List moneys = this.gcmealscostService.getMoneyRest();
        String rest = "";
        String cost = "";
        String name = "";
        Double money = 0.0;
        for (Object o : moneys) {
            Map m = (Map)o;
            rest = rest + m.get("NAME") + ":" + m.get("MONEY").toString() + "&nbsp;";
            cost = cost + m.get("NAME") + ":" + m.get("COST").toString() + "&nbsp;";
            if (m.get("NAME").toString().contains("\u996d\u5361") || money.compareTo(Double.parseDouble(m.get("COST").toString())) >= 0) continue;
            money = Double.parseDouble(m.get("COST").toString());
            name = m.get("NAME").toString();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("ym", ym);
        result.put("data", days);
        result.put("rest", rest);
        result.put("cost", cost);
        result.put("dww", "\u5927\u80c3\u738b\uff1a" + name);
        return new JsonMsg(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", result);
    }
}

