/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.CSSUtil;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasAppMenu;
import com.ustc.base.service.BasAppMenuService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/BasAppMenu"})
public class BasAppMenuController
extends BaseController {
    @Autowired
    private BasAppMenuService basappmenuService;

    @RequestMapping(value={"/pageBasAppMenu"})
    @ResponseBody
    public Object pageBasAppMenu(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basappmenuService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findBasAppMenu"})
    @ResponseBody
    public Object findBasAppMenu(Long id) {
        return this.basappmenuService.findBasAppMenu(id);
    }

    @RequestMapping(value={"/saveBasAppMenu"})
    @ResponseBody
    public Object saveBasAppMenu(BasAppMenu entity) {
        Long loginAccountId = SysUtils.getLoginAccountId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String now = sdf.format(new Date());
        Date date = null;
        try {
            date = sdf.parse(now);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Long createBy = entity.getCreateBy();
        if (createBy == null) {
            entity.setCreateBy(loginAccountId);
            entity.setCreateTime(date);
        } else {
            entity.setModifyAccount(loginAccountId);
            entity.setModifyTime(date);
        }
        String isUse = entity.getIsUse();
        if (null == isUse || isUse.length() <= 0) {
            entity.setIsUse("Y");
        }
        JsonMsg msg = new JsonMsg();
        this.basappmenuService.saveBasAppMenu(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/chooseIcons"})
    public ModelAndView chooseIcons(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        List<String> iconlist = CSSUtil.getNameList("classpath:/static/plugins/iconfont/iconfont.css", ":before");
        view.addObject("iconlist", iconlist);
        view.setViewName("/base/chooseIcons");
        return view;
    }

    @RequestMapping(value={"/delBasAppMenu"})
    @ResponseBody
    public Object delBasAppMenu(Long id) {
        BasAppMenu entity = this.basappmenuService.findBasAppMenu(id);
        this.basappmenuService.saveBasAppMenu(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeBasAppMenuWithRoot"})
    @ResponseBody
    public Object treeBasAppMenuWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid) {
        List<ComBoxTreeNode> treelist = this.basappmenuService.treeBasAppMenu(pid);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasAppMenu"})
    @ResponseBody
    public Object treeBasAppMenu(@RequestParam(value="pid", defaultValue="0") Long pid) {
        return this.basappmenuService.treeBasAppMenu(pid);
    }

    @RequestMapping(value={"/delBasAppMenuAndChild"})
    @ResponseBody
    public Object delBasAppMenuAndChild(Long id) {
        this.basappmenuService.delBasAppMenuAndChild(id);
        return new JsonMsg();
    }
}

