/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.util.exceltools;

import cn.hutool.core.date.DateUtil;
import com.ustc.base.common.util.exceltools.TableData;
import com.ustc.base.common.util.exceltools.TableDataCell;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class TableDataRow {
    private LinkedList<TableDataCell> cells = new LinkedList();
    private TableData table;
    private int rowStyle = 0;

    public void addCell(TableDataCell cell) {
        this.cells.add(cell);
    }

    public void addCell(String value) {
        TableDataCell cell = new TableDataCell(this);
        cell.setValue(value.replaceAll("&nbsp;", " ").replaceAll("&emsp;", "  "));
        cell.setCellStyle(this.rowStyle);
        this.addCell(cell);
    }

    public void addCell(Integer value) {
        TableDataCell cell = new TableDataCell(this);
        cell.setValue(value);
        cell.setCellStyle(this.rowStyle);
        this.addCell(cell);
    }

    public void addCell(Double value) {
        TableDataCell cell = new TableDataCell(this);
        cell.setValue(value);
        cell.setCellStyle(this.rowStyle);
        this.addCell(cell);
    }

    public void addCell(Object value) {
        if (value instanceof String) {
            this.addCell((String)value);
        } else if (value instanceof Integer) {
            this.addCell((Integer)value);
        } else if (value instanceof Double) {
            this.addCell((Double)value);
        } else if (value instanceof BigDecimal) {
            this.addCell(((BigDecimal)value).doubleValue());
        } else if (value instanceof Long) {
            this.addCell(value.toString());
        } else if (value instanceof Date) {
            this.addCell(DateUtil.formatDate((Date)((Date)value)));
        } else if (value instanceof Timestamp) {
            this.addCell(DateUtil.formatDate((Date)((Timestamp)value)));
        } else if (value == null) {
            this.addCell("");
        } else {
            this.addCell(value + "");
        }
    }

    public TableDataCell getCellAt(int index) {
        return this.cells.get(index);
    }

    public List<TableDataCell> getCells() {
        return this.cells;
    }

    public TableData getTable() {
        return this.table;
    }

    public TableDataRow(TableData table) {
        this.table = table;
    }

    public void setRowStyle(int rowStyle) {
        this.rowStyle = rowStyle;
    }

    public int getRowStyle() {
        return this.rowStyle;
    }
}

