/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.spring;

import com.alibaba.fastjson.JSON;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TimeInteceptor
implements HandlerInterceptor {
    private static final Logger logger = Logger.getLogger(TimeInteceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long startTime = System.currentTimeMillis();
        request.setAttribute("startTime", (Object)startTime);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        long startTime = (Long)request.getAttribute("startTime");
        long endTime = System.currentTimeMillis();
        long executeTime = endTime - startTime;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[executeTime(ms):" + executeTime + ",url:'" + request.getRequestURI() + "',params:" + JSON.toJSONString((Object)request.getParameterMap()) + "]"));
        }
    }

    public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, Exception arg3) throws Exception {
    }
}

