/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.http.HttpStatus;

public class MyShiroAuthcFilter
extends FormAuthenticationFilter {
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            return super.onAccessDenied(request, response);
        }
        if (this.isAjax((HttpServletRequest)request)) {
            HttpServletResponse httpServletResponse = WebUtils.toHttp((ServletResponse)response);
            httpServletResponse.addHeader("REQUIRE_AUTH", "true");
            httpServletResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
            httpServletResponse.setStatus(403);
        } else {
            this.saveRequestAndRedirectToLogin(request, response);
        }
        return false;
    }

    private boolean isAjax(HttpServletRequest request) {
        String requestedWithHeader = request.getHeader("X-Requested-With");
        return "XMLHttpRequest".equals(requestedWithHeader);
    }
}

