/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MenuConfirmFilter
implements Filter {
    public static Logger loger = Logger.getLogger(MenuConfirmFilter.class);
    private static long expiredTime = 180000L;
    private static Map<String, Long> menus = new HashMap<String, Long>(){
        {
            this.put("/view/business/hr/HrSalaryJInputMain", null);
            this.put("/view/business/hr/HrSalaryDeptInputQuery", null);
            this.put("/view/business/hr/HrSalaryJInputMainSelf", null);
            this.put("/view/business/fm/FmImport", null);
        }
    };

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.checkMenu(req)) {
            String url = req.getRequestURI();
            String queryurl = req.getQueryString();
            if (null != queryurl) {
                url = url + "?" + queryurl;
            }
            request.setAttribute("preurl", (Object)url.replace(req.getContextPath(), ""));
            request.getRequestDispatcher("/view/confirm").forward(request, response);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    private boolean checkMenu(HttpServletRequest req) {
        String currentURL = req.getRequestURI();
        if (StringUtils.isBlank((CharSequence)currentURL)) {
            return false;
        }
        if (!menus.containsKey(currentURL = currentURL.replace(req.getContextPath(), ""))) {
            return false;
        }
        Object ob = req.getSession().getAttribute("menuConfirmMap");
        if (ob == null) {
            req.getSession().setAttribute("menuConfirmMap", new HashMap());
            return true;
        }
        HashMap map = (HashMap)ob;
        if (map.get(currentURL) == null) {
            return true;
        }
        return System.currentTimeMillis() - (Long)map.get(currentURL) > expiredTime;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

