/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.exception;

import com.alibaba.fastjson.JSON;
import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.exception.InvoiceDuplicatedException;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.doc.common.util.FileStoreException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
@Order(value=0)
public class ExceptionHandler
implements HandlerExceptionResolver {
    public static Logger loger = Logger.getLogger(ExceptionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        String errorUrl = request.getRequestURI();
        String method = request.getMethod();
        LoginUser loginuser = (LoginUser)request.getSession().getAttribute("LOGIN_USER");
        String userinfor = loginuser == null ? "" : loginuser.getOrgName() + "-" + loginuser.getDeptName() + "-" + loginuser.getAccountName() + "[accountid:" + loginuser.getAccountid() + "]";
        String errorParams = JSON.toJSONString((Object)request.getParameterMap());
        String errorMsg = "\u8bf7\u6c42:[URL:" + errorUrl + " method:" + method + "],\u53c2\u6570:[" + errorParams + "],\u7528\u6237\u4fe1\u606f:[" + userinfor + "]";
        HashMap<String, Object> model = new HashMap<String, Object>();
        String exceptionMsgTitle = ex.getMessage() == null ? "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458" : ex.getMessage();
        String exceptionMsgDetail = errorMsg + "\n" + exceptionMsgTitle;
        exceptionMsgDetail = exceptionMsgDetail + "\n" + (ex.getCause() == null ? "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458" : ex.getCause().getMessage());
        loger.error((Object)exceptionMsgDetail, (Throwable)ex);
        model.put("ex", ex);
        model.put("errorMsg", exceptionMsgDetail);
        HashMap<String, String> msgobject = new HashMap<String, String>();
        msgobject.put("title", "\u7cfb\u7edf\u5f00\u4e2a\u5c0f\u5dee,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        msgobject.put("detail", exceptionMsgDetail);
        if (ex instanceof ObjectOptimisticLockingFailureException) {
            msgobject.put("title", "\u6570\u636e\u5df2\u7ecf\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            msgobject.put("detail", "\u6570\u636e\u5df2\u7ecf\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        } else if (ex instanceof InvoiceDuplicatedException) {
            msgobject.put("title", ex.getMessage());
            msgobject.put("detail", ex.getMessage());
        } else if (ex instanceof GEPSBisException) {
            msgobject.put("title", ex.getMessage());
            msgobject.put("detail", ex.getMessage());
        }
        if (ex.getClass().equals(FileStoreException.class)) {
            return new ModelAndView("/errorpage/filenotfound", model);
        }
        response.setHeader("Content-Type", "text/html;charset=UTF-8");
        PrintWriter out = null;
        String xRequestedWith = request.getHeader("X-Requested-With");
        String contenttype = request.getContentType();
        if (!StringUtils.isEmpty((CharSequence)xRequestedWith) || "application/x-www-form-urlencoded".equals(contenttype) || multipartResolver.isMultipart(request)) {
            try {
                out = response.getWriter();
                out.write(JSON.toJSONString((Object)new JsonMsg(false, msgobject)).toString());
                out.flush();
            }
            catch (IOException e) {
                loger.error((Object)"GEPSExceptionHandler\u6355\u83b7\u5230\u5f02\u5e38\u3002", (Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        loger.error((Object)"GEPSExceptionHandler\u6355\u83b7\u5230\u5f02\u5e38\u3002", (Throwable)e);
                    }
                }
            }
            return null;
        }
        return new ModelAndView("/errorpage/404", model);
    }

    private String cleanXSS(String value) {
        value = value.replaceAll("<", "& lt;").replaceAll(">", "& gt;");
        value = value.replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;");
        value = value.replaceAll("'", "& #39;");
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", "");
        return value;
    }
}

