/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.cas;

import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasEmp;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasEmpService;
import com.ustc.base.service.CommonService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CasSetUserAdapterFilter
extends BaseController
implements Filter {
    private static final Logger LOG = Logger.getLogger((String)CasSetUserAdapterFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Subject currentUser = SecurityUtils.getSubject();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (currentUser.isAuthenticated()) {
            HttpSession session = httpRequest.getSession(false);
            LoginUser loginUser = (LoginUser)session.getAttribute("LOGIN_USER");
            String accountId = (String)currentUser.getPrincipal();
            if (!(StringUtils.isEmpty((Object)accountId) || loginUser != null && String.valueOf(loginUser.getAccountid()).equals(accountId))) {
                WebApplicationContext wct = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session.getServletContext());
                BasEmpAccountService basEmpAccountService = (BasEmpAccountService)wct.getBean("BasEmpAccountService");
                BasEmpAccount account = basEmpAccountService.findById(Long.parseLong(accountId));
                CommonService commonService = (CommonService)wct.getBean("CommonService");
                BasEmpService basEmpService = (BasEmpService)wct.getBean("BasEmpService");
                BasEmp emp = basEmpService.findEmpByempId(account.getEmpId());
                if (emp != null) {
                    if (loginUser != null) {
                        session.removeAttribute("LOGIN_USER");
                        CommonService.delOnlineUser(loginUser);
                        commonService.setLogOutLog(session.getId(), loginUser.getAccountid());
                    }
                    loginUser = commonService.setSessionAndLogInLog(session, emp, Long.parseLong(accountId), SysUtils.getIpAddr(httpRequest));
                    CommonService.addOnlineUser(loginUser);
                } else {
                    LOG.error((Object)"\u7cfb\u7edf\u767b\u9646\u7528\u6237\u65e0\u6cd5\u627e\u5bf9\u5bf9\u5e94\u5e10\u5957");
                }
            }
        }
        HttpServletResponse resp = (HttpServletResponse)response;
        resp.addHeader("P3P", "CP=CAO PSA OUR");
        chain.doFilter(request, response);
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }
}

