/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.CronTask;

import com.ustc.base.common.CronTask.SpringContextUtils;
import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.entity.BasTimedTaskLog;
import com.ustc.base.service.BasTimedTaskLogService;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SchedulingRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingRunnable.class);
    private String beanName;
    private String methodName;
    private Object[] params;
    private long taskId;
    private long createAccount;
    private String ip;

    public SchedulingRunnable(String beanName, String methodName) {
        this.beanName = beanName;
        this.methodName = methodName;
    }

    public SchedulingRunnable(String beanName, String methodName, Object ... params) {
        this.beanName = beanName;
        this.methodName = methodName;
        this.params = params;
    }

    public SchedulingRunnable(String beanName, String methodName, Long taskId) {
        this.beanName = beanName;
        this.methodName = methodName;
        this.taskId = taskId;
    }

    public SchedulingRunnable(String beanName, String methodName, Long taskId, Long createAccount, String ip) {
        this.beanName = beanName;
        this.methodName = methodName;
        this.taskId = taskId;
        this.createAccount = createAccount;
        this.ip = ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c - bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.beanName, this.methodName, this.params});
        long startTime = System.currentTimeMillis();
        BasTimedTaskLog basTimedTaskLog = new BasTimedTaskLog(this.taskId, this.createAccount, new Date(), this.ip, "Y");
        try {
            Object target = SpringContextUtils.getBean(this.beanName);
            Method method = null;
            if (null != this.params && this.params.length > 0) {
                Class[] paramCls = new Class[this.params.length];
                for (int i = 0; i < this.params.length; ++i) {
                    paramCls[i] = this.params[i].getClass();
                }
                method = target.getClass().getDeclaredMethod(this.methodName, paramCls);
            } else {
                method = target.getClass().getDeclaredMethod(this.methodName, new Class[0]);
            }
            ReflectionUtils.makeAccessible((Method)method);
            if (null != this.params && this.params.length > 0) {
                method.invoke(target, this.params);
            } else {
                method.invoke(target, new Object[0]);
            }
            basTimedTaskLog.setOperateResult("Y");
            basTimedTaskLog.setOperateDetail(String.format("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f - bean\uff1a%s\uff0c\u65b9\u6cd5\uff1a%s\uff0c\u53c2\u6570\uff1a%s", this.beanName, this.methodName, this.params));
        }
        catch (Exception ex) {
            logger.error(String.format("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38 - bean\uff1a%s\uff0c\u65b9\u6cd5\uff1a%s\uff0c\u53c2\u6570\uff1a%s ", this.beanName, this.methodName, this.params), (Throwable)ex);
            basTimedTaskLog.setOperateResult("N");
            basTimedTaskLog.setOperateDetail(String.format("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38 - bean\uff1a%s\uff0c\u65b9\u6cd5\uff1a%s\uff0c\u53c2\u6570\uff1a%s\uff0c\u9519\u8bef\u4fe1\u606f: %s", this.beanName, this.methodName, this.params, ex.getMessage()));
        }
        finally {
            if (basTimedTaskLog != null) {
                BasTimedTaskLogService basTimedTaskLogService = (BasTimedTaskLogService)SpringContextHolder.getBean("basTimedTaskLogService");
                basTimedTaskLogService.saveBasTimedTaskLog(basTimedTaskLog);
            }
        }
        long times = System.currentTimeMillis() - startTime;
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f - bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{this.beanName, this.methodName, this.params, times});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingRunnable that = (SchedulingRunnable)o;
        if (this.params == null) {
            return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && that.params == null;
        }
        return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && this.params.equals(that.params);
    }

    public int hashCode() {
        if (this.params == null) {
            return Objects.hash(this.beanName, this.methodName);
        }
        return Objects.hash(this.beanName, this.methodName, this.params);
    }
}

