/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.app.common;

import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.ListMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.notify.Notify;
import com.gexin.rp.sdk.dto.GtReq;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style0;
import com.ustc.app.common.AppPush;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppPushbak {
    private static Logger logger = Logger.getLogger(AppPush.class);
    private static String appId;
    private static String appKey;
    private static String masterSecret;
    private static String url;

    public static void pushMsgAll(String title, String content) {
        AppPushbak.pushMsgAll(title, content, "");
    }

    public static void pushMsgAll(String title, String content, String params) {
        AppPushbak.pushMsgAll(title, content, params, true, 1800000L);
    }

    public static void pushMsgAll(String title, String content, String params, boolean offline, long offlineExpireTime) {
        IGtPush push = new IGtPush(url, appKey, masterSecret);
        TransmissionTemplate template = AppPushbak.transmissionTemplateDemo(title, content, params);
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(appId);
        AppMessage message = new AppMessage();
        message.setData((ITemplate)template);
        message.setAppIdList(appIds);
        message.setOffline(offline);
        message.setOfflineExpireTime(offlineExpireTime);
        IPushResult ret = push.pushMessageToApp(message);
        if ("ok".equals(String.valueOf(ret.getResponse().get("result")))) {
            logger.info((Object)("app\u7aef\u63d0\u9192\u63a8\u9001\u6210\u529f:" + ret.getResponse().toString()));
        } else {
            logger.error((Object)("app\u7aef\u63d0\u9192\u63a8\u9001\u5931\u8d25:" + ret.getResponse().toString()));
        }
    }

    public static void pushToSingle(String title, String content, String params, String clientId) {
        AppPushbak.pushToSingle(title, content, params, clientId, true, 1800000L);
    }

    public static void pushToSingle(String title, String content, String params, String clientId, boolean offline, long offlineExpireTime) {
        IGtPush push = new IGtPush(url, appKey, masterSecret);
        NotificationTemplate template = AppPushbak.notifiDemo(title, content, params);
        SingleMessage message = new SingleMessage();
        message.setOffline(offline);
        message.setOfflineExpireTime(offlineExpireTime);
        message.setData((ITemplate)template);
        message.setPushNetWorkType(0);
        Target target = new Target();
        target.setAppId(appId);
        target.setClientId(clientId);
        IPushResult ret = null;
        try {
            ret = push.pushMessageToSingle(message, target);
        }
        catch (RequestException e) {
            e.printStackTrace();
            ret = push.pushMessageToSingle(message, target, e.getRequestId());
        }
        if (ret != null) {
            logger.info((Object)("app\u7aef\u63d0\u9192\u63a8\u9001\u6210\u529f:" + ret.getResponse().toString()));
        } else {
            logger.info((Object)"app\u7aef\u63d0\u9192\u63a8\u9001\u5931\u8d25");
        }
    }

    public static NotificationTemplate notifiDemo(String title, String content, String params) {
        NotificationTemplate template = new NotificationTemplate();
        Style0 style = new Style0();
        style.setTitle(title);
        style.setText(content);
        style.setLogo("push.png");
        style.setRing(true);
        style.setVibrate(true);
        template.setAppId(appId);
        template.setAppkey(appKey);
        template.setStyle((AbstractNotifyStyle)style);
        template.setTransmissionType(1);
        template.setTransmissionContent(params);
        return template;
    }

    private static TransmissionTemplate transmissionTemplateDemo(String title, String content, String params) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        template.setTransmissionContent(params);
        template.setTransmissionType(1);
        Notify notify = new Notify();
        notify.setTitle(title);
        notify.setContent(content);
        notify.setIntent("intent:#Intent;action=android.intent.action.oppopush;package=com.ylu.unipush;component=com.ylu.unipush/io.dcloud.PandoraEntry;S.UP-OL-SU=true;S.title=test11;S.content=ccc2222;S.payload=xxx;end");
        notify.setType(GtReq.NotifyInfo.Type._intent);
        template.set3rdNotifyInfo(notify);
        return template;
    }

    public static void pushToList(String title, String content, String params, List<String> clientIds) {
        AppPushbak.pushToList(title, content, params, clientIds, true, 1800000L);
    }

    public static void pushToList(String title, String content, String params, List<String> clientIds, boolean offline, long offlineExpireTime) {
        IGtPush push = new IGtPush(url, appKey, masterSecret);
        NotificationTemplate template = AppPushbak.notifiDemo(title, content, params);
        ListMessage message = new ListMessage();
        message.setOffline(offline);
        message.setOfflineExpireTime(offlineExpireTime);
        message.setData((ITemplate)template);
        message.setPushNetWorkType(0);
        ArrayList<Target> targets = new ArrayList<Target>();
        for (String clientId : clientIds) {
            Target target = new Target();
            target.setAppId(appId);
            target.setClientId(clientId);
            targets.add(target);
        }
        IPushResult ret = null;
        try {
            String taskId = push.getContentId(message);
            ret = push.pushMessageToList(taskId, targets);
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        if (ret != null) {
            logger.info((Object)("app\u7aef\u63d0\u9192\u63a8\u9001\u6210\u529f:" + ret.getResponse().toString()));
        } else {
            logger.info((Object)"app\u7aef\u63d0\u9192\u63a8\u9001\u5931\u8d25");
        }
    }

    public String getAppId() {
        return appId;
    }

    @Value(value="${app.appId}")
    public void setAppId(String appId) {
        AppPushbak.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    @Value(value="${app.appKey}")
    public void setAppKey(String appKey) {
        AppPushbak.appKey = appKey;
    }

    public String getMasterSecret() {
        return masterSecret;
    }

    @Value(value="${app.masterSecret}")
    public void setMasterSecret(String masterSecret) {
        AppPushbak.masterSecret = masterSecret;
    }

    public static void main(String[] args) throws IOException {
        AppPushbak.pushToList("\u6307\u5b9a\u63a8\u9001\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bae\u63d0\u9192", "\u79d1\u5927\u56fd\u521b2019\u7b2c\u4e09\u6b21\u80a1\u4e1c\u5927\u4f1a\u5c06\u4e8e9\u670826 10\u70b930\u53ec\u5f00", "{id:'xxxxx'}", Arrays.asList("650f95630632edc821dda4bc764d7826"));
    }

    static {
        url = "http://sdk.open.api.igexin.com/apiex.htm";
    }
}

