/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

class ClassHeaderReader {
    private int access;
    private String thisClass;
    private String superClass;
    private String[] interfaces;

    public int getAccess() {
        return this.access;
    }

    public String getClassName() {
        return this.thisClass;
    }

    public String getSuperName() {
        return this.superClass;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassHeaderReader(InputStream in) throws IOException {
        try {
            DataInputStream data = new DataInputStream(in);
            int magic = data.readInt();
            int minorVersion = data.readUnsignedShort();
            int majorVersion = data.readUnsignedShort();
            if (magic != -889275714) {
                throw new IOException("Bad magic number");
            }
            int constant_pool_count = data.readUnsignedShort();
            TreeMap<Integer, Object> items = new TreeMap<Integer, Object>();
            block10: for (int i = 1; i < constant_pool_count; ++i) {
                int tag = data.readUnsignedByte();
                switch (tag) {
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        ClassHeaderReader.skipFully(data, 4);
                        continue block10;
                    }
                    case 5: 
                    case 6: {
                        ClassHeaderReader.skipFully(data, 8);
                        ++i;
                        continue block10;
                    }
                    case 1: {
                        items.put(new Integer(i), data.readUTF());
                        continue block10;
                    }
                    case 7: {
                        items.put(new Integer(i), new Integer(data.readUnsignedShort()));
                        continue block10;
                    }
                    case 8: {
                        ClassHeaderReader.skipFully(data, 2);
                        continue block10;
                    }
                    default: {
                        throw new IllegalStateException("Unknown constant pool tag " + tag);
                    }
                }
            }
            this.access = data.readUnsignedShort();
            this.thisClass = ClassHeaderReader.readClass(data.readUnsignedShort(), items);
            this.superClass = ClassHeaderReader.readClass(data.readUnsignedShort(), items);
            int interfaces_count = data.readUnsignedShort();
            this.interfaces = new String[interfaces_count];
            for (int i = 0; i < interfaces_count; ++i) {
                this.interfaces[i] = ClassHeaderReader.readClass(data.readUnsignedShort(), items);
            }
        }
        finally {
            in.close();
        }
    }

    private static String readClass(int index, Map items) {
        if (items.get(new Integer(index)) == null) {
            throw new IllegalArgumentException("cannot find index " + index + " in " + items);
        }
        return ClassHeaderReader.readString((Integer)items.get(new Integer(index)), items);
    }

    private static String readString(int index, Map items) {
        return (String)items.get(new Integer(index));
    }

    private static void skipFully(DataInput data, int n) throws IOException {
        while (n > 0) {
            int amt = data.skipBytes(n);
            if (amt == 0) {
                data.readByte();
                --n;
                continue;
            }
            n -= amt;
        }
    }
}

