/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.AutoExpandingBuffer;
import com.taosdata.jdbc.common.TableInfo;
import com.taosdata.jdbc.enums.FieldBindType;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.BlobUtil;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.ws.BlockResultSet;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSParameterMetaData;
import com.taosdata.jdbc.ws.WSRetryableStmt;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.stmt2.entity.Field;
import com.taosdata.jdbc.ws.stmt2.entity.RequestFactory;
import com.taosdata.jdbc.ws.stmt2.entity.ResultResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2PrepareResp;
import com.taosdata.jdbc.ws.stmt2.entity.StmtInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;

public class WSRowPreparedStatement
extends WSRetryableStmt
implements PreparedStatement {
    protected final ConnectionParam param;
    protected int queryTimeout = 0;
    private TableInfo tableInfo;
    private AutoExpandingBuffer tableNameLensBuf;
    private AutoExpandingBuffer tableNamesBuf;
    private AutoExpandingBuffer tagLensBuf;
    private AutoExpandingBuffer tagsBuf;
    private AutoExpandingBuffer colLensBuf;
    private AutoExpandingBuffer colsBuf;
    private int curTableTagTotalLen = 0;
    private int curTableColTotalLen = 0;
    private int totalTableCount = 0;
    private final int MAX_COMPONENT_COUNT = 1000;
    private final int SMALL_BUFFER_INIT_SIZE = 1024;
    private final int TABLE_NAME_BUFFER_INIT_SIZE = 10240;
    private final int TAGS_BUFFER_INIT_SIZE = 102400;
    private final int COLS_BUFFER_INIT_SIZE = 0x100000;

    private void initBuffers() {
        this.buffersStopWrite();
        this.freeBuffers();
        this.tableNameLensBuf = new AutoExpandingBuffer(1024, 1000);
        this.tableNamesBuf = new AutoExpandingBuffer(10240, 1000);
        this.tagLensBuf = new AutoExpandingBuffer(1024, 1000);
        this.tagsBuf = new AutoExpandingBuffer(102400, 1000);
        this.colLensBuf = new AutoExpandingBuffer(1024, 1000);
        this.colsBuf = new AutoExpandingBuffer(0x100000, 1000);
    }

    public WSRowPreparedStatement(Transport transport, ConnectionParam param, String database, AbstractConnection connection, String sql, Long instanceId, Stmt2PrepareResp prepareResp) {
        super(connection, param, database, transport, instanceId, new StmtInfo(prepareResp, sql), new AtomicInteger());
        this.param = param;
        if (this.stmtInfo.isInsert()) {
            ArrayList<Byte> colTypeList = new ArrayList<Byte>();
            for (int i = 0; i < this.stmtInfo.getFields().size(); ++i) {
                Field field = this.stmtInfo.getFields().get(i);
                colTypeList.add(field.getFieldType());
            }
            this.stmtInfo.setColTypeList(colTypeList);
        }
        this.tableInfo = TableInfo.getEmptyTableInfo();
        this.initBuffers();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (seconds < 0) {
            throw TSDBError.createSQLException(8963);
        }
        this.queryTimeout = seconds;
        this.transport.setTimeout((long)seconds * 1000L);
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.stmtInfo.isInsert()) {
            this.executeUpdate();
        } else {
            this.executeQuery();
        }
        return !this.stmtInfo.isInsert();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.stmtInfo.isInsert()) {
            throw TSDBError.createSQLException(8963, "The query SQL must be prepared.");
        }
        this.addBatch();
        ResultResp resp = this.executeQueryImpl();
        this.resultSet = new BlockResultSet(this, this.transport, resp, this.database, this.zoneId);
        this.affectedRows = -1;
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!this.stmtInfo.isInsert()) {
            throw TSDBError.createSQLException(8963, "The insert SQL must be prepared.");
        }
        if (this.stmtInfo.getFields().isEmpty()) {
            return this.executeUpdate(this.stmtInfo.getSql());
        }
        this.addBatch();
        return this.executeInsertImpl();
    }

    public void setNullByTSDBType(int parameterIndex, int type) throws SQLException {
        switch (type) {
            case 1: {
                this.setBooleanInner(parameterIndex, false, true);
                break;
            }
            case 2: 
            case 11: {
                this.setByteInner(parameterIndex, (byte)0, true, (byte)type);
                break;
            }
            case 3: 
            case 12: {
                this.setShortInner(parameterIndex, (short)0, true, (byte)type);
                break;
            }
            case 4: 
            case 13: {
                this.setIntInner(parameterIndex, 0, true, (byte)type);
                break;
            }
            case 5: 
            case 14: {
                this.setLongInner(parameterIndex, 0L, true, (byte)type);
                break;
            }
            case 6: {
                this.setFloatInner(parameterIndex, 0.0f, true);
                break;
            }
            case 7: {
                this.setDoubleInner(parameterIndex, 0.0, true);
                break;
            }
            case 9: {
                this.setTimestampInner(parameterIndex, 0L, true);
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                this.seStringInner(parameterIndex, null, true, (byte)type);
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + type);
            }
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                this.setBooleanInner(parameterIndex, false, true);
                break;
            }
            case -6: {
                this.setByteInner(parameterIndex, (byte)0, true, (byte)2);
                break;
            }
            case 5: {
                this.setShortInner(parameterIndex, (short)0, true, (byte)3);
                break;
            }
            case 4: {
                this.setIntInner(parameterIndex, 0, true, (byte)4);
                break;
            }
            case -5: {
                this.setLongInner(parameterIndex, 0L, true, (byte)5);
                break;
            }
            case 6: {
                this.setFloatInner(parameterIndex, 0.0f, true);
                break;
            }
            case 8: {
                this.setDoubleInner(parameterIndex, 0.0, true);
                break;
            }
            case 93: {
                this.setTimestampInner(parameterIndex, 0L, true);
                break;
            }
            case -3: 
            case -2: 
            case 12: 
            case 2004: {
                byte fieldType = this.stmtInfo.getFields().get(parameterIndex - 1).getFieldType();
                if (fieldType > 0) {
                    this.seStringInner(parameterIndex, null, true, fieldType);
                    break;
                }
                this.seStringInner(parameterIndex, null, true, (byte)8);
                break;
            }
            case -15: {
                byte fieldType = this.stmtInfo.getFields().get(parameterIndex - 1).getFieldType();
                if (fieldType > 0) {
                    this.seStringInner(parameterIndex, null, true, fieldType);
                    break;
                }
                this.seStringInner(parameterIndex, null, true, (byte)10);
                break;
            }
            case 1111: {
                byte fieldType = this.stmtInfo.getFields().get(parameterIndex - 1).getFieldType();
                if (fieldType > 0) {
                    this.seStringInner(parameterIndex, null, true, fieldType);
                    break;
                }
                this.seStringInner(parameterIndex, null, true, (byte)15);
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + sqlType);
            }
        }
    }

    private void setBooleanInner(int parameterIndex, boolean x, boolean isNull) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeBool(x, isNull);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeBool(x, isNull);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setBooleanInner(parameterIndex, x, false);
    }

    private void setByteInner(int parameterIndex, byte x, boolean isNull, byte type) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeByte(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeByte(x, isNull, type);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setByteInner(parameterIndex, x, false, (byte)2);
    }

    private void setShortInner(int parameterIndex, short x, boolean isNull, byte type) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeShort(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeShort(x, isNull, type);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.stmtInfo.getColTypeList().get(parameterIndex - 1) == 11) {
            if (x < 0 || x > 255) {
                throw TSDBError.createSQLException(8963, "utinyint value is out of range");
            }
            this.setByteInner(parameterIndex, (byte)x, false, (byte)11);
            return;
        }
        this.setShortInner(parameterIndex, x, false, (byte)3);
    }

    private void setIntInner(int parameterIndex, int x, boolean isNull, byte type) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeInt(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeInt(x, isNull, type);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.stmtInfo.getColTypeList().get(parameterIndex - 1) == 12) {
            if (x < 0 || x > 65535) {
                throw TSDBError.createSQLException(8963, "usmallint value is out of range");
            }
            this.setShortInner(parameterIndex, (short)x, false, (byte)12);
            return;
        }
        this.setIntInner(parameterIndex, x, false, (byte)4);
    }

    private void setLongInner(int parameterIndex, long x, boolean isNull, byte type) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeLong(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeLong(x, isNull, type);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.stmtInfo.getColTypeList().get(parameterIndex - 1) == 13) {
            if (x < 0L || x > 0xFFFFFFFFL) {
                throw TSDBError.createSQLException(8963, "uint value is out of range");
            }
            this.setIntInner(parameterIndex, (int)x, false, (byte)13);
            return;
        }
        this.setLongInner(parameterIndex, x, false, (byte)5);
    }

    private void setFloatInner(int parameterIndex, float x, boolean isNull) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeFloat(x, isNull);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeFloat(x, isNull);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setFloatInner(parameterIndex, x, false);
    }

    private void setDoubleInner(int parameterIndex, double x, boolean isNull) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeDouble(x, isNull);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeDouble(x, isNull);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setDoubleInner(parameterIndex, x, false);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    private void seStringInner(int parameterIndex, String x, boolean isNull, byte type) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeString(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeString(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TBNAME.getValue()) {
            if (x == null) {
                throw TSDBError.createSQLException(8963, "table name can't be null");
            }
            int length = this.tableNamesBuf.writeString(x);
            this.tableNamesBuf.writeBytes(new byte[]{0});
            this.tableNameLensBuf.writeShort((short)(length + 1));
        }
    }

    private void setBytesInner(int parameterIndex, byte[] x, boolean isNull, byte type) throws SQLException {
        byte bindType = this.stmtInfo.getFields().get(parameterIndex - 1).getBindType();
        if (bindType == FieldBindType.TAOS_FIELD_COL.getValue()) {
            this.curTableColTotalLen += this.colsBuf.serializeBytes(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            this.curTableTagTotalLen += this.tagsBuf.serializeBytes(x, isNull, type);
        } else if (bindType == FieldBindType.TAOS_FIELD_TBNAME.getValue()) {
            if (x == null) {
                throw TSDBError.createSQLException(8963, "table name can't be null");
            }
            this.tableNamesBuf.writeBytes(x);
            this.tableNamesBuf.writeBytes(new byte[]{0});
            this.tableNameLensBuf.writeShort((short)(x.length + 1));
        }
    }

    private byte getTSDBType(int parameterIndex, byte defaultType) {
        byte type = this.stmtInfo.getColTypeList().get(parameterIndex - 1);
        if (type >= 0) {
            return type;
        }
        return defaultType;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.seStringInner(parameterIndex, x, x == null, this.getTSDBType(parameterIndex, (byte)8));
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.seStringInner(parameterIndex, x, x == null, this.getTSDBType(parameterIndex, (byte)10));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setBytesInner(parameterIndex, x, x == null, this.getTSDBType(parameterIndex, (byte)16));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Timestamp timestamp = new Timestamp(x.getTime());
        this.setTimestamp(parameterIndex, timestamp);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Timestamp timestamp = new Timestamp(x.getTime());
        this.setTimestamp(parameterIndex, timestamp);
    }

    private void setTimestampInner(int parameterIndex, long x, boolean isNull) throws SQLException {
        if (this.stmtInfo.getFields().get(parameterIndex - 1).getBindType() == FieldBindType.TAOS_FIELD_COL.getValue()) {
            int totalLen = this.colsBuf.serializeTimeStamp(x, isNull);
            this.curTableColTotalLen += totalLen;
        } else if (this.stmtInfo.getFields().get(parameterIndex - 1).getBindType() == FieldBindType.TAOS_FIELD_TAG.getValue()) {
            int totalLen = this.tagsBuf.serializeTimeStamp(x, isNull);
            this.curTableTagTotalLen += totalLen;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        long ts = DateTimeUtils.toLong(DateTimeUtils.toInstant(x, this.zoneId), this.stmtInfo.getPrecision());
        this.setTimestampInner(parameterIndex, ts, false);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void clearParameters() {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 16: {
                if (x instanceof Boolean) {
                    this.setBoolean(parameterIndex, (Boolean)x);
                    break;
                }
                if (x instanceof Number) {
                    this.setBoolean(parameterIndex, ((Number)x).intValue() != 0);
                    break;
                }
                throw new SQLException("Invalid type for boolean: " + x.getClass().getName());
            }
            case -6: {
                if (x instanceof Number) {
                    this.setByte(parameterIndex, ((Number)x).byteValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setByte(parameterIndex, (byte)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Invalid type for byte: " + x.getClass().getName());
            }
            case 5: {
                if (x instanceof Number) {
                    this.setShort(parameterIndex, ((Number)x).shortValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setShort(parameterIndex, (short)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Invalid type for short: " + x.getClass().getName());
            }
            case 4: {
                if (x instanceof Number) {
                    this.setInt(parameterIndex, ((Number)x).intValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setInt(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Invalid type for int: " + x.getClass().getName());
            }
            case -5: {
                if (x instanceof Number) {
                    this.setLong(parameterIndex, ((Number)x).longValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setLong(parameterIndex, (Boolean)x != false ? 1L : 0L);
                    break;
                }
                throw new SQLException("Invalid type for long: " + x.getClass().getName());
            }
            case 6: {
                if (x instanceof Number) {
                    this.setFloat(parameterIndex, ((Number)x).floatValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setFloat(parameterIndex, (Boolean)x != false ? 1.0f : 0.0f);
                    break;
                }
                throw new SQLException("Invalid type for float: " + x.getClass().getName());
            }
            case 8: {
                if (x instanceof Number) {
                    this.setDouble(parameterIndex, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setDouble(parameterIndex, (Boolean)x != false ? 1.0 : 0.0);
                    break;
                }
                throw new SQLException("Invalid type for double: " + x.getClass().getName());
            }
            case 93: {
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                    break;
                }
                if (x instanceof LocalDateTime) {
                    if (this.zoneId == null) {
                        this.setTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)x));
                        break;
                    }
                    ZonedDateTime zonedDateTime = ((LocalDateTime)x).atZone(this.zoneId);
                    Instant instant = zonedDateTime.toInstant();
                    long ts = DateTimeUtils.toLong(instant, this.stmtInfo.getPrecision());
                    this.setTimestampInner(parameterIndex, ts, false);
                    break;
                }
                if (x instanceof Instant) {
                    long ts = DateTimeUtils.toLong((Instant)x, this.stmtInfo.getPrecision());
                    this.setTimestampInner(parameterIndex, ts, false);
                    break;
                }
                if (x instanceof ZonedDateTime) {
                    long ts = DateTimeUtils.toLong((ZonedDateTime)x, this.stmtInfo.getPrecision());
                    this.setTimestampInner(parameterIndex, ts, false);
                    break;
                }
                if (x instanceof OffsetDateTime) {
                    long ts = DateTimeUtils.toLong((OffsetDateTime)x, this.stmtInfo.getPrecision());
                    this.setTimestampInner(parameterIndex, ts, false);
                    break;
                }
                throw new SQLException("Invalid type for timestamp: " + x.getClass().getName());
            }
            case -15: 
            case -3: 
            case -2: 
            case 12: 
            case 1111: {
                if (x instanceof byte[]) {
                    this.setBytes(parameterIndex, (byte[])x);
                    break;
                }
                if (x instanceof String) {
                    this.setString(parameterIndex, (String)x);
                    break;
                }
                throw new SQLException("Invalid type for binary: " + x.getClass().getName());
            }
            case 2004: {
                if (x instanceof byte[]) {
                    this.setBytes(parameterIndex, (byte[])x);
                    break;
                }
                if (x instanceof Blob) {
                    this.setBytes(parameterIndex, ((Blob)x).getBytes(1L, (int)((Blob)x).length()));
                    break;
                }
                throw new SQLException("Invalid type for blob: " + x.getClass().getName());
            }
            default: {
                throw new SQLException("unsupported type: " + targetSqlType);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            byte fieldType = this.stmtInfo.getFields().get(parameterIndex - 1).getFieldType();
            if (fieldType >= 0) {
                this.setNullByTSDBType(parameterIndex, fieldType);
            } else {
                this.setNull(parameterIndex, -6);
            }
            return;
        }
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof String) {
            this.setNString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof LocalDateTime) {
            this.setObject(parameterIndex, x, 93);
        } else if (x instanceof Instant) {
            this.setObject(parameterIndex, x, 93);
        } else if (x instanceof ZonedDateTime) {
            this.setObject(parameterIndex, x, 93);
        } else if (x instanceof OffsetDateTime) {
            this.setObject(parameterIndex, x, 93);
        } else if (x instanceof BigInteger) {
            BigInteger v = (BigInteger)x;
            if (v.compareTo(BigInteger.ZERO) < 0 || v.compareTo(new BigInteger("18446744073709551615")) > 0) {
                throw TSDBError.createSQLException(8963, "ubigint value is out of range");
            }
            this.setLongInner(parameterIndex, ((BigInteger)x).longValue(), false, (byte)14);
        } else if (x instanceof Blob) {
            byte[] bytes = ((Blob)x).getBytes(1L, (int)((Blob)x).length());
            this.setBytesInner(parameterIndex, bytes, false, this.getTSDBType(parameterIndex, (byte)18));
        } else {
            throw new SQLException("Unsupported data type: " + x.getClass().getName());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.tagLensBuf.writeInt(this.curTableTagTotalLen);
        this.colLensBuf.writeInt(this.curTableColTotalLen);
        ++this.totalTableCount;
        this.clearCache();
    }

    private void clearCache() {
        this.curTableTagTotalLen = 0;
        this.curTableColTotalLen = 0;
    }

    private boolean isTableInfoEmpty() {
        return this.tableInfo.getTableName().capacity() == 0 && this.tableInfo.getTagInfo().isEmpty() && this.tableInfo.getDataList().isEmpty();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int affected = this.executeInsertImpl();
        int[] ints = new int[affected];
        int len = ints.length;
        for (int i = 0; i < len; ++i) {
            ints[i] = -2;
        }
        return ints;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (this.transport.isConnected() && this.stmtInfo.getStmtId() != 0L) {
                long reqId = ReqId.getReqID();
                Request close = RequestFactory.generateClose(this.stmtInfo.getStmtId(), reqId);
                this.transport.send(close);
            }
            super.close();
        }
        this.freeBuffers();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.getResultSet() == null) {
            return null;
        }
        return this.getResultSet().getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return new WSParameterMetaData(this.stmtInfo.isInsert(), this.stmtInfo.getFields(), this.stmtInfo.getColTypeList());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkBlobSupport();
        if (x == null) {
            this.setNullByTSDBType(parameterIndex, 18);
            return;
        }
        byte[] bytes = x.getBytes(1L, (int)x.length());
        this.setBytesInner(parameterIndex, bytes, false, this.getTSDBType(parameterIndex, (byte)18));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Instant instant = DateTimeUtils.toInstant(x, cal);
        this.setTimestamp(parameterIndex, Timestamp.from(instant));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkBlobSupport();
        this.setBytesInner(parameterIndex, BlobUtil.getFromInputStream(inputStream, length), false, this.getTSDBType(parameterIndex, (byte)18));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkBlobSupport();
        this.setBytesInner(parameterIndex, BlobUtil.getFromInputStream(inputStream), false, this.getTSDBType(parameterIndex, (byte)18));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    private void freeBuffer(AutoExpandingBuffer buf) {
        if (buf != null) {
            buf.release();
        }
    }

    private void freeBuffers() {
        this.freeBuffer(this.tableNameLensBuf);
        this.freeBuffer(this.tableNamesBuf);
        this.freeBuffer(this.tagLensBuf);
        this.freeBuffer(this.tagsBuf);
        this.freeBuffer(this.colLensBuf);
        this.freeBuffer(this.colsBuf);
    }

    private void buffersStopWrite() {
        if (this.tableNameLensBuf != null) {
            this.tableNameLensBuf.stopWrite();
        }
        if (this.tableNamesBuf != null) {
            this.tableNamesBuf.stopWrite();
        }
        if (this.tagLensBuf != null) {
            this.tagLensBuf.stopWrite();
        }
        if (this.tagsBuf != null) {
            this.tagsBuf.stopWrite();
        }
        if (this.colLensBuf != null) {
            this.colLensBuf.stopWrite();
        }
        if (this.colsBuf != null) {
            this.colsBuf.stopWrite();
        }
    }

    private CompositeByteBuf getRawBlock() {
        int totalTableNameSize = this.tableNamesBuf.getBuffer().capacity();
        int totalTagSize = this.tagsBuf.getBuffer().capacity();
        int totalColSize = this.colsBuf.getBuffer().capacity();
        int totalSize = totalTableNameSize + totalTagSize + totalColSize;
        int toBebindTableNameCount = this.stmtInfo.getToBeBindTableNameIndex() >= 0 ? 1 : 0;
        totalSize += this.totalTableCount * (toBebindTableNameCount * 2 + (this.stmtInfo.getToBeBindTagCount() > 0 ? 1 : 0) * 4 + (this.stmtInfo.getToBeBindColCount() > 0 ? 1 : 0) * 4);
        ByteBuf headBuf = PooledByteBufAllocator.DEFAULT.directBuffer(58);
        long reqId = ReqId.getReqID();
        headBuf.writeLongLE(reqId);
        headBuf.writeLongLE(this.stmtInfo.getStmtId());
        headBuf.writeLongLE(9L);
        headBuf.writeShortLE(1);
        headBuf.writeIntLE(-1);
        headBuf.writeIntLE(totalSize + 28);
        headBuf.writeIntLE(this.totalTableCount);
        headBuf.writeIntLE(this.stmtInfo.getToBeBindTagCount());
        headBuf.writeIntLE(this.stmtInfo.getToBeBindColCount());
        if (toBebindTableNameCount > 0) {
            headBuf.writeIntLE(28);
        } else {
            headBuf.writeIntLE(0);
        }
        if (this.stmtInfo.getToBeBindTagCount() > 0) {
            if (toBebindTableNameCount > 0) {
                headBuf.writeIntLE(28 + totalTableNameSize + 2 * this.totalTableCount);
            } else {
                headBuf.writeIntLE(28);
            }
        } else {
            headBuf.writeIntLE(0);
        }
        if (this.stmtInfo.getToBeBindColCount() > 0) {
            int skipSize = 0;
            if (toBebindTableNameCount > 0) {
                skipSize += totalTableNameSize + 2 * this.totalTableCount;
            }
            if (this.stmtInfo.getToBeBindTagCount() > 0) {
                skipSize += totalTagSize + 4 * this.totalTableCount;
            }
            headBuf.writeIntLE(28 + skipSize);
        } else {
            headBuf.writeIntLE(0);
        }
        CompositeByteBuf rawBlock = PooledByteBufAllocator.DEFAULT.compositeBuffer();
        rawBlock.addComponent(true, headBuf);
        if (toBebindTableNameCount > 0) {
            rawBlock.addComponent(true, (ByteBuf)this.tableNameLensBuf.getBuffer());
            rawBlock.addComponent(true, (ByteBuf)this.tableNamesBuf.getBuffer());
        }
        if (this.stmtInfo.getToBeBindTagCount() > 0) {
            rawBlock.addComponent(true, (ByteBuf)this.tagLensBuf.getBuffer());
            rawBlock.addComponent(true, (ByteBuf)this.tagsBuf.getBuffer());
        }
        if (this.stmtInfo.getToBeBindColCount() > 0) {
            rawBlock.addComponent(true, (ByteBuf)this.colLensBuf.getBuffer());
            rawBlock.addComponent(true, (ByteBuf)this.colsBuf.getBuffer());
        }
        return rawBlock;
    }

    private int executeInsertImpl() throws SQLException {
        this.buffersStopWrite();
        CompositeByteBuf rawBlock = this.getRawBlock();
        try {
            this.affectedRows = 0;
            this.writeBlockWithRetrySync((ByteBuf)rawBlock);
            this.affectedRows = this.batchInsertedRows.getAndSet(0);
        }
        finally {
            this.initBuffers();
            this.totalTableCount = 0;
        }
        return this.affectedRows;
    }

    private ResultResp executeQueryImpl() throws SQLException {
        this.buffersStopWrite();
        CompositeByteBuf rawBlock = this.getRawBlock();
        try {
            ResultResp resultResp = this.queryWithRetry((ByteBuf)rawBlock);
            return resultResp;
        }
        finally {
            this.initBuffers();
            this.totalTableCount = 0;
        }
    }
}

