/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.WrapperImpl;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

public abstract class AbstractParameterMetaData
extends WrapperImpl
implements ParameterMetaData {
    private final Object[] parameters;

    public AbstractParameterMetaData(Object[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        if (param < 1 && param >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        if (this.parameters[param - 1] instanceof Byte) {
            return true;
        }
        if (this.parameters[param - 1] instanceof Short) {
            return true;
        }
        if (this.parameters[param - 1] instanceof Integer) {
            return true;
        }
        if (this.parameters[param - 1] instanceof Long) {
            return true;
        }
        if (this.parameters[param - 1] instanceof Float) {
            return true;
        }
        return this.parameters[param - 1] instanceof Double;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        if (param < 1 && param >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        if (this.parameters[param - 1] instanceof Boolean) {
            return 1;
        }
        if (this.parameters[param - 1] instanceof Byte) {
            return 3;
        }
        if (this.parameters[param - 1] instanceof Short) {
            return 5;
        }
        if (this.parameters[param - 1] instanceof Integer) {
            return 10;
        }
        if (this.parameters[param - 1] instanceof Long) {
            return 19;
        }
        if (this.parameters[param - 1] instanceof Timestamp) {
            return 23;
        }
        if (this.parameters[param - 1] instanceof Float) {
            return 12;
        }
        if (this.parameters[param - 1] instanceof Double) {
            return 22;
        }
        if (this.parameters[param - 1] instanceof String) {
            return ((String)this.parameters[param - 1]).length();
        }
        if (this.parameters[param - 1] instanceof byte[]) {
            return ((byte[])this.parameters[param - 1]).length;
        }
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (param < 1 && param >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        if (this.parameters[param - 1] instanceof Float) {
            return 31;
        }
        if (this.parameters[param - 1] instanceof Double) {
            return 31;
        }
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        if (param < 1 && param >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        if (this.parameters[param - 1] instanceof Timestamp) {
            return 93;
        }
        if (this.parameters[param - 1] instanceof Instant) {
            return 93;
        }
        if (this.parameters[param - 1] instanceof Byte) {
            return -6;
        }
        if (this.parameters[param - 1] instanceof Short) {
            return 5;
        }
        if (this.parameters[param - 1] instanceof Integer) {
            return 4;
        }
        if (this.parameters[param - 1] instanceof Long) {
            return -5;
        }
        if (this.parameters[param - 1] instanceof Float) {
            return 6;
        }
        if (this.parameters[param - 1] instanceof Double) {
            return 8;
        }
        if (this.parameters[param - 1] instanceof String) {
            return -15;
        }
        if (this.parameters[param - 1] instanceof byte[]) {
            return -2;
        }
        if (this.parameters[param - 1] instanceof Boolean) {
            return 16;
        }
        return 1111;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        if (param < 1 && param >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        if (this.parameters[param - 1] instanceof Instant) {
            return TSDBConstants.jdbcType2TaosTypeName(93);
        }
        if (this.parameters[param - 1] instanceof Timestamp) {
            return TSDBConstants.jdbcType2TaosTypeName(93);
        }
        if (this.parameters[param - 1] instanceof Byte) {
            return TSDBConstants.jdbcType2TaosTypeName(-6);
        }
        if (this.parameters[param - 1] instanceof Short) {
            return TSDBConstants.jdbcType2TaosTypeName(5);
        }
        if (this.parameters[param - 1] instanceof Integer) {
            return TSDBConstants.jdbcType2TaosTypeName(4);
        }
        if (this.parameters[param - 1] instanceof Long) {
            return TSDBConstants.jdbcType2TaosTypeName(-5);
        }
        if (this.parameters[param - 1] instanceof Float) {
            return TSDBConstants.jdbcType2TaosTypeName(6);
        }
        if (this.parameters[param - 1] instanceof Double) {
            return TSDBConstants.jdbcType2TaosTypeName(8);
        }
        if (this.parameters[param - 1] instanceof String) {
            return TSDBConstants.jdbcType2TaosTypeName(-15);
        }
        if (this.parameters[param - 1] instanceof byte[]) {
            return TSDBConstants.jdbcType2TaosTypeName(-2);
        }
        if (this.parameters[param - 1] instanceof Boolean) {
            return TSDBConstants.jdbcType2TaosTypeName(16);
        }
        return this.parameters[param - 1].getClass().getName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        if (param < 1 && param >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        return this.parameters[param - 1].getClass().getName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        if (param < 1 && param >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        return 0;
    }
}

