/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.entity;

import com.taosdata.jdbc.ws.entity.CommonResp;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.FetchBlockNewResp;
import com.taosdata.jdbc.ws.entity.FetchResp;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.entity.VersionResp;
import com.taosdata.jdbc.ws.stmt2.entity.ResultResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2ExecResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2PrepareResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2Resp;
import com.taosdata.jdbc.ws.tmq.entity.FetchRawBlockResp;
import java.util.HashMap;
import java.util.Map;

public enum Action {
    VERSION("version", VersionResp.class),
    CONN("conn", ConnectResp.class),
    QUERY("query", QueryResp.class),
    BINARY_QUERY("binary_query", QueryResp.class),
    FETCH("fetch", FetchResp.class),
    FETCH_BLOCK("fetch_raw_block", FetchRawBlockResp.class),
    FETCH_BLOCK_NEW("fetch_block_new", FetchBlockNewResp.class),
    FREE_RESULT("free_result", Response.class),
    STMT2_INIT("stmt2_init", Stmt2Resp.class),
    STMT2_PREPARE("stmt2_prepare", Stmt2PrepareResp.class),
    STMT2_BIND("stmt2_bind", Stmt2Resp.class),
    STMT2_EXEC("stmt2_exec", Stmt2ExecResp.class),
    STMT2_CLOSE("stmt2_close", Stmt2Resp.class),
    STMT2_USE_RESULT("stmt2_result", ResultResp.class),
    INSERT("insert", CommonResp.class);

    private final String action;
    private final Class<? extends Response> clazz;
    private static final Map<String, Action> actions;

    private Action(String action, Class<? extends Response> clazz) {
        this.action = action;
        this.clazz = clazz;
    }

    public String getAction() {
        return this.action;
    }

    public Class<? extends Response> getResponseClazz() {
        return this.clazz;
    }

    public static Action of(String action) {
        if (null == action || action.equals("")) {
            return null;
        }
        return actions.get(action);
    }

    static {
        actions = new HashMap<String, Action>();
        for (Action value : Action.values()) {
            actions.put(value.action, value);
        }
    }
}

