/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.header.HttpDateFormat;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.spi.StringReader;
import com.sun.jersey.spi.StringReaderProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Date;
import javax.ws.rs.WebApplicationException;

public class StringReaderProviders {

    public static class DateProvider
    implements StringReaderProvider {
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (type != Date.class) {
                return null;
            }
            return new StringReader(){

                public Object fromString(String value) {
                    try {
                        return HttpDateFormat.readDate((String)value);
                    }
                    catch (ParseException ex) {
                        throw new ContainerException(ex);
                    }
                }
            };
        }
    }

    public static class TypeValueOf
    implements StringReaderProvider {
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            final Method valueOf = ReflectionHelper.getValueOfStringMethod((Class)type);
            if (valueOf == null) {
                return null;
            }
            return new StringReader(){

                public Object fromString(String value) {
                    try {
                        return valueOf.invoke(null, value);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable target = ex.getTargetException();
                        if (target instanceof WebApplicationException) {
                            throw (WebApplicationException)target;
                        }
                        throw new ContainerException(target);
                    }
                    catch (RuntimeException ex) {
                        throw new ContainerException(ex);
                    }
                    catch (Exception ex) {
                        throw new ContainerException(ex);
                    }
                }
            };
        }
    }

    public static class StringConstructor
    implements StringReaderProvider {
        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            final Constructor constructor = ReflectionHelper.getStringConstructor((Class)type);
            if (constructor == null) {
                return null;
            }
            return new StringReader(){

                public Object fromString(String value) {
                    if (value.length() == 0) {
                        return null;
                    }
                    try {
                        return constructor.newInstance(value);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable target = ex.getTargetException();
                        if (target instanceof WebApplicationException) {
                            throw (WebApplicationException)target;
                        }
                        throw new ContainerException(target);
                    }
                    catch (RuntimeException ex) {
                        throw new ContainerException(ex);
                    }
                    catch (Exception ex) {
                        throw new ContainerException(ex);
                    }
                }
            };
        }
    }
}

