/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c2\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c2\u0003J=\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lokhttp3/Handshake;", "", "tlsVersion", "Lokhttp3/TlsVersion;", "cipherSuite", "Lokhttp3/CipherSuite;", "peerCertificates", "", "Ljava/security/cert/Certificate;", "localCertificates", "(Lokhttp3/TlsVersion;Lokhttp3/CipherSuite;Ljava/util/List;Ljava/util/List;)V", "name", "", "getName", "(Ljava/security/cert/Certificate;)Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "localPrincipal", "Ljava/security/Principal;", "peerPrincipal", "toString", "Companion", "okhttp"})
public final class Handshake {
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List<Certificate> peerCertificates;
    private final List<Certificate> localCertificates;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    @NotNull
    public final CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    @NotNull
    public final List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    @Nullable
    public final Principal peerPrincipal() {
        Principal principal;
        Collection collection = this.peerCertificates;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Certificate certificate = this.peerCertificates.get(0);
            if (certificate == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            principal = ((X509Certificate)certificate).getSubjectX500Principal();
        } else {
            principal = null;
        }
        return principal;
    }

    @NotNull
    public final List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    @Nullable
    public final Principal localPrincipal() {
        Principal principal;
        Collection collection = this.localCertificates;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Certificate certificate = this.localCertificates.get(0);
            if (certificate == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            principal = ((X509Certificate)certificate).getSubjectX500Principal();
        } else {
            principal = null;
        }
        return principal;
    }

    @NotNull
    public String toString() {
        String string;
        Certificate it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.peerCertificates;
        StringBuilder stringBuilder = new StringBuilder().append("Handshake{").append("tlsVersion=").append((Object)this.tlsVersion).append(' ').append("cipherSuite=").append(this.cipherSuite).append(' ').append("peerCertificates=");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Certificate certificate = (Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = this.getName(it);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = this.localCertificates;
        stringBuilder = stringBuilder.append(collection).append(' ').append("localCertificates=");
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = this.getName(it);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(collection).append('}').toString();
    }

    private final String getName(@NotNull Certificate $this$name) {
        String string;
        Certificate certificate = $this$name;
        if (certificate instanceof X509Certificate) {
            string = ((Object)((X509Certificate)$this$name).getSubjectDN()).toString();
        } else {
            String string2 = $this$name.getType();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type");
        }
        return string;
    }

    private Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<? extends Certificate> peerCertificates, List<? extends Certificate> localCertificates) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.peerCertificates = peerCertificates;
        this.localCertificates = localCertificates;
    }

    public /* synthetic */ Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List peerCertificates, List localCertificates, DefaultConstructorMarker $constructor_marker) {
        this(tlsVersion, cipherSuite, peerCertificates, localCertificates);
    }

    private final TlsVersion component1() {
        return this.tlsVersion;
    }

    private final CipherSuite component2() {
        return this.cipherSuite;
    }

    private final List<Certificate> component3() {
        return this.peerCertificates;
    }

    private final List<Certificate> component4() {
        return this.localCertificates;
    }

    @NotNull
    public final Handshake copy(@NotNull TlsVersion tlsVersion, @NotNull CipherSuite cipherSuite, @NotNull List<? extends Certificate> peerCertificates, @NotNull List<? extends Certificate> localCertificates) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tlsVersion), (String)"tlsVersion");
        Intrinsics.checkParameterIsNotNull((Object)cipherSuite, (String)"cipherSuite");
        Intrinsics.checkParameterIsNotNull(peerCertificates, (String)"peerCertificates");
        Intrinsics.checkParameterIsNotNull(localCertificates, (String)"localCertificates");
        return new Handshake(tlsVersion, cipherSuite, peerCertificates, localCertificates);
    }

    @NotNull
    public static /* synthetic */ Handshake copy$default(Handshake handshake, TlsVersion tlsVersion, CipherSuite cipherSuite, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            tlsVersion = handshake.tlsVersion;
        }
        if ((n & 2) != 0) {
            cipherSuite = handshake.cipherSuite;
        }
        if ((n & 4) != 0) {
            list = handshake.peerCertificates;
        }
        if ((n & 8) != 0) {
            list2 = handshake.localCertificates;
        }
        return handshake.copy(tlsVersion, cipherSuite, list, list2);
    }

    public int hashCode() {
        TlsVersion tlsVersion = this.tlsVersion;
        CipherSuite cipherSuite = this.cipherSuite;
        List<Certificate> list = this.peerCertificates;
        List<Certificate> list2 = this.localCertificates;
        return (((tlsVersion != null ? ((Object)((Object)tlsVersion)).hashCode() : 0) * 31 + (cipherSuite != null ? cipherSuite.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Handshake)) break block3;
                Handshake handshake = (Handshake)object;
                if (!Intrinsics.areEqual((Object)((Object)this.tlsVersion), (Object)((Object)handshake.tlsVersion)) || !Intrinsics.areEqual((Object)this.cipherSuite, (Object)handshake.cipherSuite) || !Intrinsics.areEqual(this.peerCertificates, handshake.peerCertificates) || !Intrinsics.areEqual(this.localCertificates, handshake.localCertificates)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Handshake get(@NotNull SSLSession session) throws IOException {
        return Companion.get(session);
    }

    @JvmStatic
    @NotNull
    public static final Handshake get(@NotNull TlsVersion tlsVersion, @NotNull CipherSuite cipherSuite, @NotNull List<? extends Certificate> peerCertificates, @NotNull List<? extends Certificate> localCertificates) {
        return Companion.get(tlsVersion, cipherSuite, peerCertificates, localCertificates);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u00a8\u0006\u000f"}, d2={"Lokhttp3/Handshake$Companion;", "", "()V", "get", "Lokhttp3/Handshake;", "session", "Ljavax/net/ssl/SSLSession;", "tlsVersion", "Lokhttp3/TlsVersion;", "cipherSuite", "Lokhttp3/CipherSuite;", "peerCertificates", "", "Ljava/security/cert/Certificate;", "localCertificates", "okhttp"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Handshake get(@NotNull SSLSession session) throws IOException {
            Certificate[] certificateArray;
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            String string = session.getCipherSuite();
            boolean bl = false;
            boolean bl2 = false;
            if (string == null) {
                boolean bl3 = false;
                String string2 = "cipherSuite == null";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String cipherSuiteString = string;
            if (Intrinsics.areEqual((Object)"SSL_NULL_WITH_NULL_NULL", (Object)cipherSuiteString)) {
                throw (Throwable)new IOException("cipherSuite == SSL_NULL_WITH_NULL_NULL");
            }
            CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
            String string3 = session.getProtocol();
            if (string3 == null) {
                throw (Throwable)new IllegalStateException("tlsVersion == null");
            }
            String tlsVersionString = string3;
            if (Intrinsics.areEqual((Object)"NONE", (Object)tlsVersionString)) {
                throw (Throwable)new IOException("tlsVersion == NONE");
            }
            TlsVersion tlsVersion = TlsVersion.Companion.forJavaName(tlsVersionString);
            try {
                certificateArray = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException ignored) {
                certificateArray = null;
            }
            Certificate[] peerCertificates = certificateArray;
            List<Certificate> peerCertificatesList = peerCertificates != null ? Util.immutableList(Arrays.copyOf(peerCertificates, peerCertificates.length)) : CollectionsKt.emptyList();
            Certificate[] localCertificates = session.getLocalCertificates();
            List<Certificate> localCertificatesList = localCertificates != null ? Util.immutableList(Arrays.copyOf(localCertificates, localCertificates.length)) : CollectionsKt.emptyList();
            List<Certificate> list = peerCertificatesList;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"peerCertificatesList");
            List<Certificate> list2 = localCertificatesList;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"localCertificatesList");
            return new Handshake(tlsVersion, cipherSuite, list, list2, null);
        }

        @JvmStatic
        @NotNull
        public final Handshake get(@NotNull TlsVersion tlsVersion, @NotNull CipherSuite cipherSuite, @NotNull List<? extends Certificate> peerCertificates, @NotNull List<? extends Certificate> localCertificates) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)tlsVersion), (String)"tlsVersion");
            Intrinsics.checkParameterIsNotNull((Object)cipherSuite, (String)"cipherSuite");
            Intrinsics.checkParameterIsNotNull(peerCertificates, (String)"peerCertificates");
            Intrinsics.checkParameterIsNotNull(localCertificates, (String)"localCertificates");
            List<? extends Certificate> list = Util.immutableList(peerCertificates);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Util.immutableList(peerCertificates)");
            List<? extends Certificate> list2 = Util.immutableList(localCertificates);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Util.immutableList(localCertificates)");
            return new Handshake(tlsVersion, cipherSuite, list, list2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

