/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mockwebserver3.MockResponseBody;
import mockwebserver3.PushPromise;
import mockwebserver3.SocketEffect;
import mockwebserver3.SocketHandler;
import mockwebserver3.internal.MockResponseBodiesKt;
import okhttp3.Headers;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001RB'\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0006\u0010P\u001a\u00020\u000bJ\b\u0010Q\u001a\u00020\u0007H\u0016R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0011\u00101\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010&R\u0013\u00103\u001a\u0004\u0018\u000104\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010&R\u0013\u00109\u001a\u0004\u0018\u000104\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00106R\u0013\u0010;\u001a\u0004\u0018\u000104\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00106R\u0013\u0010=\u001a\u0004\u0018\u000104\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00106R\u0013\u0010?\u001a\u0004\u0018\u000104\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00106R\u0011\u0010A\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010&R\u0011\u0010C\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010.R\u0011\u0010E\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010.R\u0011\u0010G\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010.R\u0017\u0010I\u001a\b\u0012\u0004\u0012\u00020J0(\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010*R\u0011\u0010L\u001a\u00020M\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010O\u00a8\u0006S"}, d2={"Lmockwebserver3/MockResponse;", "", "code", "", "headers", "Lokhttp3/Headers;", "body", "", "<init>", "(ILokhttp3/Headers;Ljava/lang/String;)V", "builder", "Lmockwebserver3/MockResponse$Builder;", "(Lmockwebserver3/MockResponse$Builder;)V", "status", "getStatus", "()Ljava/lang/String;", "getCode", "()I", "message", "getMessage", "getHeaders", "()Lokhttp3/Headers;", "trailers", "getTrailers", "Lmockwebserver3/MockResponseBody;", "getBody", "()Lmockwebserver3/MockResponseBody;", "webSocketListener", "Lokhttp3/WebSocketListener;", "getWebSocketListener", "()Lokhttp3/WebSocketListener;", "socketHandler", "Lmockwebserver3/SocketHandler;", "getSocketHandler", "()Lmockwebserver3/SocketHandler;", "inTunnel", "", "getInTunnel", "()Z", "informationalResponses", "", "getInformationalResponses", "()Ljava/util/List;", "throttleBytesPerPeriod", "", "getThrottleBytesPerPeriod", "()J", "throttlePeriodNanos", "getThrottlePeriodNanos", "failHandshake", "getFailHandshake", "onRequestStart", "Lmockwebserver3/SocketEffect;", "getOnRequestStart", "()Lmockwebserver3/SocketEffect;", "doNotReadRequestBody", "getDoNotReadRequestBody", "onRequestBody", "getOnRequestBody", "onResponseStart", "getOnResponseStart", "onResponseBody", "getOnResponseBody", "onResponseEnd", "getOnResponseEnd", "shutdownServer", "getShutdownServer", "headersDelayNanos", "getHeadersDelayNanos", "bodyDelayNanos", "getBodyDelayNanos", "trailersDelayNanos", "getTrailersDelayNanos", "pushPromises", "Lmockwebserver3/PushPromise;", "getPushPromises", "settings", "Lokhttp3/internal/http2/Settings;", "getSettings", "()Lokhttp3/internal/http2/Settings;", "newBuilder", "toString", "Builder", "mockwebserver3"})
@SourceDebugExtension(value={"SMAP\nMockResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockResponse.kt\nmockwebserver3/MockResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,576:1\n1#2:577\n*E\n"})
public final class MockResponse {
    @NotNull
    private final String status;
    @NotNull
    private final Headers headers;
    @NotNull
    private final Headers trailers;
    @Nullable
    private final MockResponseBody body;
    @Nullable
    private final WebSocketListener webSocketListener;
    @Nullable
    private final SocketHandler socketHandler;
    private final boolean inTunnel;
    @NotNull
    private final List<MockResponse> informationalResponses;
    private final long throttleBytesPerPeriod;
    private final long throttlePeriodNanos;
    private final boolean failHandshake;
    @Nullable
    private final SocketEffect onRequestStart;
    private final boolean doNotReadRequestBody;
    @Nullable
    private final SocketEffect onRequestBody;
    @Nullable
    private final SocketEffect onResponseStart;
    @Nullable
    private final SocketEffect onResponseBody;
    @Nullable
    private final SocketEffect onResponseEnd;
    private final boolean shutdownServer;
    private final long headersDelayNanos;
    private final long bodyDelayNanos;
    private final long trailersDelayNanos;
    @NotNull
    private final List<PushPromise> pushPromises;
    @NotNull
    private final Settings settings;

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    public final int getCode() {
        char[] cArray = new char[]{' '};
        List statusParts = StringsKt.split$default((CharSequence)this.status, (char[])cArray, (boolean)false, (int)3, (int)2, null);
        if (!(statusParts.size() >= 2)) {
            boolean bl = false;
            String string = "Unexpected status: " + this.status;
            throw new IllegalArgumentException(string.toString());
        }
        return Integer.parseInt((String)statusParts.get(1));
    }

    @NotNull
    public final String getMessage() {
        char[] cArray = new char[]{' '};
        List statusParts = StringsKt.split$default((CharSequence)this.status, (char[])cArray, (boolean)false, (int)3, (int)2, null);
        if (!(statusParts.size() >= 2)) {
            boolean bl = false;
            String string = "Unexpected status: " + this.status;
            throw new IllegalArgumentException(string.toString());
        }
        return (String)statusParts.get(2);
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Headers getTrailers() {
        return this.trailers;
    }

    @Nullable
    public final MockResponseBody getBody() {
        return this.body;
    }

    @Nullable
    public final WebSocketListener getWebSocketListener() {
        return this.webSocketListener;
    }

    @Nullable
    public final SocketHandler getSocketHandler() {
        return this.socketHandler;
    }

    public final boolean getInTunnel() {
        return this.inTunnel;
    }

    @NotNull
    public final List<MockResponse> getInformationalResponses() {
        return this.informationalResponses;
    }

    public final long getThrottleBytesPerPeriod() {
        return this.throttleBytesPerPeriod;
    }

    public final long getThrottlePeriodNanos() {
        return this.throttlePeriodNanos;
    }

    public final boolean getFailHandshake() {
        return this.failHandshake;
    }

    @Nullable
    public final SocketEffect getOnRequestStart() {
        return this.onRequestStart;
    }

    public final boolean getDoNotReadRequestBody() {
        return this.doNotReadRequestBody;
    }

    @Nullable
    public final SocketEffect getOnRequestBody() {
        return this.onRequestBody;
    }

    @Nullable
    public final SocketEffect getOnResponseStart() {
        return this.onResponseStart;
    }

    @Nullable
    public final SocketEffect getOnResponseBody() {
        return this.onResponseBody;
    }

    @Nullable
    public final SocketEffect getOnResponseEnd() {
        return this.onResponseEnd;
    }

    public final boolean getShutdownServer() {
        return this.shutdownServer;
    }

    public final long getHeadersDelayNanos() {
        return this.headersDelayNanos;
    }

    public final long getBodyDelayNanos() {
        return this.bodyDelayNanos;
    }

    public final long getTrailersDelayNanos() {
        return this.trailersDelayNanos;
    }

    @NotNull
    public final List<PushPromise> getPushPromises() {
        return this.pushPromises;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    public MockResponse(int code, @NotNull Headers headers, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this(new Builder().code(code).headers(headers).body(body));
    }

    public /* synthetic */ MockResponse(int n, Headers headers, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        if ((n2 & 2) != 0) {
            headers = Headers.Companion.of(new String[0]);
        }
        if ((n2 & 4) != 0) {
            string = "";
        }
        this(n, headers, string);
    }

    private MockResponse(Builder builder) {
        this.status = builder.getStatus();
        this.headers = builder.getHeaders();
        this.trailers = builder.getTrailers();
        this.body = builder.getBody();
        this.socketHandler = builder.getSocketHandler();
        this.webSocketListener = builder.getWebSocketListener();
        this.inTunnel = builder.getInTunnel();
        this.informationalResponses = builder.getInformationalResponses();
        this.throttleBytesPerPeriod = builder.getThrottleBytesPerPeriod();
        this.throttlePeriodNanos = builder.getThrottlePeriodNanos();
        this.failHandshake = builder.getFailHandshake();
        this.onRequestStart = builder.getOnRequestStart();
        this.doNotReadRequestBody = builder.getDoNotReadRequestBody();
        this.onRequestBody = builder.getOnRequestBody();
        this.onResponseStart = builder.getOnResponseStart();
        this.onResponseBody = builder.getOnResponseBody();
        this.onResponseEnd = builder.getOnResponseEnd();
        this.shutdownServer = builder.getShutdownServer();
        this.headersDelayNanos = builder.getHeadersDelayNanos();
        this.bodyDelayNanos = builder.getBodyDelayNanos();
        this.trailersDelayNanos = builder.getTrailersDelayNanos();
        this.pushPromises = builder.getPushPromises();
        this.settings = builder.getSettings();
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    @NotNull
    public String toString() {
        return this.status;
    }

    public /* synthetic */ MockResponse(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010a\u001a\u00020\u0000J\u000e\u0010b\u001a\u00020\u00002\u0006\u0010c\u001a\u00020\u0012J\u0016\u0010b\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020eJ\u0016\u0010f\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020eJ\u0016\u0010g\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020eJ\u000e\u0010h\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u0012J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020iJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020&J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0012J\u000e\u00100\u001a\u00020\u00002\u0006\u00100\u001a\u00020(J\u0018\u0010j\u001a\u00020\u00002\u0006\u0010+\u001a\u00020i2\b\b\u0002\u0010k\u001a\u00020\u0016J\u0018\u0010j\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00122\b\b\u0002\u0010k\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010@\u001a\u00020\u0000J\u0010\u0010C\u001a\u00020\u00002\b\u0010l\u001a\u0004\u0018\u00010BJ\u0006\u0010F\u001a\u00020\u0000J\u0010\u0010H\u001a\u00020\u00002\b\u0010l\u001a\u0004\u0018\u00010BJ\u0010\u0010J\u001a\u00020\u00002\b\u0010l\u001a\u0004\u0018\u00010BJ\u0010\u0010L\u001a\u00020\u00002\b\u0010l\u001a\u0004\u0018\u00010BJ\u0010\u0010N\u001a\u00020\u00002\b\u0010l\u001a\u0004\u0018\u00010BJ\u000e\u0010P\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\bJ\u001e\u0010m\u001a\u00020\u00002\u0006\u0010n\u001a\u00020:2\u0006\u0010o\u001a\u00020:2\u0006\u0010p\u001a\u00020qJ\u0016\u0010r\u001a\u00020\u00002\u0006\u0010s\u001a\u00020:2\u0006\u0010p\u001a\u00020qJ\u0016\u0010t\u001a\u00020\u00002\u0006\u0010s\u001a\u00020:2\u0006\u0010p\u001a\u00020qJ\u0016\u0010u\u001a\u00020\u00002\u0006\u0010s\u001a\u00020:2\u0006\u0010p\u001a\u00020qJ\u000e\u0010v\u001a\u00020\u00002\u0006\u0010w\u001a\u00020YJ\u000e\u0010^\u001a\u00020\u00002\u0006\u0010^\u001a\u00020]J\u000e\u0010x\u001a\u00020\u00002\u0006\u0010y\u001a\u00020*J\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010z\u001a\u00020\u00002\u0006\u0010{\u001a\u00020\u0005J\u0006\u0010|\u001a\u00020\u0000J\b\u0010}\u001a\u00020\u0000H\u0016J\u0006\u0010~\u001a\u00020\u0005R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00168F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010!R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010+\u001a\u0004\u0018\u00010&2\b\u0010\u0007\u001a\u0004\u0018\u00010&8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R(\u00100\u001a\u0004\u0018\u00010(2\b\u0010\u0007\u001a\u0004\u0018\u00010(8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R(\u00105\u001a\u0004\u0018\u00010*2\b\u0010\u0007\u001a\u0004\u0018\u00010*8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001e\u0010;\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020:@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001e\u0010>\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020:@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010=R\u001e\u0010@\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u000bR\"\u0010C\u001a\u0004\u0018\u00010B2\b\u0010\u0007\u001a\u0004\u0018\u00010B@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u001e\u0010F\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u000bR\"\u0010H\u001a\u0004\u0018\u00010B2\b\u0010\u0007\u001a\u0004\u0018\u00010B@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010ER\"\u0010J\u001a\u0004\u0018\u00010B2\b\u0010\u0007\u001a\u0004\u0018\u00010B@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010ER\"\u0010L\u001a\u0004\u0018\u00010B2\b\u0010\u0007\u001a\u0004\u0018\u00010B@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010ER\"\u0010N\u001a\u0004\u0018\u00010B2\b\u0010\u0007\u001a\u0004\u0018\u00010B@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010ER\u001e\u0010P\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\u000bR\u001e\u0010R\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020:@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010=R\u001e\u0010T\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020:@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010=R\u001e\u0010V\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020:@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010=R\u0014\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020Y0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u0011R\u000e\u0010\\\u001a\u00020]X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010^\u001a\u00020]8F\u00a2\u0006\u0006\u001a\u0004\b_\u0010`\u00a8\u0006\u007f"}, d2={"Lmockwebserver3/MockResponse$Builder;", "", "<init>", "()V", "mockResponse", "Lmockwebserver3/MockResponse;", "(Lmockwebserver3/MockResponse;)V", "value", "", "inTunnel", "getInTunnel", "()Z", "informationalResponses_", "", "informationalResponses", "", "getInformationalResponses", "()Ljava/util/List;", "", "status", "getStatus", "()Ljava/lang/String;", "", "code", "getCode", "()I", "setCode", "(I)V", "headers_", "Lokhttp3/Headers$Builder;", "headers", "Lokhttp3/Headers;", "getHeaders", "()Lokhttp3/Headers;", "trailers_", "trailers", "getTrailers", "bodyVar", "Lmockwebserver3/MockResponseBody;", "socketHandlerVar", "Lmockwebserver3/SocketHandler;", "webSocketListenerVar", "Lokhttp3/WebSocketListener;", "body", "getBody", "()Lmockwebserver3/MockResponseBody;", "setBody", "(Lmockwebserver3/MockResponseBody;)V", "socketHandler", "getSocketHandler", "()Lmockwebserver3/SocketHandler;", "setSocketHandler", "(Lmockwebserver3/SocketHandler;)V", "webSocketListener", "getWebSocketListener", "()Lokhttp3/WebSocketListener;", "setWebSocketListener", "(Lokhttp3/WebSocketListener;)V", "", "throttleBytesPerPeriod", "getThrottleBytesPerPeriod", "()J", "throttlePeriodNanos", "getThrottlePeriodNanos", "failHandshake", "getFailHandshake", "Lmockwebserver3/SocketEffect;", "onRequestStart", "getOnRequestStart", "()Lmockwebserver3/SocketEffect;", "doNotReadRequestBody", "getDoNotReadRequestBody", "onRequestBody", "getOnRequestBody", "onResponseStart", "getOnResponseStart", "onResponseBody", "getOnResponseBody", "onResponseEnd", "getOnResponseEnd", "shutdownServer", "getShutdownServer", "headersDelayNanos", "getHeadersDelayNanos", "bodyDelayNanos", "getBodyDelayNanos", "trailersDelayNanos", "getTrailersDelayNanos", "pushPromises_", "Lmockwebserver3/PushPromise;", "pushPromises", "getPushPromises", "settings_", "Lokhttp3/internal/http2/Settings;", "settings", "getSettings", "()Lokhttp3/internal/http2/Settings;", "clearHeaders", "addHeader", "header", "name", "", "addHeaderLenient", "setHeader", "removeHeader", "Lokio/Buffer;", "chunkedBody", "maxChunkSize", "socketEffect", "throttleBody", "bytesPerPeriod", "period", "unit", "Ljava/util/concurrent/TimeUnit;", "headersDelay", "delay", "bodyDelay", "trailersDelay", "addPush", "promise", "webSocketUpgrade", "listener", "addInformationalResponse", "response", "add100Continue", "clone", "build", "mockwebserver3"})
    @SourceDebugExtension(value={"SMAP\nMockResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockResponse.kt\nmockwebserver3/MockResponse$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,576:1\n1#2:577\n*E\n"})
    public static final class Builder
    implements Cloneable {
        private boolean inTunnel;
        @NotNull
        private final List<MockResponse> informationalResponses_;
        @NotNull
        private String status;
        @NotNull
        private Headers.Builder headers_;
        @NotNull
        private Headers.Builder trailers_;
        @Nullable
        private MockResponseBody bodyVar;
        @Nullable
        private SocketHandler socketHandlerVar;
        @Nullable
        private WebSocketListener webSocketListenerVar;
        private long throttleBytesPerPeriod;
        private long throttlePeriodNanos;
        private boolean failHandshake;
        @Nullable
        private SocketEffect onRequestStart;
        private boolean doNotReadRequestBody;
        @Nullable
        private SocketEffect onRequestBody;
        @Nullable
        private SocketEffect onResponseStart;
        @Nullable
        private SocketEffect onResponseBody;
        @Nullable
        private SocketEffect onResponseEnd;
        private boolean shutdownServer;
        private long headersDelayNanos;
        private long bodyDelayNanos;
        private long trailersDelayNanos;
        @NotNull
        private final List<PushPromise> pushPromises_;
        @NotNull
        private final Settings settings_;

        public final boolean getInTunnel() {
            return this.inTunnel;
        }

        @NotNull
        public final List<MockResponse> getInformationalResponses() {
            return CollectionsKt.toList((Iterable)this.informationalResponses_);
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        public final int getCode() {
            char[] cArray = new char[]{' '};
            List statusParts = StringsKt.split$default((CharSequence)this.status, (char[])cArray, (boolean)false, (int)3, (int)2, null);
            if (!(statusParts.size() >= 2)) {
                boolean bl = false;
                String string = "Unexpected status: " + this.status;
                throw new IllegalArgumentException(string.toString());
            }
            return Integer.parseInt((String)statusParts.get(1));
        }

        private final void setCode(int value) {
            String string;
            block1: {
                int n;
                block3: {
                    block2: {
                        block0: {
                            n = value;
                            boolean bl = 100 <= n ? n < 200 : false;
                            if (!bl) break block0;
                            string = "Informational";
                            break block1;
                        }
                        boolean bl = 200 <= n ? n < 300 : false;
                        if (!bl) break block2;
                        string = "OK";
                        break block1;
                    }
                    boolean bl = 300 <= n ? n < 400 : false;
                    if (!bl) break block3;
                    string = "Redirection";
                    break block1;
                }
                string = (400 <= n ? n < 500 : false) ? "Client Error" : ((500 <= n ? n < 600 : false) ? "Server Error" : "Mock Response");
            }
            String reason = string;
            this.status = "HTTP/1.1 " + value + ' ' + reason;
        }

        @NotNull
        public final Headers getHeaders() {
            return this.headers_.build();
        }

        @NotNull
        public final Headers getTrailers() {
            return this.trailers_.build();
        }

        @Nullable
        public final MockResponseBody getBody() {
            return this.bodyVar;
        }

        private final void setBody(MockResponseBody value) {
            this.bodyVar = value;
            this.socketHandlerVar = null;
            this.webSocketListenerVar = null;
        }

        @Nullable
        public final SocketHandler getSocketHandler() {
            return this.socketHandlerVar;
        }

        private final void setSocketHandler(SocketHandler value) {
            this.socketHandlerVar = value;
            this.bodyVar = null;
            this.webSocketListenerVar = null;
        }

        @Nullable
        public final WebSocketListener getWebSocketListener() {
            return this.webSocketListenerVar;
        }

        private final void setWebSocketListener(WebSocketListener value) {
            this.webSocketListenerVar = value;
            this.bodyVar = null;
            this.socketHandlerVar = null;
        }

        public final long getThrottleBytesPerPeriod() {
            return this.throttleBytesPerPeriod;
        }

        public final long getThrottlePeriodNanos() {
            return this.throttlePeriodNanos;
        }

        public final boolean getFailHandshake() {
            return this.failHandshake;
        }

        @Nullable
        public final SocketEffect getOnRequestStart() {
            return this.onRequestStart;
        }

        public final boolean getDoNotReadRequestBody() {
            return this.doNotReadRequestBody;
        }

        @Nullable
        public final SocketEffect getOnRequestBody() {
            return this.onRequestBody;
        }

        @Nullable
        public final SocketEffect getOnResponseStart() {
            return this.onResponseStart;
        }

        @Nullable
        public final SocketEffect getOnResponseBody() {
            return this.onResponseBody;
        }

        @Nullable
        public final SocketEffect getOnResponseEnd() {
            return this.onResponseEnd;
        }

        public final boolean getShutdownServer() {
            return this.shutdownServer;
        }

        public final long getHeadersDelayNanos() {
            return this.headersDelayNanos;
        }

        public final long getBodyDelayNanos() {
            return this.bodyDelayNanos;
        }

        public final long getTrailersDelayNanos() {
            return this.trailersDelayNanos;
        }

        @NotNull
        public final List<PushPromise> getPushPromises() {
            return CollectionsKt.toList((Iterable)this.pushPromises_);
        }

        @NotNull
        public final Settings getSettings() {
            Settings settings;
            Settings $this$_get_settings__u24lambda_u241 = settings = new Settings();
            boolean bl = false;
            $this$_get_settings__u24lambda_u241.merge(this.settings_);
            return settings;
        }

        public Builder() {
            this.inTunnel = false;
            this.informationalResponses_ = new ArrayList();
            this.status = "HTTP/1.1 200 OK";
            this.bodyVar = null;
            this.socketHandlerVar = null;
            this.webSocketListenerVar = null;
            this.headers_ = new Headers.Builder().add("Content-Length", "0");
            this.trailers_ = new Headers.Builder();
            this.throttleBytesPerPeriod = Long.MAX_VALUE;
            this.throttlePeriodNanos = 0L;
            this.failHandshake = false;
            this.onRequestStart = null;
            this.doNotReadRequestBody = false;
            this.onRequestBody = null;
            this.onResponseStart = null;
            this.onResponseBody = null;
            this.onResponseEnd = null;
            this.shutdownServer = false;
            this.headersDelayNanos = 0L;
            this.bodyDelayNanos = 0L;
            this.trailersDelayNanos = 0L;
            this.pushPromises_ = new ArrayList();
            this.settings_ = new Settings();
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull MockResponse mockResponse) {
            void $this$_init__u24lambda_u242;
            Settings settings;
            Intrinsics.checkNotNullParameter((Object)mockResponse, (String)"mockResponse");
            this.inTunnel = mockResponse.getInTunnel();
            this.informationalResponses_ = CollectionsKt.toMutableList((Collection)mockResponse.getInformationalResponses());
            this.status = mockResponse.getStatus();
            this.headers_ = mockResponse.getHeaders().newBuilder();
            this.trailers_ = mockResponse.getTrailers().newBuilder();
            this.bodyVar = mockResponse.getBody();
            this.socketHandlerVar = mockResponse.getSocketHandler();
            this.webSocketListenerVar = mockResponse.getWebSocketListener();
            this.throttleBytesPerPeriod = mockResponse.getThrottleBytesPerPeriod();
            this.throttlePeriodNanos = mockResponse.getThrottlePeriodNanos();
            this.failHandshake = mockResponse.getFailHandshake();
            this.onRequestStart = mockResponse.getOnRequestStart();
            this.doNotReadRequestBody = mockResponse.getDoNotReadRequestBody();
            this.onRequestBody = mockResponse.getOnRequestBody();
            this.onResponseStart = mockResponse.getOnResponseStart();
            this.onResponseBody = mockResponse.getOnResponseBody();
            this.onResponseEnd = mockResponse.getOnResponseEnd();
            this.shutdownServer = mockResponse.getShutdownServer();
            this.headersDelayNanos = mockResponse.getHeadersDelayNanos();
            this.bodyDelayNanos = mockResponse.getBodyDelayNanos();
            this.trailersDelayNanos = mockResponse.getTrailersDelayNanos();
            this.pushPromises_ = CollectionsKt.toMutableList((Collection)mockResponse.getPushPromises());
            Settings settings2 = settings = new Settings();
            Builder builder = this;
            boolean bl = false;
            $this$_init__u24lambda_u242.merge(mockResponse.getSettings());
            builder.settings_ = settings;
        }

        @NotNull
        public final Builder code(int code) {
            Builder builder;
            Builder $this$code_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$code_u24lambda_u243.setCode(code);
            return builder;
        }

        @NotNull
        public final Builder status(@NotNull String status) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Builder $this$status_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$status_u24lambda_u244.status = status;
            return builder;
        }

        @NotNull
        public final Builder clearHeaders() {
            Builder builder;
            Builder $this$clearHeaders_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$clearHeaders_u24lambda_u245.headers_ = new Headers.Builder();
            return builder;
        }

        @NotNull
        public final Builder addHeader(@NotNull String header) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Builder $this$addHeader_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$addHeader_u24lambda_u246.headers_.add(header);
            return builder;
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull Object value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addHeader_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$addHeader_u24lambda_u247.headers_.add(name, value.toString());
            return builder;
        }

        @NotNull
        public final Builder addHeaderLenient(@NotNull String name, @NotNull Object value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addHeaderLenient_u24lambda_u248 = builder = this;
            boolean bl = false;
            Internal.addHeaderLenient((Headers.Builder)$this$addHeaderLenient_u24lambda_u248.headers_, (String)name, (String)value.toString());
            return builder;
        }

        @NotNull
        public final Builder setHeader(@NotNull String name, @NotNull Object value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$setHeader_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$setHeader_u24lambda_u249.removeHeader(name);
            $this$setHeader_u24lambda_u249.addHeader(name, value);
            return builder;
        }

        @NotNull
        public final Builder removeHeader(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeHeader_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$removeHeader_u24lambda_u2410.headers_.removeAll(name);
            return builder;
        }

        @NotNull
        public final Builder body(@NotNull Buffer body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.body(MockResponseBodiesKt.toMockResponseBody(body));
        }

        @NotNull
        public final Builder body(@NotNull MockResponseBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$body_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u2411.setHeader("Content-Length", body.getContentLength());
            $this$body_u24lambda_u2411.setBody(body);
            return builder;
        }

        @NotNull
        public final Builder body(@NotNull String body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.body(new Buffer().writeUtf8(body));
        }

        @NotNull
        public final Builder socketHandler(@NotNull SocketHandler socketHandler) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)socketHandler, (String)"socketHandler");
            Builder $this$socketHandler_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$socketHandler_u24lambda_u2412.setSocketHandler(socketHandler);
            return builder;
        }

        @NotNull
        public final Builder chunkedBody(@NotNull Buffer body, int maxChunkSize) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$chunkedBody_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$chunkedBody_u24lambda_u2413.removeHeader("Content-Length");
            $this$chunkedBody_u24lambda_u2413.headers_.add("Transfer-encoding: chunked");
            Buffer bytesOut = new Buffer();
            while (!body.exhausted()) {
                long chunkSize = Math.min(body.size(), (long)maxChunkSize);
                bytesOut.writeHexadecimalUnsignedLong(chunkSize);
                bytesOut.writeUtf8("\r\n");
                bytesOut.write(body, chunkSize);
                bytesOut.writeUtf8("\r\n");
            }
            bytesOut.writeUtf8("0\r\n");
            $this$chunkedBody_u24lambda_u2413.setBody(MockResponseBodiesKt.toMockResponseBody(bytesOut));
            return builder;
        }

        public static /* synthetic */ Builder chunkedBody$default(Builder builder, Buffer buffer, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = Integer.MAX_VALUE;
            }
            return builder.chunkedBody(buffer, n);
        }

        @NotNull
        public final Builder chunkedBody(@NotNull String body, int maxChunkSize) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.chunkedBody(new Buffer().writeUtf8(body), maxChunkSize);
        }

        public static /* synthetic */ Builder chunkedBody$default(Builder builder, String string, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = Integer.MAX_VALUE;
            }
            return builder.chunkedBody(string, n);
        }

        @NotNull
        public final Builder headers(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$headers_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2414.headers_ = headers.newBuilder();
            return builder;
        }

        @NotNull
        public final Builder trailers(@NotNull Headers trailers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)trailers, (String)"trailers");
            Builder $this$trailers_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$trailers_u24lambda_u2415.trailers_ = trailers.newBuilder();
            return builder;
        }

        @NotNull
        public final Builder failHandshake() {
            Builder builder;
            Builder $this$failHandshake_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$failHandshake_u24lambda_u2416.failHandshake = true;
            return builder;
        }

        @NotNull
        public final Builder onRequestStart(@Nullable SocketEffect socketEffect) {
            Builder builder;
            Builder $this$onRequestStart_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$onRequestStart_u24lambda_u2417.onRequestStart = socketEffect;
            return builder;
        }

        @NotNull
        public final Builder doNotReadRequestBody() {
            Builder builder;
            Builder $this$doNotReadRequestBody_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$doNotReadRequestBody_u24lambda_u2418.doNotReadRequestBody = true;
            $this$doNotReadRequestBody_u24lambda_u2418.onResponseEnd = new SocketEffect.CloseStream(ErrorCode.NO_ERROR.getHttpCode());
            return builder;
        }

        @NotNull
        public final Builder onRequestBody(@Nullable SocketEffect socketEffect) {
            Builder builder;
            Builder $this$onRequestBody_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$onRequestBody_u24lambda_u2419.onRequestBody = socketEffect;
            return builder;
        }

        @NotNull
        public final Builder onResponseStart(@Nullable SocketEffect socketEffect) {
            Builder builder;
            Builder $this$onResponseStart_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$onResponseStart_u24lambda_u2420.onResponseStart = socketEffect;
            return builder;
        }

        @NotNull
        public final Builder onResponseBody(@Nullable SocketEffect socketEffect) {
            Builder builder;
            Builder $this$onResponseBody_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$onResponseBody_u24lambda_u2421.onResponseBody = socketEffect;
            return builder;
        }

        @NotNull
        public final Builder onResponseEnd(@Nullable SocketEffect socketEffect) {
            Builder builder;
            Builder $this$onResponseEnd_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$onResponseEnd_u24lambda_u2422.onResponseEnd = socketEffect;
            return builder;
        }

        @NotNull
        public final Builder shutdownServer(boolean shutdownServer) {
            Builder builder;
            Builder $this$shutdownServer_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$shutdownServer_u24lambda_u2423.shutdownServer = shutdownServer;
            return builder;
        }

        @NotNull
        public final Builder throttleBody(long bytesPerPeriod, long period, @NotNull TimeUnit unit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Builder $this$throttleBody_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$throttleBody_u24lambda_u2424.throttleBytesPerPeriod = bytesPerPeriod;
            $this$throttleBody_u24lambda_u2424.throttlePeriodNanos = unit.toNanos(period);
            return builder;
        }

        @NotNull
        public final Builder headersDelay(long delay, @NotNull TimeUnit unit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Builder $this$headersDelay_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$headersDelay_u24lambda_u2425.headersDelayNanos = unit.toNanos(delay);
            return builder;
        }

        @NotNull
        public final Builder bodyDelay(long delay, @NotNull TimeUnit unit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Builder $this$bodyDelay_u24lambda_u2426 = builder = this;
            boolean bl = false;
            $this$bodyDelay_u24lambda_u2426.bodyDelayNanos = unit.toNanos(delay);
            return builder;
        }

        @NotNull
        public final Builder trailersDelay(long delay, @NotNull TimeUnit unit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Builder $this$trailersDelay_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$trailersDelay_u24lambda_u2427.trailersDelayNanos = unit.toNanos(delay);
            return builder;
        }

        @NotNull
        public final Builder addPush(@NotNull PushPromise promise) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
            Builder $this$addPush_u24lambda_u2428 = builder = this;
            boolean bl = false;
            ((Collection)$this$addPush_u24lambda_u2428.pushPromises_).add(promise);
            return builder;
        }

        @NotNull
        public final Builder settings(@NotNull Settings settings) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Builder $this$settings_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$settings_u24lambda_u2429.settings_.clear();
            $this$settings_u24lambda_u2429.settings_.merge(settings);
            return builder;
        }

        @NotNull
        public final Builder webSocketUpgrade(@NotNull WebSocketListener listener) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder $this$webSocketUpgrade_u24lambda_u2430 = builder = this;
            boolean bl = false;
            $this$webSocketUpgrade_u24lambda_u2430.status = "HTTP/1.1 101 Switching Protocols";
            $this$webSocketUpgrade_u24lambda_u2430.setHeader("Connection", "Upgrade");
            $this$webSocketUpgrade_u24lambda_u2430.setHeader("Upgrade", "websocket");
            $this$webSocketUpgrade_u24lambda_u2430.setWebSocketListener(listener);
            return builder;
        }

        @NotNull
        public final Builder inTunnel() {
            Builder builder;
            Builder $this$inTunnel_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$inTunnel_u24lambda_u2431.removeHeader("Content-Length");
            $this$inTunnel_u24lambda_u2431.inTunnel = true;
            return builder;
        }

        @NotNull
        public final Builder addInformationalResponse(@NotNull MockResponse response) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Builder $this$addInformationalResponse_u24lambda_u2432 = builder = this;
            boolean bl = false;
            ((Collection)$this$addInformationalResponse_u24lambda_u2432.informationalResponses_).add(response);
            return builder;
        }

        @NotNull
        public final Builder add100Continue() {
            Builder builder;
            Builder $this$add100Continue_u24lambda_u2433 = builder = this;
            boolean bl = false;
            $this$add100Continue_u24lambda_u2433.addInformationalResponse(new MockResponse(100, null, null, 6, null));
            return builder;
        }

        @NotNull
        public Builder clone() {
            return this.build().newBuilder();
        }

        @NotNull
        public final MockResponse build() {
            return new MockResponse(this, null);
        }
    }
}

