/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.ciModel.xml;

import com.qcloud.cos.internal.RequestXmlFactory;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.ciModel.common.BatchInputObject;
import com.qcloud.cos.model.ciModel.common.MediaInputObject;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.AudioConfig;
import com.qcloud.cos.model.ciModel.job.BatchJobOperation;
import com.qcloud.cos.model.ciModel.job.BatchJobRequest;
import com.qcloud.cos.model.ciModel.job.CallBackMqConfig;
import com.qcloud.cos.model.ciModel.job.ColorEnhance;
import com.qcloud.cos.model.ciModel.job.ExtractDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.JobParam;
import com.qcloud.cos.model.ciModel.job.MediaAudioMixObject;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaPicProcessTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaTtsConfig;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.job.MsSharpen;
import com.qcloud.cos.model.ciModel.job.SDRtoHDR;
import com.qcloud.cos.model.ciModel.job.SuperResolution;
import com.qcloud.cos.model.ciModel.job.TtsTpl;
import com.qcloud.cos.model.ciModel.job.VideoEnhance;
import com.qcloud.cos.model.ciModel.job.VideoTargetRec;
import com.qcloud.cos.model.ciModel.job.VoiceSeparate;
import com.qcloud.cos.model.ciModel.template.MediaHlsEncryptObject;
import com.qcloud.cos.model.ciModel.template.MediaSegmentObject;
import com.qcloud.cos.model.ciModel.template.MediaSmartCoverObject;
import com.qcloud.cos.model.ciModel.template.MediaSnapshotObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaVideoMontageObject;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import com.qcloud.cos.model.ciModel.template.SpriteSnapshotConfig;
import com.qcloud.cos.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CIMediaXmlFactory {
    static void addIfNotNull(XmlWriter xml, String xmlTag, String value) {
        if (value != null) {
            xml.start(xmlTag).value(value).end();
        }
    }

    static void addIfNotNull(XmlWriter xml, String xmlTag, Object value) {
        if (value != null && value.toString() != null) {
            xml.start(xmlTag).value(value.toString()).end();
        }
    }

    public static byte[] convertToXmlByteArray(MediaJobsRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIMediaXmlFactory.addCommonParams(xml, request);
        CIMediaXmlFactory.addInput(xml, request.getInput());
        CIMediaXmlFactory.addOperation(xml, request);
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(BatchJobRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIMediaXmlFactory.addBatchCommonParams(xml, request);
        CIMediaXmlFactory.addInput(xml, request.getInput());
        CIMediaXmlFactory.addBatchOperation(xml, request.getOperation());
        xml.end();
        return xml.getBytes();
    }

    private static void addBatchCommonParams(XmlWriter xml, BatchJobRequest request) {
        if (CIMediaXmlFactory.objIsNotValid(request).booleanValue()) {
            CIMediaXmlFactory.addIfNotNull(xml, "Name", request.getName());
            CIMediaXmlFactory.addIfNotNull(xml, "Type", request.getType());
        }
    }

    public static byte[] convertToXmlByteArray(MediaTemplateRequest request) {
        XmlWriter xml = new XmlWriter();
        String tag = request.getTag();
        xml.start("Request");
        xml.start("Tag").value(tag).end();
        xml.start("Name").value(request.getName()).end();
        if ("Animation".equalsIgnoreCase(tag)) {
            xml.start("Container");
            xml.start("Format").value(request.getContainer().getFormat()).end();
            xml.end();
            CIMediaXmlFactory.addVideo(xml, request.getVideo());
            if (CIMediaXmlFactory.objIsNotValid(request.getTimeInterval()).booleanValue()) {
                xml.start("TimeInterval");
                xml.start("Duration").value(request.getTimeInterval().getDuration()).end();
                xml.start("Start").value(request.getTimeInterval().getStart()).end();
                xml.end();
            }
        } else if ("Snapshot".equalsIgnoreCase(tag)) {
            MediaSnapshotObject snapshot = request.getSnapshot();
            CIMediaXmlFactory.addSnapshot(xml, snapshot);
        } else if ("Watermark".equalsIgnoreCase(tag)) {
            xml.start("Watermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Type", request.getWatermark().getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Dx", request.getWatermark().getDx());
            CIMediaXmlFactory.addIfNotNull(xml, "Dy", request.getWatermark().getDy());
            CIMediaXmlFactory.addIfNotNull(xml, "EndTime", request.getWatermark().getEndTime());
            CIMediaXmlFactory.addIfNotNull(xml, "LocMode", request.getWatermark().getLocMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Pos", request.getWatermark().getPos());
            CIMediaXmlFactory.addIfNotNull(xml, "StartTime", request.getWatermark().getStartTime());
            if ("Text".equalsIgnoreCase(request.getWatermark().getType())) {
                xml.start("Text");
                MediaWaterMarkText text = request.getWatermark().getText();
                CIMediaXmlFactory.addIfNotNull(xml, "FontColor", text.getFontColor());
                CIMediaXmlFactory.addIfNotNull(xml, "FontSize", text.getFontSize());
                CIMediaXmlFactory.addIfNotNull(xml, "FontType", text.getFontType());
                CIMediaXmlFactory.addIfNotNull(xml, "Text", text.getText());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", text.getTransparency());
                xml.end();
            } else if ("Image".equalsIgnoreCase(request.getWatermark().getType())) {
                xml.start("Image");
                MediaWaterMarkImage image = request.getWatermark().getImage();
                CIMediaXmlFactory.addIfNotNull(xml, "Height", image.getHeight());
                CIMediaXmlFactory.addIfNotNull(xml, "Mode", image.getMode());
                CIMediaXmlFactory.addIfNotNull(xml, "Url", image.getUrl());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", image.getTransparency());
                CIMediaXmlFactory.addIfNotNull(xml, "Width", image.getWidth());
                CIMediaXmlFactory.addIfNotNull(xml, "Background", image.getBackground());
                xml.end();
            }
            xml.end();
        } else if ("Transcode".equalsIgnoreCase(tag)) {
            CIMediaXmlFactory.addFormat(xml, request.getContainer());
            CIMediaXmlFactory.addTimeInterval(xml, request.getTimeInterval());
            CIMediaXmlFactory.addAudio(xml, request.getAudio());
            CIMediaXmlFactory.addVideo(xml, request.getVideo());
            CIMediaXmlFactory.addTransConfig(xml, request.getTransConfig());
        } else if ("Concat".equalsIgnoreCase(tag)) {
            CIMediaXmlFactory.addConcat(xml, request.getConcat());
            CIMediaXmlFactory.addAudio(xml, request.getAudio());
            CIMediaXmlFactory.addAudioMix(xml, request.getAudioMix());
            CIMediaXmlFactory.addContainer(xml, request.getContainer());
        } else if ("VideoTargetRec".equalsIgnoreCase(tag)) {
            VideoTargetRec videoTargetRec = request.getVideoTargetRec();
            CIMediaXmlFactory.addVideoTargetRec(xml, videoTargetRec);
        } else if ("Tts".equalsIgnoreCase(tag)) {
            CIMediaXmlFactory.addIfNotNull(xml, "Codec", request.getCodec());
            CIMediaXmlFactory.addIfNotNull(xml, "Mode", request.getMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Speed", request.getSpeed());
            CIMediaXmlFactory.addIfNotNull(xml, "Volume", request.getVolume());
            CIMediaXmlFactory.addIfNotNull(xml, "VoiceType", request.getVoiceType());
        } else if ("VideoEnhance".equalsIgnoreCase(tag)) {
            CIMediaXmlFactory.addVideoEnhance(xml, request.getVideoEnhance());
        }
        xml.end();
        return xml.getBytes();
    }

    private static void addOperation(XmlWriter xml, MediaJobsRequest request) {
        MediaJobOperation operation = request.getOperation();
        xml.start("Operation");
        CIMediaXmlFactory.addIfNotNull(xml, "TemplateId", operation.getTemplateId());
        CIMediaXmlFactory.addIfNotNull(xml, "JobLevel", operation.getJobLevel());
        CIMediaXmlFactory.addIfNotNull(xml, "DecryptKey", operation.getDecryptKey());
        CIMediaXmlFactory.addIfNotNull(xml, "UserData", operation.getUserData());
        CIMediaXmlFactory.addWatermarkTemplateId(xml, operation.getWatermarkTemplateId());
        CIMediaXmlFactory.addWatermar(xml, operation.getWatermark());
        CIMediaXmlFactory.addWatermarList(xml, operation.getWatermarkList());
        CIMediaXmlFactory.addRemoveWatermark(xml, operation.getRemoveWatermark());
        CIMediaXmlFactory.addConcat(xml, operation.getMediaConcatTemplate());
        CIMediaXmlFactory.addTranscode(xml, operation.getTranscode());
        CIMediaXmlFactory.addExtractDigitalWatermark(xml, operation.getExtractDigitalWatermark());
        CIMediaXmlFactory.addMediaDigitalWatermark(xml, operation.getDigitalWatermark());
        CIMediaXmlFactory.addOutput(xml, operation.getOutput());
        CIMediaXmlFactory.addSnapshot(xml, operation.getSnapshot());
        CIMediaXmlFactory.addSegment(xml, operation.getSegment());
        CIMediaXmlFactory.addSmartCover(xml, operation.getSmartCover());
        CIMediaXmlFactory.addVideoMontage(xml, operation.getVideoMontage());
        CIMediaXmlFactory.addPicProcess(xml, operation.getPicProcess());
        CIMediaXmlFactory.addVideoTargetRec(xml, operation.getVideoTargetRec());
        CIMediaXmlFactory.addVoiceSeparate(xml, operation.getVoiceSeparate());
        CIMediaXmlFactory.addTtsConfig(xml, operation.getTtsConfig());
        CIMediaXmlFactory.addTtsTpl(xml, operation.getTtsTpl());
        CIMediaXmlFactory.addVideoEnhance(xml, operation.getVideoEnhance());
        xml.end();
    }

    private static void addVideoEnhance(XmlWriter xml, VideoEnhance videoEnhance) {
        if (CIMediaXmlFactory.objIsNotValid(videoEnhance).booleanValue()) {
            xml.start("VideoEnhance");
            CIMediaXmlFactory.addTranscode(xml, videoEnhance.getTrascode());
            CIMediaXmlFactory.addSuperResolution(xml, videoEnhance.getSuperResolution());
            CIMediaXmlFactory.addColorEnhance(xml, videoEnhance.getColorEnhance());
            CIMediaXmlFactory.addMsSharpen(xml, videoEnhance.getMsSharpen());
            CIMediaXmlFactory.addSdrToHDR(xml, videoEnhance.getSdrToHDR());
            xml.end();
        }
    }

    private static void addSdrToHDR(XmlWriter xml, SDRtoHDR sdrToHDR) {
        if (CIMediaXmlFactory.objIsNotValid(sdrToHDR).booleanValue()) {
            xml.start("SDRtoHDR");
            CIMediaXmlFactory.addIfNotNull(xml, "HdrMode", sdrToHDR.getHdrMode());
            xml.end();
        }
    }

    private static void addMsSharpen(XmlWriter xml, MsSharpen msSharpen) {
        if (CIMediaXmlFactory.objIsNotValid(msSharpen).booleanValue()) {
            xml.start("MsSharpen");
            CIMediaXmlFactory.addIfNotNull(xml, "SharpenLevel", msSharpen.getSharpenLevel());
            xml.end();
        }
    }

    private static void addColorEnhance(XmlWriter xml, ColorEnhance colorEnhance) {
        if (CIMediaXmlFactory.objIsNotValid(colorEnhance).booleanValue()) {
            xml.start("ColorEnhance");
            CIMediaXmlFactory.addIfNotNull(xml, "Contrast", colorEnhance.getContrast());
            CIMediaXmlFactory.addIfNotNull(xml, "Correction", colorEnhance.getCorrection());
            CIMediaXmlFactory.addIfNotNull(xml, "Saturation", colorEnhance.getSaturation());
            xml.end();
        }
    }

    private static void addSuperResolution(XmlWriter xml, SuperResolution superResolution) {
        if (CIMediaXmlFactory.objIsNotValid(superResolution).booleanValue()) {
            xml.start("SuperResolution");
            CIMediaXmlFactory.addIfNotNull(xml, "Resolution", superResolution.getResolution());
            CIMediaXmlFactory.addIfNotNull(xml, "EnableScaleUp", superResolution.getEnableScaleUp());
            CIMediaXmlFactory.addIfNotNull(xml, "Version", superResolution.getVersion());
            xml.end();
        }
    }

    private static void addTtsTpl(XmlWriter xml, TtsTpl ttsTpl) {
        if (CIMediaXmlFactory.objIsNotValid(ttsTpl).booleanValue()) {
            xml.start("TtsTpl");
            CIMediaXmlFactory.addIfNotNull(xml, "Codec", ttsTpl.getCodec());
            CIMediaXmlFactory.addIfNotNull(xml, "Mode", ttsTpl.getMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Speed", ttsTpl.getSpeed());
            CIMediaXmlFactory.addIfNotNull(xml, "Volume", ttsTpl.getVolume());
            CIMediaXmlFactory.addIfNotNull(xml, "VoiceType", ttsTpl.getVoiceType());
            xml.end();
        }
    }

    private static void addTtsConfig(XmlWriter xml, MediaTtsConfig ttsConfig) {
        if (CIMediaXmlFactory.objIsNotValid(ttsConfig).booleanValue()) {
            xml.start("TtsConfig");
            CIMediaXmlFactory.addIfNotNull(xml, "Input", ttsConfig.getInput());
            CIMediaXmlFactory.addIfNotNull(xml, "InputType", ttsConfig.getInputType());
            xml.end();
        }
    }

    private static void addBatchOperation(XmlWriter xml, BatchJobOperation operation) {
        xml.start("Operation");
        CIMediaXmlFactory.addTimeInterval(xml, operation.getTimeInterval());
        CIMediaXmlFactory.addIfNotNull(xml, "QueueId", operation.getQueueId());
        CIMediaXmlFactory.addIfNotNull(xml, "UserData", operation.getUserData());
        CIMediaXmlFactory.addIfNotNull(xml, "CallBack", operation.getCallBack());
        CIMediaXmlFactory.addIfNotNull(xml, "Tag", operation.getTag());
        CIMediaXmlFactory.addIfNotNull(xml, "JobLevel", operation.getJobLevel());
        CIMediaXmlFactory.addIfNotNull(xml, "WorkflowIds", operation.getWorkflowIds());
        CIMediaXmlFactory.addJobParam(xml, operation.getJobParam());
        CIMediaXmlFactory.addOutput(xml, operation.getOutput());
        CIMediaXmlFactory.addCallBackMqConfig(xml, operation.getCallBackMqConfig());
        xml.end();
    }

    private static void addJobParam(XmlWriter xml, JobParam jobParam) {
        if (CIMediaXmlFactory.objIsNotValid(jobParam).booleanValue()) {
            xml.start("JobParam");
            CIMediaXmlFactory.addIfNotNull(xml, "TemplateId", jobParam.getTemplateId());
            CIMediaXmlFactory.addPicProcess(xml, jobParam.getPicProcess());
            xml.end();
        }
    }

    private static void addCallBackMqConfig(XmlWriter xml, CallBackMqConfig callBackMqConfig) {
        if (CIMediaXmlFactory.objIsNotValid(callBackMqConfig).booleanValue()) {
            xml.start("CallBackMqConfig");
            CIMediaXmlFactory.addIfNotNull(xml, "MqMode", callBackMqConfig.getMqMode());
            CIMediaXmlFactory.addIfNotNull(xml, "MqName", callBackMqConfig.getMqName());
            CIMediaXmlFactory.addIfNotNull(xml, "MqRegion", callBackMqConfig.getMqRegion());
            xml.end();
        }
    }

    private static void addPicProcess(XmlWriter xml, MediaPicProcessTemplateObject picProcess) {
        if (CIMediaXmlFactory.objIsNotValid(picProcess).booleanValue()) {
            xml.start("PicProcess");
            CIMediaXmlFactory.addIfNotNull(xml, "IsPicInfo", picProcess.getIsPicInfo());
            CIMediaXmlFactory.addIfNotNull(xml, "ProcessRule", picProcess.getProcessRule());
            xml.end();
        }
    }

    private static void addVoiceSeparate(XmlWriter xml, VoiceSeparate voiceSeparate) {
        if (CIMediaXmlFactory.objIsNotValid(voiceSeparate).booleanValue()) {
            xml.start("VoiceSeparate");
            CIMediaXmlFactory.addIfNotNull(xml, "AudioMode", voiceSeparate.getAudioMode());
            AudioConfig audioConfig = voiceSeparate.getAudioConfig();
            if (CIMediaXmlFactory.objIsNotValid(audioConfig).booleanValue()) {
                xml.start("AudioConfig");
                CIMediaXmlFactory.addIfNotNull(xml, "Bitrate", audioConfig.getBitrate());
                CIMediaXmlFactory.addIfNotNull(xml, "Channels", audioConfig.getChannels());
                CIMediaXmlFactory.addIfNotNull(xml, "Codec", audioConfig.getCodec());
                CIMediaXmlFactory.addIfNotNull(xml, "Samplerate", audioConfig.getSamplerate());
                xml.end();
            }
            xml.end();
        }
    }

    private static void addVideoTargetRec(XmlWriter xml, VideoTargetRec videoTargetRec) {
        if (CIMediaXmlFactory.objIsNotValid(videoTargetRec).booleanValue()) {
            xml.start("VideoTargetRec");
            CIMediaXmlFactory.addIfNotNull(xml, "Body", videoTargetRec.getBody());
            CIMediaXmlFactory.addIfNotNull(xml, "Car", videoTargetRec.getCar());
            CIMediaXmlFactory.addIfNotNull(xml, "Pet", videoTargetRec.getPet());
            xml.end();
        }
    }

    private static void addWatermarList(XmlWriter xml, List<MediaWatermark> watermarkList) {
        if (watermarkList != null && !watermarkList.isEmpty()) {
            for (MediaWatermark mediaWatermark : watermarkList) {
                CIMediaXmlFactory.addWatermar(xml, mediaWatermark);
            }
        }
    }

    private static void addWatermarkTemplateId(XmlWriter xml, List<String> watermarkTemplateId) {
        if (watermarkTemplateId != null && !watermarkTemplateId.isEmpty()) {
            for (String templateId : watermarkTemplateId) {
                xml.start("WatermarkTemplateId").value(templateId).end();
            }
        }
    }

    private static void addVideoMontage(XmlWriter xml, MediaVideoMontageObject videoMontage) {
        if (CIMediaXmlFactory.objIsNotValid(videoMontage).booleanValue()) {
            xml.start("VideoMontage");
            CIMediaXmlFactory.addIfNotNull(xml, "Duration", videoMontage.getDuration());
            CIMediaXmlFactory.addVideo(xml, videoMontage.getVideo());
            CIMediaXmlFactory.addAudio(xml, videoMontage.getAudio());
            CIMediaXmlFactory.addAudioMix(xml, videoMontage.getAudioMix());
            CIMediaXmlFactory.addContainer(xml, videoMontage.getContainer());
            xml.end();
        }
    }

    private static void addAudioMix(XmlWriter xml, MediaAudioMixObject audioMix) {
        if (CIMediaXmlFactory.objIsNotValid(audioMix).booleanValue()) {
            xml.start("AudioMix");
            CIMediaXmlFactory.addIfNotNull(xml, "MixMode", audioMix.getMixMode());
            CIMediaXmlFactory.addIfNotNull(xml, "AudioSource", audioMix.getAudioSource());
            CIMediaXmlFactory.addIfNotNull(xml, "Replace", audioMix.getReplace());
            CIMediaXmlFactory.addIfNotNull(xml, "EffectConfig", audioMix.getEffectConfig());
            xml.end();
        }
    }

    private static void addConcat(XmlWriter xml, MediaConcatTemplateObject mediaConcatTemplate) {
        if (CIMediaXmlFactory.objIsNotValid(mediaConcatTemplate).booleanValue()) {
            xml.start("ConcatTemplate");
            List<MediaConcatFragmentObject> concatFragmentList = mediaConcatTemplate.getConcatFragmentList();
            for (MediaConcatFragmentObject concatFragment : concatFragmentList) {
                xml.start("ConcatFragment");
                CIMediaXmlFactory.addIfNotNull(xml, "Mode", concatFragment.getMode());
                CIMediaXmlFactory.addIfNotNull(xml, "Url", concatFragment.getUrl());
                CIMediaXmlFactory.addIfNotNull(xml, "FragmentIndex", concatFragment.getFragmentIndex());
                CIMediaXmlFactory.addIfNotNull(xml, "StartTime", concatFragment.getStartTime());
                CIMediaXmlFactory.addIfNotNull(xml, "EndTime", concatFragment.getEndTime());
                xml.end();
            }
            CIMediaXmlFactory.addVideo(xml, mediaConcatTemplate.getVideo());
            CIMediaXmlFactory.addAudio(xml, mediaConcatTemplate.getAudio());
            CIMediaXmlFactory.addIfNotNull(xml, "Index", mediaConcatTemplate.getIndex());
            CIMediaXmlFactory.addIfNotNull(xml, "DirectConcat", mediaConcatTemplate.getDirectConcat());
            CIMediaXmlFactory.addContainer(xml, mediaConcatTemplate.getContainer());
            CIMediaXmlFactory.addAudioMix(xml, mediaConcatTemplate.getAudioMix());
            xml.end();
        }
    }

    private static void addContainer(XmlWriter xml, MediaContainerObject container) {
        if (!StringUtils.isNullOrEmpty(container.getFormat())) {
            xml.start("Container");
            xml.start("Format").value(container.getFormat()).end();
            xml.end();
        }
    }

    private static void addMediaDigitalWatermark(XmlWriter xml, MediaDigitalWatermark digitalWatermark) {
        if (CIMediaXmlFactory.objIsNotValid(digitalWatermark).booleanValue()) {
            xml.start("DigitalWatermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Message", digitalWatermark.getMessage());
            CIMediaXmlFactory.addIfNotNull(xml, "Type", digitalWatermark.getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Version", digitalWatermark.getVersion());
            xml.end();
        }
    }

    private static void addExtractDigitalWatermark(XmlWriter xml, ExtractDigitalWatermark extractDigitalWatermark) {
        if (extractDigitalWatermark.getType() != null || extractDigitalWatermark.getMessage() != null) {
            xml.start("ExtractDigitalWatermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Message", extractDigitalWatermark.getMessage());
            CIMediaXmlFactory.addIfNotNull(xml, "Type", extractDigitalWatermark.getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Version", extractDigitalWatermark.getVersion());
            xml.end();
        }
    }

    protected static void addOutput(XmlWriter xml, MediaOutputObject output) {
        if (CIMediaXmlFactory.objIsNotValid(output).booleanValue()) {
            xml.start("Output");
            CIMediaXmlFactory.addIfNotNull(xml, "Region", output.getRegion());
            CIMediaXmlFactory.addIfNotNull(xml, "Object", output.getObject());
            CIMediaXmlFactory.addIfNotNull(xml, "Bucket", output.getBucket());
            CIMediaXmlFactory.addIfNotNull(xml, "SpriteObject", output.getSpriteObject());
            CIMediaXmlFactory.addIfNotNull(xml, "AuObject", output.getAuObject());
            xml.end();
        }
    }

    private static void addSegment(XmlWriter xml, MediaSegmentObject segment) {
        if (CIMediaXmlFactory.objIsNotValid(segment).booleanValue()) {
            xml.start("Segment");
            CIMediaXmlFactory.addIfNotNull(xml, "Duration", segment.getDuration());
            CIMediaXmlFactory.addIfNotNull(xml, "Format", segment.getFormat());
            MediaHlsEncryptObject hlsEncrypt = segment.getHlsEncrypt();
            if (CIMediaXmlFactory.objIsNotValid(hlsEncrypt).booleanValue()) {
                xml.start("HlsEncrypt");
                CIMediaXmlFactory.addIfNotNull(xml, "IsHlsEncrypt", hlsEncrypt.getIsHlsEncrypt());
                CIMediaXmlFactory.addIfNotNull(xml, "UriKey", hlsEncrypt.getUriKey());
                xml.end();
            }
            xml.end();
        }
    }

    private static void addSmartCover(XmlWriter xml, MediaSmartCoverObject smartCover) {
        if (CIMediaXmlFactory.objIsNotValid(smartCover).booleanValue()) {
            xml.start("SmartCover");
            CIMediaXmlFactory.addIfNotNull(xml, "Format", smartCover.getFormat());
            CIMediaXmlFactory.addIfNotNull(xml, "Width", smartCover.getWidth());
            CIMediaXmlFactory.addIfNotNull(xml, "Height", smartCover.getHeight());
            CIMediaXmlFactory.addIfNotNull(xml, "Count", smartCover.getCount());
            CIMediaXmlFactory.addIfNotNull(xml, "DeleteDuplicates", smartCover.getDeleteDuplicates());
            xml.end();
        }
    }

    private static void addCommonParams(XmlWriter xml, MediaJobsRequest request) {
        if (CIMediaXmlFactory.objIsNotValid(request).booleanValue()) {
            xml.start("Tag").value(request.getTag()).end();
            xml.start("BucketName").value(request.getBucketName()).end();
            xml.start("QueueId").value(request.getQueueId()).end();
            CIMediaXmlFactory.addIfNotNull(xml, "CallBack", request.getCallBack());
            CIMediaXmlFactory.addIfNotNull(xml, "CallBackFormat", request.getCallBackFormat());
            CIMediaXmlFactory.addIfNotNull(xml, "CallBackType", request.getCallBackType());
        }
    }

    private static void addTranscode(XmlWriter xml, MediaTranscodeObject transcode) {
        if (CIMediaXmlFactory.objIsNotValid(transcode).booleanValue()) {
            xml.start("Transcode");
            MediaTranscodeVideoObject video = transcode.getVideo();
            MediaAudioObject audio = transcode.getAudio();
            MediaTransConfigObject transConfig = transcode.getTransConfig();
            MediaTimeIntervalObject timeInterval = transcode.getTimeInterval();
            CIMediaXmlFactory.addFormat(xml, transcode.getContainer());
            CIMediaXmlFactory.addTimeInterval(xml, timeInterval);
            CIMediaXmlFactory.addVideo(xml, video);
            CIMediaXmlFactory.addAudio(xml, audio);
            CIMediaXmlFactory.addTransConfig(xml, transConfig);
            CIMediaXmlFactory.addAudioMix(xml, transcode.getAudioMix());
            xml.end();
        }
    }

    private static void addFormat(XmlWriter xml, MediaContainerObject container) {
        String format = container.getFormat();
        if (format != null) {
            xml.start("Container");
            xml.start("Format").value(format).end();
            if (container.getClipConfig().getDuration() != null) {
                xml.start("ClipConfig");
                xml.start("Duration").value(container.getClipConfig().getDuration()).end();
                xml.end();
            }
            xml.end();
        }
    }

    private static void addSnapshot(XmlWriter xml, MediaSnapshotObject snapshot) {
        if (CIMediaXmlFactory.objIsNotValid(snapshot).booleanValue()) {
            xml.start("Snapshot");
            CIMediaXmlFactory.addIfNotNull(xml, "Mode", snapshot.getMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Count", snapshot.getCount());
            CIMediaXmlFactory.addIfNotNull(xml, "Fps", snapshot.getFps());
            CIMediaXmlFactory.addIfNotNull(xml, "Height", snapshot.getHeight());
            CIMediaXmlFactory.addIfNotNull(xml, "Start", snapshot.getStart());
            CIMediaXmlFactory.addIfNotNull(xml, "TimeInterval", snapshot.getTimeInterval());
            CIMediaXmlFactory.addIfNotNull(xml, "Width", snapshot.getWidth());
            CIMediaXmlFactory.addIfNotNull(xml, "CIParam", snapshot.getCiParam());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckCount", snapshot.getIsCheckCount());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckBlack", snapshot.getIsCheckBlack());
            CIMediaXmlFactory.addIfNotNull(xml, "BlackLevel", snapshot.getBlackLevel());
            CIMediaXmlFactory.addIfNotNull(xml, "PixelBlackThreshold", snapshot.getPixelBlackThreshold());
            CIMediaXmlFactory.addIfNotNull(xml, "SnapshotOutMode", snapshot.getSnapshotOutMode());
            if (CIMediaXmlFactory.objIsNotValid(snapshot.getSnapshotConfig()).booleanValue()) {
                SpriteSnapshotConfig snapshotConfig = snapshot.getSnapshotConfig();
                xml.start("SpriteSnapshotConfig");
                CIMediaXmlFactory.addIfNotNull(xml, "CellWidth", snapshotConfig.getCellWidth());
                CIMediaXmlFactory.addIfNotNull(xml, "CellHeight", snapshotConfig.getCellHeight());
                CIMediaXmlFactory.addIfNotNull(xml, "Padding", snapshotConfig.getPadding());
                CIMediaXmlFactory.addIfNotNull(xml, "Margin", snapshotConfig.getMargin());
                CIMediaXmlFactory.addIfNotNull(xml, "Color", snapshotConfig.getColor());
                CIMediaXmlFactory.addIfNotNull(xml, "Columns", snapshotConfig.getColumns());
                CIMediaXmlFactory.addIfNotNull(xml, "Lines", snapshotConfig.getLines());
                xml.end();
            }
            xml.end();
        }
    }

    private static void addVideo(XmlWriter xml, MediaVideoObject video) {
        if (RequestXmlFactory.CheckObjectUtils.objIsValid(video).booleanValue()) {
            return;
        }
        xml.start("Video");
        CIMediaXmlFactory.addIfNotNull(xml, "Codec", video.getCodec());
        CIMediaXmlFactory.addIfNotNull(xml, "Width", video.getWidth());
        CIMediaXmlFactory.addIfNotNull(xml, "Height", video.getHeight());
        CIMediaXmlFactory.addIfNotNull(xml, "Fps", video.getFps());
        CIMediaXmlFactory.addIfNotNull(xml, "Bitrate", video.getBitrate());
        CIMediaXmlFactory.addIfNotNull(xml, "BufSize", video.getBufSize());
        CIMediaXmlFactory.addIfNotNull(xml, "Crf", video.getCrf());
        CIMediaXmlFactory.addIfNotNull(xml, "Crop", video.getCrop());
        CIMediaXmlFactory.addIfNotNull(xml, "Gop", video.getGop());
        CIMediaXmlFactory.addIfNotNull(xml, "LongShortMode", video.getLongShortMode());
        CIMediaXmlFactory.addIfNotNull(xml, "Maxrate", video.getMaxrate());
        CIMediaXmlFactory.addIfNotNull(xml, "Pad", video.getPad());
        CIMediaXmlFactory.addIfNotNull(xml, "PixFmt", video.getPixFmt());
        CIMediaXmlFactory.addIfNotNull(xml, "Preset", video.getPreset());
        CIMediaXmlFactory.addIfNotNull(xml, "Profile", video.getProfile());
        CIMediaXmlFactory.addIfNotNull(xml, "Qality", video.getQality());
        CIMediaXmlFactory.addIfNotNull(xml, "Quality", video.getQuality());
        CIMediaXmlFactory.addIfNotNull(xml, "Remove", video.getRemove());
        CIMediaXmlFactory.addIfNotNull(xml, "ScanMode", video.getScanMode());
        CIMediaXmlFactory.addIfNotNull(xml, "HlsTsTime", video.getHlsTsTime());
        CIMediaXmlFactory.addIfNotNull(xml, "AnimateFramesPerSecond", video.getAnimateFramesPerSecond());
        CIMediaXmlFactory.addIfNotNull(xml, "AnimateTimeIntervalOfFrame", video.getAnimateTimeIntervalOfFrame());
        CIMediaXmlFactory.addIfNotNull(xml, "AnimateOnlyKeepKeyFrame", video.getAnimateOnlyKeepKeyFrame());
        xml.end();
    }

    private static void addVideo(XmlWriter xml, MediaTranscodeVideoObject video) {
        if (RequestXmlFactory.CheckObjectUtils.objIsValid(video).booleanValue()) {
            return;
        }
        xml.start("Video");
        CIMediaXmlFactory.addIfNotNull(xml, "Codec", video.getCodec());
        CIMediaXmlFactory.addIfNotNull(xml, "Width", video.getWidth());
        CIMediaXmlFactory.addIfNotNull(xml, "Height", video.getHeight());
        CIMediaXmlFactory.addIfNotNull(xml, "Fps", video.getFps());
        CIMediaXmlFactory.addIfNotNull(xml, "Bitrate", video.getBitrate());
        CIMediaXmlFactory.addIfNotNull(xml, "BufSize", video.getBufSize());
        CIMediaXmlFactory.addIfNotNull(xml, "Crf", video.getCrf());
        CIMediaXmlFactory.addIfNotNull(xml, "Gop", video.getGop());
        CIMediaXmlFactory.addIfNotNull(xml, "Maxrate", video.getMaxrate());
        CIMediaXmlFactory.addIfNotNull(xml, "Preset", video.getPreset());
        CIMediaXmlFactory.addIfNotNull(xml, "Profile", video.getProfile());
        CIMediaXmlFactory.addIfNotNull(xml, "Remove", video.getRemove());
        CIMediaXmlFactory.addIfNotNull(xml, "ScanMode", video.getScanMode());
        xml.end();
    }

    private static void addAudio(XmlWriter xml, MediaAudioObject audio) {
        if (CIMediaXmlFactory.objIsNotValid(audio).booleanValue()) {
            xml.start("Audio");
            CIMediaXmlFactory.addIfNotNull(xml, "Bitrate", audio.getBitrate());
            CIMediaXmlFactory.addIfNotNull(xml, "Channels", audio.getChannels());
            CIMediaXmlFactory.addIfNotNull(xml, "Codec", audio.getCodec());
            CIMediaXmlFactory.addIfNotNull(xml, "Profile", audio.getProfile());
            CIMediaXmlFactory.addIfNotNull(xml, "Remove", audio.getRemove());
            CIMediaXmlFactory.addIfNotNull(xml, "Samplerate", audio.getSamplerate());
            xml.end();
        }
    }

    private static void addTimeInterval(XmlWriter xml, MediaTimeIntervalObject timeInterval) {
        if (CIMediaXmlFactory.objIsNotValid(timeInterval).booleanValue()) {
            xml.start("TimeInterval");
            CIMediaXmlFactory.addIfNotNull(xml, "Duration", timeInterval.getDuration());
            CIMediaXmlFactory.addIfNotNull(xml, "Start", timeInterval.getStart());
            CIMediaXmlFactory.addIfNotNull(xml, "End", timeInterval.getEnd());
            xml.end();
        }
    }

    private static void addTransConfig(XmlWriter xml, MediaTransConfigObject transConfig) {
        if (CIMediaXmlFactory.objIsNotValid(transConfig).booleanValue()) {
            xml.start("TransConfig");
            CIMediaXmlFactory.addIfNotNull(xml, "AdjDarMethod", transConfig.getAdjDarMethod());
            CIMediaXmlFactory.addIfNotNull(xml, "AudioBitrateAdjMethod", transConfig.getAudioBitrateAdjMethod());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckAudioBitrate", transConfig.getIsCheckAudioBitrate());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckReso", transConfig.getIsCheckReso());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckVideoBitrate", transConfig.getIsCheckVideoBitrate());
            CIMediaXmlFactory.addIfNotNull(xml, "ResoAdjMethod", transConfig.getResoAdjMethod());
            CIMediaXmlFactory.addIfNotNull(xml, "TransMode", transConfig.getTransMode());
            CIMediaXmlFactory.addIfNotNull(xml, "DeleteMetadata", transConfig.getDeleteMetadata());
            CIMediaXmlFactory.addIfNotNull(xml, "IsHdr2Sdr", transConfig.getIsHdr2Sdr());
            CIMediaXmlFactory.addIfNotNull(xml, "HlsEncrypt", transConfig.getHlsEncrypt());
            xml.end();
        }
    }

    private static void addInput(XmlWriter xml, MediaInputObject inputObject) {
        if (CIMediaXmlFactory.objIsNotValid(inputObject).booleanValue()) {
            xml.start("Input");
            CIMediaXmlFactory.addIfNotNull(xml, "Object", inputObject.getObject());
            CIMediaXmlFactory.addIfNotNull(xml, "Url", inputObject.getUrl());
            xml.end();
        }
    }

    private static void addInput(XmlWriter xml, BatchInputObject inputObject) {
        xml.start("Input");
        CIMediaXmlFactory.addIfNotNull(xml, "Object", inputObject.getObject());
        CIMediaXmlFactory.addIfNotNull(xml, "Url", inputObject.getUrl());
        CIMediaXmlFactory.addIfNotNull(xml, "Manifest", inputObject.getManifest());
        CIMediaXmlFactory.addIfNotNull(xml, "Prefix", inputObject.getPrefix());
        CIMediaXmlFactory.addIfNotNull(xml, "UrlFile", inputObject.getUrlFile());
        xml.end();
    }

    private static void addWatermar(XmlWriter xml, MediaWatermark watermark) {
        if (CIMediaXmlFactory.objIsNotValid(watermark).booleanValue()) {
            xml.start("Watermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Type", watermark.getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Dx", watermark.getDx());
            CIMediaXmlFactory.addIfNotNull(xml, "Dy", watermark.getDy());
            CIMediaXmlFactory.addIfNotNull(xml, "EndTime", watermark.getEndTime());
            CIMediaXmlFactory.addIfNotNull(xml, "LocMode", watermark.getLocMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Pos", watermark.getPos());
            CIMediaXmlFactory.addIfNotNull(xml, "StartTime", watermark.getStartTime());
            if ("Text".equalsIgnoreCase(watermark.getType())) {
                MediaWaterMarkText text = watermark.getText();
                xml.start("Text");
                CIMediaXmlFactory.addIfNotNull(xml, "FontColor", text.getFontColor());
                CIMediaXmlFactory.addIfNotNull(xml, "FontSize", text.getFontSize());
                CIMediaXmlFactory.addIfNotNull(xml, "FontType", text.getFontType());
                CIMediaXmlFactory.addIfNotNull(xml, "Text", text.getText());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", text.getTransparency());
                xml.end();
            } else if ("Image".equalsIgnoreCase(watermark.getType())) {
                MediaWaterMarkImage image = watermark.getImage();
                xml.start("Image");
                CIMediaXmlFactory.addIfNotNull(xml, "Height", image.getHeight());
                CIMediaXmlFactory.addIfNotNull(xml, "Mode", image.getMode());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", image.getTransparency());
                CIMediaXmlFactory.addIfNotNull(xml, "Url", image.getUrl());
                CIMediaXmlFactory.addIfNotNull(xml, "Width", image.getWidth());
                xml.end();
            }
            xml.end();
        }
    }

    private static void addRemoveWatermark(XmlWriter xml, MediaRemoveWaterMark removeWatermark) {
        if (CIMediaXmlFactory.objIsNotValid(removeWatermark).booleanValue()) {
            xml.start("RemoveWatermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Height", removeWatermark.getHeight());
            CIMediaXmlFactory.addIfNotNull(xml, "Dx", removeWatermark.getDx());
            CIMediaXmlFactory.addIfNotNull(xml, "Dy", removeWatermark.getDy());
            CIMediaXmlFactory.addIfNotNull(xml, "Switch", removeWatermark.get_switch());
            CIMediaXmlFactory.addIfNotNull(xml, "Width", removeWatermark.getWidth());
            xml.end();
        }
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).isEmpty()) {
            return true;
        }
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        if (object instanceof Map && ((Map)object).isEmpty()) {
            return true;
        }
        return object instanceof Object[] && ((Object[])object).length == 0;
    }

    public static Boolean objIsNotValid(Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object o = field.get(obj);
                if (field.isSynthetic() || CIMediaXmlFactory.isEmpty(o)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

