/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.request;

import com.qcloud.cos.common_utils.CommonParamCheckUtils;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.meta.ListOrder;
import com.qcloud.cos.meta.ListPattern;
import com.qcloud.cos.request.AbstractBaseRequest;

public class ListFolderRequest
extends AbstractBaseRequest {
    private final int DEFAULT_LIST_NUM = 199;
    private int num = 199;
    private String prefix = "";
    private String context = "";
    private ListPattern pattern = ListPattern.BOTH;
    private ListOrder order = ListOrder.POSITIVE;

    public ListFolderRequest(String bucketName, String cosPath) {
        super(bucketName, cosPath);
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public ListPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ListPattern pattern) {
        this.pattern = pattern;
    }

    public ListOrder getOrder() {
        return this.order;
    }

    public void setOrder(ListOrder order) {
        this.order = order;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        CommonParamCheckUtils.AssertLegalCosFolderPath(this.getCosPath());
        CommonParamCheckUtils.AssertNotNull("order", (Object)this.order);
        CommonParamCheckUtils.AssertNotNull("context", this.context);
        CommonParamCheckUtils.AssertNotNull("prefix", this.prefix);
        CommonParamCheckUtils.AssertNotNull("pattern", (Object)this.pattern);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", num:").append(this.num);
        sb.append(", order:");
        if (this.order == null) {
            sb.append("null");
        } else {
            sb.append(this.order.ordinal());
        }
        sb.append(", prefix:").append(this.getMemberStringValue(this.prefix));
        sb.append(", context:").append(this.getMemberStringValue(this.context));
        sb.append(", pattern:");
        if (this.pattern == null) {
            sb.append("null");
        } else {
            sb.append(this.pattern.toString());
        }
        return sb.toString();
    }
}

