/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.edec;

import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.CryptoException;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.Signer;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.signers.Ed25519Signer;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.signers.Ed448Signer;
import com.qcloud.cos.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import com.qcloud.cos.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public class SignatureSpi
extends java.security.SignatureSpi {
    private static final byte[] EMPTY_CONTEXT = new byte[0];
    private final String algorithm;
    private Signer signer;

    SignatureSpi(String string) {
        this.algorithm = string;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCEdDSAPublicKey)) {
            throw new InvalidKeyException("cannot identify EdDSA public key");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = ((BCEdDSAPublicKey)publicKey).engineGetKeyParameters();
        this.signer = asymmetricKeyParameter instanceof Ed448PublicKeyParameters ? this.getSigner("Ed448") : this.getSigner("Ed25519");
        this.signer.init(false, asymmetricKeyParameter);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof BCEdDSAPrivateKey)) {
            throw new InvalidKeyException("cannot identify EdDSA private key");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = ((BCEdDSAPrivateKey)privateKey).engineGetKeyParameters();
        this.signer = asymmetricKeyParameter instanceof Ed448PrivateKeyParameters ? this.getSigner("Ed448") : this.getSigner("Ed25519");
        this.signer.init(true, asymmetricKeyParameter);
    }

    private Signer getSigner(String string) throws InvalidKeyException {
        if (this.algorithm != null && !string.equals(this.algorithm)) {
            throw new InvalidKeyException("inappropriate key for " + this.algorithm);
        }
        if (string.equals("Ed448")) {
            return new Ed448Signer(EMPTY_CONTEXT);
        }
        return new Ed25519Signer();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.signer.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.signer.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(cryptoException.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.signer.verifySignature(byArray);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static final class Ed25519
    extends SignatureSpi {
        public Ed25519() {
            super("Ed25519");
        }
    }

    public static final class Ed448
    extends SignatureSpi {
        public Ed448() {
            super("Ed448");
        }
    }

    public static final class EdDSA
    extends SignatureSpi {
        public EdDSA() {
            super(null);
        }
    }
}

