/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.core.utils.OverrideParameterRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ServiceNameFilter
implements Filter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        try {
            String groupName;
            String serviceName = request.getParameter("serviceName");
            if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                serviceName = serviceName.trim();
            }
            if (StringUtils.isBlank((CharSequence)(groupName = request.getParameter("groupName")))) {
                groupName = "DEFAULT_GROUP";
            }
            String groupedServiceName = serviceName;
            if (StringUtils.isNotBlank((CharSequence)serviceName) && !serviceName.contains("@@")) {
                groupedServiceName = groupName + "@@" + serviceName;
            }
            OverrideParameterRequestWrapper requestWrapper = OverrideParameterRequestWrapper.buildRequest((HttpServletRequest)request);
            requestWrapper.addParameter("serviceName", groupedServiceName);
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
        }
        catch (Exception e) {
            resp.sendError(500, "Service name filter error," + ExceptionUtil.getAllExceptionMsg((Throwable)e));
        }
    }
}

