/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.parser.ResourceParser;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.ReflectUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class NamingResourceParser
implements ResourceParser {
    private static final String AUTH_NAMING_PREFIX = "naming/";

    public String parseName(Object requestObj) {
        String namespaceId = null;
        String serviceName = null;
        String groupName = null;
        if (requestObj instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)requestObj;
            namespaceId = NamespaceUtil.processNamespaceParameter((String)req.getParameter("namespaceId"));
            serviceName = req.getParameter("serviceName");
            groupName = req.getParameter("groupName");
        } else if (requestObj instanceof Request) {
            Request request = (Request)requestObj;
            namespaceId = (String)ReflectUtils.getFieldValue((Object)request, (String)"namespace", (Object)"");
            groupName = (String)ReflectUtils.getFieldValue((Object)request, (String)"groupName", (Object)"");
            serviceName = (String)ReflectUtils.getFieldValue((Object)request, (String)"serviceName", (Object)"");
        }
        if (StringUtils.isBlank(groupName)) {
            groupName = NamingUtils.getGroupName(serviceName);
        }
        serviceName = NamingUtils.getServiceName(serviceName);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)namespaceId)) {
            sb.append(namespaceId);
        }
        sb.append(":");
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            sb.append("*").append(":").append(AUTH_NAMING_PREFIX).append("*");
        } else {
            sb.append(groupName).append(":").append(AUTH_NAMING_PREFIX).append(serviceName);
        }
        return sb.toString();
    }
}

