/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.utils;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ServiceUtil {
    public static Map<String, Service> selectServiceWithGroupName(Map<String, Service> services, String groupName) {
        if (null == services || services.isEmpty()) {
            return new HashMap<String, Service>(0);
        }
        HashMap<String, Service> result = new HashMap<String, Service>(services.size());
        String groupKey = groupName + "@@";
        for (Map.Entry<String, Service> each : services.entrySet()) {
            if (!each.getKey().startsWith(groupKey)) continue;
            result.put(each.getKey(), each.getValue());
        }
        return result;
    }

    public static Map<String, Service> selectServiceBySelector(Map<String, Service> serviceMap, String selectorString) {
        Map<String, Service> result = serviceMap;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selectorString)) {
            JsonNode selectorJson = JacksonUtils.toObj((String)selectorString);
            SelectorType selectorType = SelectorType.valueOf((String)selectorJson.get("type").asText());
            String expression = selectorJson.get("expression").asText();
            if (SelectorType.label.equals((Object)selectorType) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)expression)) {
                expression = org.apache.commons.lang3.StringUtils.deleteWhitespace((String)expression);
                String[] terms = expression.split("=");
                String[] factors = terms[0].split("\\.");
                switch (factors[0]) {
                    case "INSTANCE": {
                        result = ServiceUtil.filterInstanceMetadata(serviceMap, factors[factors.length - 1], terms[1].replace("'", ""));
                        break;
                    }
                    case "SERVICE": {
                        result = ServiceUtil.filterServiceMetadata(serviceMap, factors[factors.length - 1], terms[1].replace("'", ""));
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static Map<String, Service> filterInstanceMetadata(Map<String, Service> serviceMap, String key, String value) {
        HashMap<String, Service> result = new HashMap<String, Service>(serviceMap.size());
        block0: for (Map.Entry<String, Service> each : serviceMap.entrySet()) {
            for (Instance address : each.getValue().allIPs()) {
                if (address.getMetadata() == null || !value.equals(address.getMetadata().get(key))) continue;
                result.put(each.getKey(), each.getValue());
                continue block0;
            }
        }
        return result;
    }

    private static Map<String, Service> filterServiceMetadata(Map<String, Service> serviceMap, String key, String value) {
        HashMap<String, Service> result = new HashMap<String, Service>(serviceMap.size());
        for (Map.Entry<String, Service> each : serviceMap.entrySet()) {
            if (!value.equals(each.getValue().getMetadata().get(key))) continue;
            result.put(each.getKey(), each.getValue());
        }
        return result;
    }

    public static List<String> pageServiceName(int pageNo, int pageSize, Map<String, Service> serviceMap) {
        return ServiceUtil.pageServiceName(pageNo, pageSize, serviceMap.keySet());
    }

    public static List<String> pageServiceName(int pageNo, int pageSize, Collection<String> serviceNameSet) {
        ArrayList<String> result = new ArrayList<String>(serviceNameSet);
        int start = (pageNo - 1) * pageSize;
        if (start < 0) {
            start = 0;
        }
        if (start >= result.size()) {
            return result;
        }
        int end = start + pageSize;
        if (end > result.size()) {
            end = result.size();
        }
        for (int i = start; i < end; ++i) {
            String serviceName = (String)result.get(i);
            int indexOfSplitter = serviceName.indexOf("@@");
            if (indexOfSplitter > 0) {
                serviceName = serviceName.substring(indexOfSplitter + 2);
            }
            result.set(i, serviceName);
        }
        return result.subList(start, end);
    }

    public static ServiceInfo selectHealthyInstances(ServiceInfo serviceInfo) {
        return ServiceUtil.selectInstances(serviceInfo, true, false);
    }

    public static ServiceInfo selectEnabledInstances(ServiceInfo serviceInfo) {
        return ServiceUtil.selectInstances(serviceInfo, false, true);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, String cluster) {
        return ServiceUtil.selectInstances(serviceInfo, cluster, false, false);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, boolean healthyOnly, boolean enableOnly) {
        return ServiceUtil.selectInstances(serviceInfo, "", healthyOnly, enableOnly);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, String cluster, boolean healthyOnly) {
        return ServiceUtil.selectInstances(serviceInfo, cluster, healthyOnly, false);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, String cluster, boolean healthyOnly, boolean enableOnly) {
        return ServiceUtil.doSelectInstances(serviceInfo, cluster, healthyOnly, enableOnly, null);
    }

    public static ServiceInfo selectInstancesWithHealthyProtection(ServiceInfo serviceInfo, ServiceMetadata serviceMetadata, String cluster) {
        return ServiceUtil.selectInstancesWithHealthyProtection(serviceInfo, serviceMetadata, cluster, false, false);
    }

    public static ServiceInfo selectInstancesWithHealthyProtection(ServiceInfo serviceInfo, ServiceMetadata serviceMetadata, boolean healthyOnly, boolean enableOnly) {
        return ServiceUtil.selectInstancesWithHealthyProtection(serviceInfo, serviceMetadata, "", healthyOnly, enableOnly);
    }

    public static ServiceInfo selectInstancesWithHealthyProtection(ServiceInfo serviceInfo, ServiceMetadata serviceMetadata, String cluster, boolean healthyOnly, boolean enableOnly) {
        InstancesFilter filter = (filteredResult, allInstances, healthyCount) -> {
            if (serviceMetadata == null) {
                return;
            }
            float threshold = serviceMetadata.getProtectThreshold();
            if (threshold < 0.0f) {
                threshold = 0.0f;
            }
            if ((float)healthyCount / (float)allInstances.size() <= threshold) {
                Loggers.SRV_LOG.warn("protect threshold reached, return all ips, service: {}", (Object)filteredResult.getName());
                filteredResult.setReachProtectionThreshold(true);
                List filteredInstances = allInstances.stream().map(i -> {
                    if (!i.isHealthy()) {
                        i = InstanceUtil.deepCopy(i);
                        i.setHealthy(true);
                    }
                    return i;
                }).collect(Collectors.toCollection(LinkedList::new));
                filteredResult.setHosts(filteredInstances);
            }
        };
        return ServiceUtil.doSelectInstances(serviceInfo, cluster, healthyOnly, enableOnly, filter);
    }

    private static ServiceInfo doSelectInstances(ServiceInfo serviceInfo, String cluster, boolean healthyOnly, boolean enableOnly, InstancesFilter filter) {
        ServiceInfo result = new ServiceInfo();
        result.setName(serviceInfo.getName());
        result.setGroupName(serviceInfo.getGroupName());
        result.setCacheMillis(serviceInfo.getCacheMillis());
        result.setLastRefTime(System.currentTimeMillis());
        result.setClusters(cluster);
        result.setReachProtectionThreshold(false);
        HashSet<String> clusterSets = StringUtils.isNotBlank((String)cluster) ? new HashSet<String>(Arrays.asList(cluster.split(","))) : new HashSet();
        long healthyCount = 0L;
        LinkedList<com.alibaba.nacos.api.naming.pojo.Instance> filteredInstances = new LinkedList<com.alibaba.nacos.api.naming.pojo.Instance>();
        LinkedList<com.alibaba.nacos.api.naming.pojo.Instance> allInstances = new LinkedList<com.alibaba.nacos.api.naming.pojo.Instance>();
        for (com.alibaba.nacos.api.naming.pojo.Instance ip : serviceInfo.getHosts()) {
            if (!ServiceUtil.checkCluster(clusterSets, ip) || !ServiceUtil.checkEnabled(enableOnly, ip)) continue;
            if (!healthyOnly || ip.isHealthy()) {
                filteredInstances.add(ip);
            }
            if (ip.isHealthy()) {
                ++healthyCount;
            }
            allInstances.add(ip);
        }
        result.setHosts(filteredInstances);
        if (filter != null) {
            filter.doFilter(result, allInstances, healthyCount);
        }
        return result;
    }

    private static boolean checkCluster(Set<String> clusterSets, com.alibaba.nacos.api.naming.pojo.Instance instance) {
        if (clusterSets.isEmpty()) {
            return true;
        }
        return clusterSets.contains(instance.getClusterName());
    }

    private static boolean checkEnabled(boolean enableOnly, com.alibaba.nacos.api.naming.pojo.Instance instance) {
        return !enableOnly || instance.isEnabled();
    }

    private static interface InstancesFilter {
        public void doFilter(ServiceInfo var1, List<com.alibaba.nacos.api.naming.pojo.Instance> var2, long var3);
    }
}

