/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManagerDelegate;
import com.alibaba.nacos.naming.core.v2.event.service.ServiceEvent;
import com.alibaba.nacos.naming.core.v2.index.ClientServiceIndexesManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.NamingSubscriberService;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutorDelegate;
import com.alibaba.nacos.naming.push.v2.task.PushDelayTask;
import com.alibaba.nacos.naming.push.v2.task.PushDelayTaskExecuteEngine;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service
public class NamingSubscriberServiceV2Impl
extends SmartSubscriber
implements NamingSubscriberService {
    private static final int PARALLEL_SIZE = 100;
    private final ClientManager clientManager;
    private final ClientServiceIndexesManager indexesManager;
    private final PushDelayTaskExecuteEngine delayTaskEngine;
    private final UpgradeJudgement upgradeJudgement;

    public NamingSubscriberServiceV2Impl(ClientManagerDelegate clientManager, ClientServiceIndexesManager indexesManager, ServiceStorage serviceStorage, NamingMetadataManager metadataManager, PushExecutorDelegate pushExecutor, UpgradeJudgement upgradeJudgement, SwitchDomain switchDomain) {
        this.clientManager = clientManager;
        this.indexesManager = indexesManager;
        this.upgradeJudgement = upgradeJudgement;
        this.delayTaskEngine = new PushDelayTaskExecuteEngine(clientManager, indexesManager, serviceStorage, metadataManager, pushExecutor, switchDomain);
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    @Override
    public Collection<com.alibaba.nacos.naming.pojo.Subscriber> getSubscribers(String namespaceId, String serviceName) {
        String serviceNameWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        String groupName = NamingUtils.getGroupName((String)serviceName);
        com.alibaba.nacos.naming.core.v2.pojo.Service service = com.alibaba.nacos.naming.core.v2.pojo.Service.newService(namespaceId, groupName, serviceNameWithoutGroup);
        return this.getSubscribers(service);
    }

    @Override
    public Collection<com.alibaba.nacos.naming.pojo.Subscriber> getSubscribers(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        HashSet<com.alibaba.nacos.naming.pojo.Subscriber> result = new HashSet<com.alibaba.nacos.naming.pojo.Subscriber>();
        for (String each : this.indexesManager.getAllClientsSubscribeService(service)) {
            result.add(this.clientManager.getClient(each).getSubscriber(service));
        }
        return result;
    }

    @Override
    public Collection<com.alibaba.nacos.naming.pojo.Subscriber> getFuzzySubscribers(String namespaceId, String serviceName) {
        HashSet<com.alibaba.nacos.naming.pojo.Subscriber> result = new HashSet<com.alibaba.nacos.naming.pojo.Subscriber>();
        Stream<com.alibaba.nacos.naming.core.v2.pojo.Service> serviceStream = this.getServiceStream();
        String serviceNamePattern = NamingUtils.getServiceName((String)serviceName);
        String groupNamePattern = NamingUtils.getGroupName((String)serviceName);
        serviceStream.filter(service -> service.getNamespace().equals(namespaceId) && service.getName().contains(serviceNamePattern) && service.getGroup().contains(groupNamePattern)).forEach(service -> result.addAll(this.getSubscribers((com.alibaba.nacos.naming.core.v2.pojo.Service)service)));
        return result;
    }

    @Override
    public Collection<com.alibaba.nacos.naming.pojo.Subscriber> getFuzzySubscribers(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        return this.getFuzzySubscribers(service.getNamespace(), service.getGroupedServiceName());
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ServiceEvent.ServiceChangedEvent.class);
        result.add(ServiceEvent.ServiceSubscribedEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (!this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        if (event instanceof ServiceEvent.ServiceChangedEvent) {
            ServiceEvent.ServiceChangedEvent serviceChangedEvent = (ServiceEvent.ServiceChangedEvent)event;
            com.alibaba.nacos.naming.core.v2.pojo.Service service = serviceChangedEvent.getService();
            this.delayTaskEngine.addTask(service, new PushDelayTask(service, 500L));
        } else if (event instanceof ServiceEvent.ServiceSubscribedEvent) {
            ServiceEvent.ServiceSubscribedEvent subscribedEvent = (ServiceEvent.ServiceSubscribedEvent)event;
            com.alibaba.nacos.naming.core.v2.pojo.Service service = subscribedEvent.getService();
            this.delayTaskEngine.addTask(service, new PushDelayTask(service, 500L, subscribedEvent.getClientId()));
        }
    }

    private Stream<com.alibaba.nacos.naming.core.v2.pojo.Service> getServiceStream() {
        Collection<com.alibaba.nacos.naming.core.v2.pojo.Service> services = this.indexesManager.getSubscribedService();
        return services.size() > 100 ? services.parallelStream() : services.stream();
    }
}

