/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v1;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.NamingSubscriberService;
import com.alibaba.nacos.naming.push.v1.DataSource;
import com.alibaba.nacos.naming.push.v1.PushClient;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class NamingSubscriberServiceV1Impl
implements NamingSubscriberService {
    private final ConcurrentMap<String, ConcurrentMap<String, PushClient>> clientMap = new ConcurrentHashMap<String, ConcurrentMap<String, PushClient>>();

    public NamingSubscriberServiceV1Impl() {
        GlobalExecutor.scheduleRetransmitter(() -> {
            try {
                this.removeClientIfZombie();
            }
            catch (Throwable e) {
                Loggers.PUSH.warn("[NACOS-PUSH] failed to remove client zombie");
            }
        }, 0L, 20L, TimeUnit.SECONDS);
    }

    private void removeClientIfZombie() {
        int size = 0;
        for (Map.Entry entry : this.clientMap.entrySet()) {
            ConcurrentMap clientConcurrentMap = (ConcurrentMap)entry.getValue();
            for (Map.Entry entry1 : clientConcurrentMap.entrySet()) {
                PushClient client = (PushClient)entry1.getValue();
                if (!client.zombie()) continue;
                clientConcurrentMap.remove(entry1.getKey());
            }
            size += clientConcurrentMap.size();
        }
        if (Loggers.PUSH.isDebugEnabled()) {
            Loggers.PUSH.debug("[NACOS-PUSH] clientMap size: {}", (Object)size);
        }
    }

    public ConcurrentMap<String, ConcurrentMap<String, PushClient>> getClientMap() {
        return this.clientMap;
    }

    @Override
    public Collection<Subscriber> getSubscribers(String namespaceId, String serviceName) {
        String serviceKey = UtilsAndCommons.assembleFullServiceName(namespaceId, serviceName);
        ConcurrentMap clientConcurrentMap = (ConcurrentMap)this.clientMap.get(serviceKey);
        if (Objects.isNull(clientConcurrentMap)) {
            return Collections.emptyList();
        }
        ArrayList<Subscriber> result = new ArrayList<Subscriber>();
        clientConcurrentMap.forEach((key, client) -> result.add(new Subscriber(client.getAddrStr(), client.getAgent(), client.getApp(), client.getIp(), namespaceId, serviceName, client.getPort())));
        return result;
    }

    @Override
    public Collection<Subscriber> getSubscribers(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        return this.getSubscribers(service.getNamespace(), service.getGroupedServiceName());
    }

    @Override
    public Collection<Subscriber> getFuzzySubscribers(String namespaceId, String serviceName) {
        ArrayList<Subscriber> result = new ArrayList<Subscriber>();
        this.clientMap.forEach((outKey, clientConcurrentMap) -> {
            String serviceFullName = outKey.split("##")[1];
            String groupName = NamingUtils.getGroupName((String)serviceFullName);
            String name = NamingUtils.getServiceName((String)serviceFullName);
            if (outKey.startsWith(namespaceId) && name.indexOf(NamingUtils.getServiceName((String)serviceName)) >= 0 && groupName.indexOf(NamingUtils.getGroupName((String)serviceName)) >= 0) {
                clientConcurrentMap.forEach((key, client) -> result.add(new Subscriber(client.getAddrStr(), client.getAgent(), client.getApp(), client.getIp(), namespaceId, serviceFullName, client.getPort())));
            }
        });
        return result;
    }

    @Override
    public Collection<Subscriber> getFuzzySubscribers(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        return this.getFuzzySubscribers(service.getNamespace(), service.getGroupedServiceName());
    }

    public void addClient(String namespaceId, String serviceName, String clusters, String agent, InetSocketAddress socketAddr, DataSource dataSource, String tenant, String app) {
        PushClient client = new PushClient(namespaceId, serviceName, clusters, agent, socketAddr, dataSource, tenant, app);
        this.addClient(client);
    }

    public void addClient(PushClient client) {
        PushClient oldClient;
        String serviceKey = UtilsAndCommons.assembleFullServiceName(client.getNamespaceId(), client.getServiceName());
        ConcurrentMap clients = (ConcurrentMap)this.clientMap.get(serviceKey);
        if (clients == null) {
            this.clientMap.putIfAbsent(serviceKey, new ConcurrentHashMap(1024));
            clients = (ConcurrentMap)this.clientMap.get(serviceKey);
        }
        if ((oldClient = (PushClient)clients.get(client.toString())) != null) {
            oldClient.refresh();
        } else {
            PushClient res = clients.putIfAbsent(client.toString(), client);
            if (res != null) {
                Loggers.PUSH.warn("client: {} already associated with key {}", (Object)res.getAddrStr(), (Object)res.toString());
            }
            Loggers.PUSH.debug("client: {} added for serviceName: {}", (Object)client.getAddrStr(), (Object)client.getServiceName());
        }
    }
}

