/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.monitor;

import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingExecuteTaskDispatcher;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PerformanceLoggerThread {
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private RaftCore raftCore;
    @Autowired
    private ClusterVersionJudgement versionJudgement;
    private static final long PERIOD = 60L;

    @PostConstruct
    public void init() {
        this.start();
    }

    private void start() {
        PerformanceLogTask task = new PerformanceLogTask();
        GlobalExecutor.schedulePerformanceLogger(task, 30L, 60L, TimeUnit.SECONDS);
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void refreshMetrics() {
        MetricsMonitor.resetAll();
    }

    @Scheduled(cron="0/15 * * * * ?")
    public void collectMetrics() {
        MetricsMonitor.getDomCountMonitor().set(com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().size());
        MetricsMonitor.getAvgPushCostMonitor().set(this.getAvgPushCost());
        this.metricsRaftLeader();
    }

    @Deprecated
    private void metricsRaftLeader() {
        if (!this.versionJudgement.allMemberIsNewVersion()) {
            if (this.raftCore.isLeader()) {
                MetricsMonitor.getLeaderStatusMonitor().set(1L);
            } else if (this.raftCore.getPeerSet().local().state == RaftPeer.State.FOLLOWER) {
                MetricsMonitor.getLeaderStatusMonitor().set(0L);
            } else {
                MetricsMonitor.getLeaderStatusMonitor().set(2L);
            }
        }
    }

    private long getAvgPushCost() {
        int size = MetricsMonitor.getTotalPushCountForAvg().get();
        long totalCost = MetricsMonitor.getTotalPushCostForAvg().get();
        return size > 0 && totalCost > 0L ? totalCost / (long)size : -1L;
    }

    class PerformanceLogTask
    implements Runnable {
        private int logCount = 0;

        PerformanceLogTask() {
        }

        @Override
        public void run() {
            try {
                this.logCount %= 10;
                if (this.logCount == 0) {
                    Loggers.PERFORMANCE_LOG.info("PERFORMANCE:|serviceCount|ipCount|subscribeCount|maxPushCost|avgPushCost|totalPushCount|failPushCount");
                }
                int serviceCount = com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().size();
                int ipCount = MetricsMonitor.getIpCountMonitor().get();
                int subscribeCount = MetricsMonitor.getSubscriberCount().get();
                long maxPushCost = MetricsMonitor.getMaxPushCostMonitor().get();
                long avgPushCost = PerformanceLoggerThread.this.getAvgPushCost();
                long totalPushCount = MetricsMonitor.getTotalPushMonitor().longValue();
                long failPushCount = MetricsMonitor.getFailedPushMonitor().longValue();
                Loggers.PERFORMANCE_LOG.info("PERFORMANCE:|{}|{}|{}|{}|{}|{}|{}", new Object[]{serviceCount, ipCount, subscribeCount, maxPushCost, avgPushCost, totalPushCount, failPushCount});
                Loggers.PERFORMANCE_LOG.info("Task worker status: \n" + NamingExecuteTaskDispatcher.getInstance().workersStatus());
                ++this.logCount;
                MetricsMonitor.getTotalPushCountForAvg().set(0);
                MetricsMonitor.getTotalPushCostForAvg().set(0L);
                MetricsMonitor.getMaxPushCostMonitor().set(-1L);
            }
            catch (Exception e) {
                Loggers.SRV_LOG.warn("[PERFORMANCE] Exception while print performance log.", (Throwable)e);
            }
        }
    }
}

