/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.monitor;

import com.alibaba.nacos.core.remote.control.TpsMonitorManager;
import com.alibaba.nacos.core.remote.control.TpsMonitorPoint;
import com.alibaba.nacos.naming.monitor.TpsMonitorItem;
import com.alibaba.nacos.sys.utils.ApplicationUtils;

public class NamingTpsMonitor {
    private static final NamingTpsMonitor INSTANCE = new NamingTpsMonitor();
    private final TpsMonitorManager tpsMonitorManager = (TpsMonitorManager)ApplicationUtils.getBean(TpsMonitorManager.class);

    private NamingTpsMonitor() {
        this.registerPushMonitorPoint();
    }

    private void registerPushMonitorPoint() {
        this.tpsMonitorManager.registerTpsControlPoint(new TpsMonitorPoint(TpsMonitorItem.NAMING_RPC_PUSH.name()));
        this.tpsMonitorManager.registerTpsControlPoint(new TpsMonitorPoint(TpsMonitorItem.NAMING_RPC_PUSH_SUCCESS.name()));
        this.tpsMonitorManager.registerTpsControlPoint(new TpsMonitorPoint(TpsMonitorItem.NAMING_RPC_PUSH_FAIL.name()));
        this.tpsMonitorManager.registerTpsControlPoint(new TpsMonitorPoint(TpsMonitorItem.NAMING_UDP_PUSH.name()));
        this.tpsMonitorManager.registerTpsControlPoint(new TpsMonitorPoint(TpsMonitorItem.NAMING_UDP_PUSH_SUCCESS.name()));
        this.tpsMonitorManager.registerTpsControlPoint(new TpsMonitorPoint(TpsMonitorItem.NAMING_UDP_PUSH_FAIL.name()));
    }

    public static NamingTpsMonitor getInstance() {
        return INSTANCE;
    }

    public static void rpcPushSuccess(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_RPC_PUSH.name(), clientId, clientIp);
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_RPC_PUSH_SUCCESS.name(), clientId, clientIp);
    }

    public static void rpcPushFail(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_RPC_PUSH.name(), clientId, clientIp);
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_RPC_PUSH_FAIL.name(), clientId, clientIp);
    }

    public static void udpPushSuccess(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_UDP_PUSH.name(), clientId, clientIp);
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_UDP_PUSH_SUCCESS.name(), clientId, clientIp);
    }

    public static void udpPushFail(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_UDP_PUSH.name(), clientId, clientIp);
        NamingTpsMonitor.INSTANCE.tpsMonitorManager.applyTpsForClientIp(TpsMonitorItem.NAMING_UDP_PUSH_FAIL.name(), clientId, clientIp);
    }
}

