/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.consistency.ConsistencyService;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SwitchManager
implements RecordListener<SwitchDomain> {
    @Autowired
    private SwitchDomain switchDomain;
    @Resource(name="consistencyDelegate")
    private ConsistencyService consistencyService;
    ReentrantLock lock = new ReentrantLock();

    @PostConstruct
    public void init() {
        try {
            this.consistencyService.listen(KeyBuilder.getSwitchDomainKey(), this);
        }
        catch (NacosException e) {
            Loggers.SRV_LOG.error("listen switch service failed.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String entry, String value, boolean debug) throws Exception {
        this.lock.lock();
        try {
            Datum datum = this.consistencyService.get(KeyBuilder.getSwitchDomainKey());
            SwitchDomain switchDomain = datum != null && datum.value != null ? (SwitchDomain)datum.value : this.switchDomain.clone();
            if ("batch".equals(entry)) {
                SwitchDomain dom = (SwitchDomain)JacksonUtils.toObj((String)value, SwitchDomain.class);
                dom.setEnableStandalone(switchDomain.isEnableStandalone());
                if (dom.getHttpHealthParams().getMin() < 500 || dom.getTcpHealthParams().getMin() < 500) {
                    throw new IllegalArgumentException("min check time for http or tcp is too small(<500)");
                }
                if (dom.getHttpHealthParams().getMax() < 3000 || dom.getTcpHealthParams().getMax() < 3000) {
                    throw new IllegalArgumentException("max check time for http or tcp is too small(<3000)");
                }
                if (dom.getHttpHealthParams().getFactor() < 0.0f || dom.getHttpHealthParams().getFactor() > 1.0f || dom.getTcpHealthParams().getFactor() < 0.0f || dom.getTcpHealthParams().getFactor() > 1.0f) {
                    throw new IllegalArgumentException("malformed factor");
                }
                switchDomain = dom;
            }
            if (entry.equals("distroThreshold")) {
                float threshold = Float.parseFloat(value);
                if (threshold <= 0.0f) {
                    throw new IllegalArgumentException("distroThreshold can not be zero or negative: " + threshold);
                }
                switchDomain.setDistroThreshold(threshold);
            }
            if (entry.equals("clientBeatInterval")) {
                long clientBeatInterval = Long.parseLong(value);
                switchDomain.setClientBeatInterval(clientBeatInterval);
            }
            if (entry.equals("pushVersion")) {
                String type = value.split(":")[0];
                String version = value.split(":")[1];
                if (!version.matches("[0-9]+\\.[0-9]+\\.[0-9]+")) {
                    throw new IllegalArgumentException("illegal version, must match: [0-9]+\\.[0-9]+\\.[0-9]+");
                }
                if (StringUtils.equals((CharSequence)"java", (CharSequence)type)) {
                    switchDomain.setPushJavaVersion(version);
                } else if (StringUtils.equals((CharSequence)"python", (CharSequence)type)) {
                    switchDomain.setPushPythonVersion(version);
                } else if (StringUtils.equals((CharSequence)"c", (CharSequence)type)) {
                    switchDomain.setPushCVersion(version);
                } else if (StringUtils.equals((CharSequence)"go", (CharSequence)type)) {
                    switchDomain.setPushGoVersion(version);
                } else {
                    throw new IllegalArgumentException("unsupported client type: " + type);
                }
            }
            if (entry.equals("pushCacheMillis")) {
                long cacheMillis = Long.parseLong(value);
                if (cacheMillis < 10000L) {
                    throw new IllegalArgumentException("min cache time for http or tcp is too small(<10000)");
                }
                switchDomain.setDefaultPushCacheMillis(cacheMillis);
            }
            if (entry.equals("defaultCacheMillis")) {
                long cacheMillis = Long.parseLong(value);
                if (cacheMillis < 1000L) {
                    throw new IllegalArgumentException("min default cache time  is too small(<1000)");
                }
                switchDomain.setDefaultCacheMillis(cacheMillis);
            }
            if (entry.equals("masters")) {
                List<String> masters = Arrays.asList(value.split(","));
                switchDomain.setMasters(masters);
            }
            if (entry.equals("distro")) {
                boolean enabled = Boolean.parseBoolean(value);
                switchDomain.setDistroEnabled(enabled);
            }
            if (entry.equals("check")) {
                boolean enabled = Boolean.parseBoolean(value);
                switchDomain.setHealthCheckEnabled(enabled);
            }
            if (entry.equals("pushEnabled")) {
                boolean enabled = Boolean.parseBoolean(value);
                switchDomain.setPushEnabled(enabled);
            }
            if (entry.equals("serviceStatusSynchronizationPeriodMillis")) {
                long millis = Long.parseLong(value);
                if (millis < 5000L) {
                    throw new IllegalArgumentException("serviceStatusSynchronizationPeriodMillis is too small(<5000)");
                }
                switchDomain.setServiceStatusSynchronizationPeriodMillis(millis);
            }
            if (entry.equals("serverStatusSynchronizationPeriodMillis")) {
                long millis = Long.parseLong(value);
                if (millis < 1000L) {
                    throw new IllegalArgumentException("serverStatusSynchronizationPeriodMillis is too small(<15000)");
                }
                switchDomain.setServerStatusSynchronizationPeriodMillis(millis);
            }
            if (entry.equals("healthCheckTimes")) {
                int times = Integer.parseInt(value);
                switchDomain.setCheckTimes(times);
            }
            if (entry.equals("disableAddIP")) {
                boolean disableAddIp = Boolean.parseBoolean(value);
                switchDomain.setDisableAddIP(disableAddIp);
            }
            if (entry.equals("sendBeatOnly")) {
                boolean sendBeatOnly = Boolean.parseBoolean(value);
                switchDomain.setSendBeatOnly(sendBeatOnly);
            }
            if (entry.equals("limitedUrlMap")) {
                HashMap<String, Integer> limitedUrlMap = new HashMap<String, Integer>(16);
                if (!StringUtils.isEmpty((CharSequence)value)) {
                    String[] entries;
                    for (String each : entries = value.split(",")) {
                        String[] parts = each.split(":");
                        if (parts.length < 2) {
                            throw new IllegalArgumentException("invalid input for limited urls");
                        }
                        String limitedUrl = parts[0];
                        if (StringUtils.isEmpty((CharSequence)limitedUrl)) {
                            throw new IllegalArgumentException("url can not be empty, url: " + limitedUrl);
                        }
                        int statusCode = Integer.parseInt(parts[1]);
                        if (statusCode <= 0) {
                            throw new IllegalArgumentException("illegal normal status code: " + statusCode);
                        }
                        limitedUrlMap.put(limitedUrl, statusCode);
                    }
                    switchDomain.setLimitedUrlMap(limitedUrlMap);
                }
            }
            if (entry.equals("enableStandalone") && !StringUtils.isNotEmpty((CharSequence)value)) {
                switchDomain.setEnableStandalone(Boolean.parseBoolean(value));
            }
            if (entry.equals("overriddenServerStatus")) {
                String status = value;
                if ("null".equals(status)) {
                    status = "";
                }
                switchDomain.setOverriddenServerStatus(status);
            }
            if (entry.equals("defaultInstanceEphemeral")) {
                switchDomain.setDefaultInstanceEphemeral(Boolean.parseBoolean(value));
            }
            if (entry.equals("distroServerExpiredMillis")) {
                switchDomain.setDistroServerExpiredMillis(Long.parseLong(value));
            }
            if (entry.equals("lightBeatEnabled")) {
                switchDomain.setLightBeatEnabled(BooleanUtils.toBoolean((String)value));
            }
            if (entry.equals("autoChangeHealthCheckEnabled")) {
                switchDomain.setAutoChangeHealthCheckEnabled(BooleanUtils.toBoolean((String)value));
            }
            if (entry.equals("doubleWriteEnabled")) {
                switchDomain.setDoubleWriteEnabled(BooleanUtils.toBoolean((String)value));
            }
            if (debug) {
                this.update(switchDomain);
            } else {
                this.consistencyService.put(KeyBuilder.getSwitchDomainKey(), switchDomain);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void update(SwitchDomain newSwitchDomain) {
        this.switchDomain.setMasters(newSwitchDomain.getMasters());
        this.switchDomain.setAdWeightMap(newSwitchDomain.getAdWeightMap());
        this.switchDomain.setDefaultPushCacheMillis(newSwitchDomain.getDefaultPushCacheMillis());
        this.switchDomain.setClientBeatInterval(newSwitchDomain.getClientBeatInterval());
        this.switchDomain.setDefaultCacheMillis(newSwitchDomain.getDefaultCacheMillis());
        this.switchDomain.setDistroThreshold(newSwitchDomain.getDistroThreshold());
        this.switchDomain.setHealthCheckEnabled(newSwitchDomain.isHealthCheckEnabled());
        this.switchDomain.setAutoChangeHealthCheckEnabled(newSwitchDomain.isAutoChangeHealthCheckEnabled());
        this.switchDomain.setDistroEnabled(newSwitchDomain.isDistroEnabled());
        this.switchDomain.setPushEnabled(newSwitchDomain.isPushEnabled());
        this.switchDomain.setEnableStandalone(newSwitchDomain.isEnableStandalone());
        this.switchDomain.setCheckTimes(newSwitchDomain.getCheckTimes());
        this.switchDomain.setHttpHealthParams(newSwitchDomain.getHttpHealthParams());
        this.switchDomain.setTcpHealthParams(newSwitchDomain.getTcpHealthParams());
        this.switchDomain.setMysqlHealthParams(newSwitchDomain.getMysqlHealthParams());
        this.switchDomain.setIncrementalList(newSwitchDomain.getIncrementalList());
        this.switchDomain.setServerStatusSynchronizationPeriodMillis(newSwitchDomain.getServerStatusSynchronizationPeriodMillis());
        this.switchDomain.setServiceStatusSynchronizationPeriodMillis(newSwitchDomain.getServiceStatusSynchronizationPeriodMillis());
        this.switchDomain.setDisableAddIP(newSwitchDomain.isDisableAddIP());
        this.switchDomain.setSendBeatOnly(newSwitchDomain.isSendBeatOnly());
        this.switchDomain.setLimitedUrlMap(newSwitchDomain.getLimitedUrlMap());
        this.switchDomain.setDistroServerExpiredMillis(newSwitchDomain.getDistroServerExpiredMillis());
        this.switchDomain.setPushGoVersion(newSwitchDomain.getPushGoVersion());
        this.switchDomain.setPushJavaVersion(newSwitchDomain.getPushJavaVersion());
        this.switchDomain.setPushPythonVersion(newSwitchDomain.getPushPythonVersion());
        this.switchDomain.setPushCVersion(newSwitchDomain.getPushCVersion());
        this.switchDomain.setEnableAuthentication(newSwitchDomain.isEnableAuthentication());
        this.switchDomain.setOverriddenServerStatus(newSwitchDomain.getOverriddenServerStatus());
        this.switchDomain.setDefaultInstanceEphemeral(newSwitchDomain.isDefaultInstanceEphemeral());
        this.switchDomain.setLightBeatEnabled(newSwitchDomain.isLightBeatEnabled());
        this.switchDomain.setDoubleWriteEnabled(newSwitchDomain.isDoubleWriteEnabled());
    }

    public SwitchDomain getSwitchDomain() {
        return this.switchDomain;
    }

    @Override
    public boolean interests(String key) {
        return KeyBuilder.matchSwitchKey(key);
    }

    @Override
    public boolean matchUnlistenKey(String key) {
        return KeyBuilder.matchSwitchKey(key);
    }

    @Override
    public void onChange(String key, SwitchDomain domain) throws Exception {
        this.update(domain);
    }

    @Override
    public void onDelete(String key) throws Exception {
    }
}

