/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessorDelegate;
import com.alibaba.nacos.naming.healthcheck.HealthCheckReactor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.RandomUtils;

public class HealthCheckTask
implements Runnable {
    private Cluster cluster;
    private long checkRtNormalized = -1L;
    private long checkRtBest = -1L;
    private long checkRtWorst = -1L;
    private long checkRtLast = -1L;
    private long checkRtLastLast = -1L;
    private long startTime;
    private volatile boolean cancelled = false;
    @JsonIgnore
    private final DistroMapper distroMapper;
    @JsonIgnore
    private final SwitchDomain switchDomain;
    @JsonIgnore
    private final HealthCheckProcessor healthCheckProcessor;

    public HealthCheckTask(Cluster cluster) {
        this.cluster = cluster;
        this.distroMapper = (DistroMapper)((Object)ApplicationUtils.getBean(DistroMapper.class));
        this.switchDomain = (SwitchDomain)ApplicationUtils.getBean(SwitchDomain.class);
        this.healthCheckProcessor = (HealthCheckProcessor)ApplicationUtils.getBean(HealthCheckProcessorDelegate.class);
        this.initCheckRT();
    }

    private void initCheckRT() {
        this.checkRtNormalized = 2000 + RandomUtils.nextInt((int)0, (int)RandomUtils.nextInt((int)0, (int)this.switchDomain.getTcpHealthParams().getMax()));
        this.checkRtBest = Long.MAX_VALUE;
        this.checkRtWorst = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block7: {
            if (!((UpgradeJudgement)((Object)ApplicationUtils.getBean(UpgradeJudgement.class))).isUseGrpcFeatures()) break block7;
            if (this.cancelled) return;
            HealthCheckReactor.scheduleCheck(this);
            if (this.getCheckRtWorst() <= 0L || !this.switchDomain.isHealthCheckEnabled(this.cluster.getService().getName()) || !this.distroMapper.responsible(this.cluster.getService().getName())) return;
            long diff = (this.getCheckRtLast() - this.getCheckRtLastLast()) * 10000L / this.getCheckRtLastLast();
            this.setCheckRtLastLast(this.getCheckRtLast());
            Cluster cluster = this.getCluster();
            if (!Loggers.CHECK_RT.isDebugEnabled()) return;
            Loggers.CHECK_RT.debug("{}:{}@{}->normalized: {}, worst: {}, best: {}, last: {}, diff: {}", new Object[]{cluster.getService().getName(), cluster.getName(), cluster.getHealthChecker().getType(), this.getCheckRtNormalized(), this.getCheckRtWorst(), this.getCheckRtBest(), this.getCheckRtLast(), diff});
            return;
        }
        try {
            if (this.distroMapper.responsible(this.cluster.getService().getName()) && this.switchDomain.isHealthCheckEnabled(this.cluster.getService().getName())) {
                this.healthCheckProcessor.process(this);
                if (Loggers.EVT_LOG.isDebugEnabled()) {
                    Loggers.EVT_LOG.debug("[HEALTH-CHECK] schedule health check task: {}", (Object)this.cluster.getService().getName());
                }
            }
            if (this.cancelled) return;
        }
        catch (Throwable e) {
            try {
                Loggers.SRV_LOG.error("[HEALTH-CHECK] error while process health check for {}:{}", new Object[]{this.cluster.getService().getName(), this.cluster.getName(), e});
                if (this.cancelled) return;
            }
            catch (Throwable throwable) {
                if (this.cancelled) throw throwable;
                HealthCheckReactor.scheduleCheck(this);
                if (this.getCheckRtWorst() <= 0L || !this.switchDomain.isHealthCheckEnabled(this.cluster.getService().getName()) || !this.distroMapper.responsible(this.cluster.getService().getName())) throw throwable;
                long diff = (this.getCheckRtLast() - this.getCheckRtLastLast()) * 10000L / this.getCheckRtLastLast();
                this.setCheckRtLastLast(this.getCheckRtLast());
                Cluster cluster = this.getCluster();
                if (!Loggers.CHECK_RT.isDebugEnabled()) throw throwable;
                Loggers.CHECK_RT.debug("{}:{}@{}->normalized: {}, worst: {}, best: {}, last: {}, diff: {}", new Object[]{cluster.getService().getName(), cluster.getName(), cluster.getHealthChecker().getType(), this.getCheckRtNormalized(), this.getCheckRtWorst(), this.getCheckRtBest(), this.getCheckRtLast(), diff});
                throw throwable;
            }
            HealthCheckReactor.scheduleCheck(this);
            if (this.getCheckRtWorst() <= 0L || !this.switchDomain.isHealthCheckEnabled(this.cluster.getService().getName()) || !this.distroMapper.responsible(this.cluster.getService().getName())) return;
            long diff = (this.getCheckRtLast() - this.getCheckRtLastLast()) * 10000L / this.getCheckRtLastLast();
            this.setCheckRtLastLast(this.getCheckRtLast());
            Cluster cluster = this.getCluster();
            if (!Loggers.CHECK_RT.isDebugEnabled()) return;
            Loggers.CHECK_RT.debug("{}:{}@{}->normalized: {}, worst: {}, best: {}, last: {}, diff: {}", new Object[]{cluster.getService().getName(), cluster.getName(), cluster.getHealthChecker().getType(), this.getCheckRtNormalized(), this.getCheckRtWorst(), this.getCheckRtBest(), this.getCheckRtLast(), diff});
            return;
        }
        HealthCheckReactor.scheduleCheck(this);
        if (this.getCheckRtWorst() <= 0L || !this.switchDomain.isHealthCheckEnabled(this.cluster.getService().getName()) || !this.distroMapper.responsible(this.cluster.getService().getName())) return;
        long diff = (this.getCheckRtLast() - this.getCheckRtLastLast()) * 10000L / this.getCheckRtLastLast();
        this.setCheckRtLastLast(this.getCheckRtLast());
        Cluster cluster = this.getCluster();
        if (!Loggers.CHECK_RT.isDebugEnabled()) return;
        Loggers.CHECK_RT.debug("{}:{}@{}->normalized: {}, worst: {}, best: {}, last: {}, diff: {}", new Object[]{cluster.getService().getName(), cluster.getName(), cluster.getHealthChecker().getType(), this.getCheckRtNormalized(), this.getCheckRtWorst(), this.getCheckRtBest(), this.getCheckRtLast(), diff});
        return;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public long getCheckRtNormalized() {
        return this.checkRtNormalized;
    }

    public long getCheckRtBest() {
        return this.checkRtBest;
    }

    public long getCheckRtWorst() {
        return this.checkRtWorst;
    }

    public void setCheckRtWorst(long checkRtWorst) {
        this.checkRtWorst = checkRtWorst;
    }

    public void setCheckRtBest(long checkRtBest) {
        this.checkRtBest = checkRtBest;
    }

    public void setCheckRtNormalized(long checkRtNormalized) {
        this.checkRtNormalized = checkRtNormalized;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getCheckRtLast() {
        return this.checkRtLast;
    }

    public void setCheckRtLast(long checkRtLast) {
        this.checkRtLast = checkRtLast;
    }

    public long getCheckRtLastLast() {
        return this.checkRtLastLast;
    }

    public void setCheckRtLastLast(long checkRtLastLast) {
        this.checkRtLastLast = checkRtLastLast;
    }
}

