/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV2Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Map;
import java.util.Optional;

public class DoubleWriteMetadataChangeToV1Task
extends AbstractExecuteTask {
    private final com.alibaba.nacos.naming.core.v2.pojo.Service service;

    public DoubleWriteMetadataChangeToV1Task(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        this.service = service;
    }

    public void run() {
        try {
            NamingMetadataManager metadataManager = (NamingMetadataManager)((Object)ApplicationUtils.getBean(NamingMetadataManager.class));
            Optional<ServiceMetadata> serviceMetadata = metadataManager.getServiceMetadata(this.service);
            if (!serviceMetadata.isPresent()) {
                return;
            }
            ServiceManager serviceManager = (ServiceManager)ApplicationUtils.getBean(ServiceManager.class);
            Service serviceV1 = this.newServiceForV1(serviceManager, serviceMetadata.get());
            serviceManager.addOrReplaceService(serviceV1);
        }
        catch (Exception e) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("Double write task for {} metadata from 2 to 1 failed", (Object)this.service, (Object)e);
            }
            ServiceChangeV2Task retryTask = new ServiceChangeV2Task(this.service, DoubleWriteContent.METADATA);
            retryTask.setTaskInterval(3000L);
            String taskKey = ServiceChangeV2Task.getKey(this.service);
            ((DoubleWriteDelayTaskEngine)((Object)ApplicationUtils.getBean(DoubleWriteDelayTaskEngine.class))).addTask(taskKey, retryTask);
        }
    }

    private Service newServiceForV1(ServiceManager serviceManager, ServiceMetadata serviceMetadata) {
        Service result = serviceManager.getService(this.service.getNamespace(), this.service.getGroupedServiceName());
        if (null == result) {
            result = new Service(this.service.getGroupedServiceName());
            result.setGroupName(this.service.getGroup());
            result.setNamespaceId(this.service.getNamespace());
        }
        result.setSelector(serviceMetadata.getSelector());
        result.setProtectThreshold(serviceMetadata.getProtectThreshold());
        result.setMetadata(serviceMetadata.getExtendData());
        for (Map.Entry<String, ClusterMetadata> entry : serviceMetadata.getClusters().entrySet()) {
            if (!result.getClusterMap().containsKey(entry.getKey())) {
                result.addCluster(this.newClusterV1(entry.getValue()));
                continue;
            }
            this.updateCluster(result.getClusterMap().get(entry.getKey()), entry.getValue());
        }
        result.init();
        return result;
    }

    private Cluster newClusterV1(ClusterMetadata metadata) {
        Cluster result = new Cluster();
        result.setDefCkport(metadata.getHealthyCheckPort());
        result.setUseIPPort4Check(metadata.isUseInstancePortForCheck());
        result.setHealthChecker(metadata.getHealthChecker());
        result.setMetadata(metadata.getExtendData());
        return result;
    }

    private void updateCluster(Cluster cluster, ClusterMetadata metadata) {
        cluster.setDefCkport(metadata.getHealthyCheckPort());
        cluster.setUseIPPort4Check(metadata.isUseInstancePortForCheck());
        cluster.setHealthChecker(metadata.getHealthChecker());
        cluster.setMetadata(metadata.getExtendData());
    }
}

