/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.consistency.ConsistencyService;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Instances;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV2Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;

public class DoubleWriteInstanceChangeToV1Task
extends AbstractExecuteTask {
    private final com.alibaba.nacos.naming.core.v2.pojo.Service service;

    public DoubleWriteInstanceChangeToV1Task(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        this.service = service;
    }

    public void run() {
        try {
            ServiceManager serviceManager = (ServiceManager)ApplicationUtils.getBean(ServiceManager.class);
            Service serviceV1 = serviceManager.getService(this.service.getNamespace(), this.service.getGroupedServiceName());
            if (null == serviceV1) {
                serviceManager.createEmptyService(this.service.getNamespace(), this.service.getGroupedServiceName(), this.service.isEphemeral());
            }
            Instances newInstances = this.getNewInstances();
            String key = KeyBuilder.buildInstanceListKey(this.service.getNamespace(), this.service.getGroupedServiceName(), this.service.isEphemeral());
            ConsistencyService consistencyService = (ConsistencyService)ApplicationUtils.getBean((String)"consistencyDelegate", ConsistencyService.class);
            consistencyService.put(key, newInstances);
        }
        catch (Exception e) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("Double write task for {} instance from 2 to 1 failed", (Object)this.service, (Object)e);
            }
            ServiceChangeV2Task retryTask = new ServiceChangeV2Task(this.service, DoubleWriteContent.INSTANCE);
            retryTask.setTaskInterval(3000L);
            String taskKey = ServiceChangeV2Task.getKey(this.service);
            ((DoubleWriteDelayTaskEngine)((Object)ApplicationUtils.getBean(DoubleWriteDelayTaskEngine.class))).addTask(taskKey, retryTask);
        }
    }

    private Instances getNewInstances() {
        Instances result = new Instances();
        ServiceStorage serviceStorage = (ServiceStorage)ApplicationUtils.getBean(ServiceStorage.class);
        long currentTimeStamp = System.currentTimeMillis();
        for (com.alibaba.nacos.api.naming.pojo.Instance each : serviceStorage.getData(this.service).getHosts()) {
            Instance instance = new Instance();
            instance.setIp(each.getIp());
            instance.setPort(each.getPort());
            instance.setClusterName(each.getClusterName());
            instance.setHealthy(each.isHealthy());
            instance.setEphemeral(each.isEphemeral());
            instance.setWeight(each.getWeight());
            instance.setMetadata(each.getMetadata());
            instance.setEnabled(each.isEnabled());
            instance.setServiceName(each.getServiceName());
            instance.setLastBeat(currentTimeStamp);
            result.getInstanceList().add(instance);
        }
        return result;
    }
}

