/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV1Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Map;

public class AsyncServicesCheckTask
extends AbstractExecuteTask {
    private final DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine;
    private final UpgradeJudgement upgradeJudgement;

    public AsyncServicesCheckTask(DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine, UpgradeJudgement upgradeJudgement) {
        this.doubleWriteDelayTaskEngine = doubleWriteDelayTaskEngine;
        this.upgradeJudgement = upgradeJudgement;
    }

    public void run() {
        if (this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        try {
            ServiceManager serviceManager = (ServiceManager)ApplicationUtils.getBean(ServiceManager.class);
            ServiceStorage serviceStorage = (ServiceStorage)ApplicationUtils.getBean(ServiceStorage.class);
            for (String each : serviceManager.getAllNamespaces()) {
                for (Map.Entry<String, Service> entry : serviceManager.chooseServiceMap(each).entrySet()) {
                    this.checkService(each, entry.getKey(), entry.getValue(), serviceStorage);
                }
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("async check for service error");
        }
    }

    private void checkService(String namespace, String fullServiceName, Service serviceV1, ServiceStorage serviceStorage) {
        if (this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        String groupName = serviceV1.getGroupName();
        String serviceName = NamingUtils.getServiceName((String)fullServiceName);
        com.alibaba.nacos.naming.core.v2.pojo.Service serviceV2 = com.alibaba.nacos.naming.core.v2.pojo.Service.newService(namespace, groupName, serviceName);
        ServiceInfo serviceInfo = serviceStorage.getData(serviceV2);
        if (serviceV1.allIPs().size() != serviceInfo.getHosts().size()) {
            boolean isEphemeral = serviceV1.allIPs(false).isEmpty();
            String key = ServiceChangeV1Task.getKey(namespace, fullServiceName, isEphemeral);
            ServiceChangeV1Task task = new ServiceChangeV1Task(namespace, fullServiceName, isEphemeral, DoubleWriteContent.INSTANCE);
            this.doubleWriteDelayTaskEngine.addTask(key, task);
        }
    }
}

