/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.v2.event.service.ServiceEvent;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV1Task;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV2Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class DoubleWriteEventListener
extends Subscriber<ServiceEvent.ServiceChangedEvent> {
    private final UpgradeJudgement upgradeJudgement;
    private final DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine;
    private volatile boolean stopDoubleWrite;

    public DoubleWriteEventListener(UpgradeJudgement upgradeJudgement, DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine) {
        this.upgradeJudgement = upgradeJudgement;
        this.doubleWriteDelayTaskEngine = doubleWriteDelayTaskEngine;
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.stopDoubleWrite = EnvUtil.getStandaloneMode();
        if (!this.stopDoubleWrite) {
            DoubleWriteEnabledChecker doubleWriteEnabledChecker = new DoubleWriteEnabledChecker();
            doubleWriteEnabledChecker.start();
        }
    }

    public void onEvent(ServiceEvent.ServiceChangedEvent event) {
        if (this.stopDoubleWrite) {
            return;
        }
        if (!this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        String taskKey = ServiceChangeV2Task.getKey(event.getService());
        ServiceChangeV2Task task = new ServiceChangeV2Task(event.getService(), DoubleWriteContent.INSTANCE);
        this.doubleWriteDelayTaskEngine.addTask(taskKey, task);
    }

    public Class<? extends Event> subscribeType() {
        return ServiceEvent.ServiceChangedEvent.class;
    }

    public void doubleWriteMetadataToV1(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        if (this.stopDoubleWrite) {
            return;
        }
        if (!this.upgradeJudgement.isUseGrpcFeatures()) {
            return;
        }
        this.doubleWriteDelayTaskEngine.addTask(ServiceChangeV2Task.getKey(service), new ServiceChangeV2Task(service, DoubleWriteContent.METADATA));
    }

    public void doubleWriteToV2(Service service, boolean ephemeral) {
        if (this.stopDoubleWrite) {
            return;
        }
        if (this.upgradeJudgement.isUseGrpcFeatures() || this.upgradeJudgement.isAll20XVersion()) {
            return;
        }
        String namespace = service.getNamespaceId();
        String serviceName = service.getName();
        this.doubleWriteDelayTaskEngine.addTask(ServiceChangeV1Task.getKey(namespace, serviceName, ephemeral), new ServiceChangeV1Task(namespace, serviceName, ephemeral, DoubleWriteContent.INSTANCE));
    }

    public void doubleWriteMetadataToV2(Service service, boolean ephemeral) {
        if (this.stopDoubleWrite) {
            return;
        }
        if (this.upgradeJudgement.isUseGrpcFeatures() || this.upgradeJudgement.isAll20XVersion()) {
            return;
        }
        String namespace = service.getNamespaceId();
        String serviceName = service.getName();
        this.doubleWriteDelayTaskEngine.addTask(ServiceChangeV1Task.getKey(namespace, serviceName, ephemeral), new ServiceChangeV1Task(namespace, serviceName, ephemeral, DoubleWriteContent.METADATA));
    }

    private class DoubleWriteEnabledChecker
    extends Thread {
        private volatile boolean stillCheck = true;

        private DoubleWriteEnabledChecker() {
        }

        @Override
        public void run() {
            Loggers.SRV_LOG.info("Check whether close double write");
            while (this.stillCheck) {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                    DoubleWriteEventListener.this.stopDoubleWrite = !((SwitchDomain)ApplicationUtils.getBean(SwitchDomain.class)).isDoubleWriteEnabled();
                    if (!DoubleWriteEventListener.this.stopDoubleWrite) continue;
                    DoubleWriteEventListener.this.upgradeJudgement.stopAll();
                    this.stillCheck = false;
                }
                catch (Exception e) {
                    Loggers.SRV_LOG.error("Close double write failed ", (Throwable)e);
                }
            }
            Loggers.SRV_LOG.info("Check double write closed");
        }
    }
}

