/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.metadata;

import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.MetadataOperation;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadataSnapshotOperation;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteEventListener;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springframework.stereotype.Component;

@Component
public class ServiceMetadataProcessor
extends RequestProcessor4CP {
    private final NamingMetadataManager namingMetadataManager;
    private final ServiceStorage serviceStorage;
    private final Serializer serializer;
    private final Type processType;
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock.ReadLock readLock;

    public ServiceMetadataProcessor(NamingMetadataManager namingMetadataManager, ProtocolManager protocolManager, ServiceStorage serviceStorage) {
        this.namingMetadataManager = namingMetadataManager;
        this.serviceStorage = serviceStorage;
        this.serializer = SerializeFactory.getDefault();
        this.processType = TypeUtils.parameterize(MetadataOperation.class, (Type[])new Type[]{ServiceMetadata.class});
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        protocolManager.getCpProtocol().addRequestProcessors(Collections.singletonList(this));
    }

    public List<SnapshotOperation> loadSnapshotOperate() {
        return Collections.singletonList(new ServiceMetadataSnapshotOperation(this.namingMetadataManager, this.lock));
    }

    public Response onRequest(ReadRequest request) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onApply(WriteRequest request) {
        MetadataOperation op = (MetadataOperation)this.serializer.deserialize(request.getData().toByteArray(), this.processType);
        this.readLock.lock();
        try {
            switch (DataOperation.valueOf((String)request.getOperation())) {
                case ADD: {
                    this.addClusterMetadataToService(op);
                    break;
                }
                case CHANGE: {
                    this.updateServiceMetadata(op);
                    break;
                }
                case DELETE: {
                    this.deleteServiceMetadata(op);
                    break;
                }
                default: {
                    Response response = Response.newBuilder().setSuccess(false).setErrMsg("Unsupported operation " + request.getOperation()).build();
                    return response;
                }
            }
            Response response = Response.newBuilder().setSuccess(true).build();
            return response;
        }
        catch (Exception e) {
            Loggers.RAFT.error("apply service metadata error: ", (Throwable)e);
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(e.getMessage()).build();
            return response;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addClusterMetadataToService(MetadataOperation<ServiceMetadata> op) {
        Service service = Service.newService(op.getNamespace(), op.getGroup(), op.getServiceName(), op.getMetadata().isEphemeral());
        Optional<ServiceMetadata> currentMetadata = this.namingMetadataManager.getServiceMetadata(service);
        if (currentMetadata.isPresent()) {
            currentMetadata.get().getClusters().putAll(op.getMetadata().getClusters());
        } else {
            Service singleton = ServiceManager.getInstance().getSingleton(service);
            this.namingMetadataManager.updateServiceMetadata(singleton, op.getMetadata());
        }
        this.doubleWriteMetadata(service);
    }

    private void updateServiceMetadata(MetadataOperation<ServiceMetadata> op) {
        Service service = Service.newService(op.getNamespace(), op.getGroup(), op.getServiceName(), op.getMetadata().isEphemeral());
        Optional<ServiceMetadata> currentMetadata = this.namingMetadataManager.getServiceMetadata(service);
        if (currentMetadata.isPresent()) {
            ServiceMetadata newMetadata = this.mergeMetadata(currentMetadata.get(), op.getMetadata());
            Service singleton = ServiceManager.getInstance().getSingleton(service);
            this.namingMetadataManager.updateServiceMetadata(singleton, newMetadata);
        } else {
            Service singleton = ServiceManager.getInstance().getSingleton(service);
            this.namingMetadataManager.updateServiceMetadata(singleton, op.getMetadata());
        }
        this.doubleWriteMetadata(service);
    }

    private void doubleWriteMetadata(Service service) {
        ((DoubleWriteEventListener)((Object)ApplicationUtils.getBean(DoubleWriteEventListener.class))).doubleWriteMetadataToV1(service);
    }

    private ServiceMetadata mergeMetadata(ServiceMetadata oldMetadata, ServiceMetadata newMetadata) {
        ServiceMetadata result = new ServiceMetadata();
        result.setEphemeral(oldMetadata.isEphemeral());
        result.setClusters(oldMetadata.getClusters());
        result.setProtectThreshold(newMetadata.getProtectThreshold());
        result.setSelector(newMetadata.getSelector());
        result.setExtendData(newMetadata.getExtendData());
        return result;
    }

    private void deleteServiceMetadata(MetadataOperation<ServiceMetadata> op) {
        Service service = Service.newService(op.getNamespace(), op.getGroup(), op.getServiceName());
        this.namingMetadataManager.removeServiceMetadata(service);
        ServiceManager.getInstance().removeSingleton(service);
        this.serviceStorage.removeData(service);
    }

    public String group() {
        return "naming_service_metadata";
    }
}

