/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.metadata;

import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.naming.consistency.persistent.impl.AbstractSnapshotOperation;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alipay.sofa.jraft.util.CRC64;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.Checksum;

public abstract class AbstractMetadataSnapshotOperation
extends AbstractSnapshotOperation {
    private static final String METADATA_CHILD_NAME = "metadata";

    public AbstractMetadataSnapshotOperation(ReentrantReadWriteLock lock) {
        super(lock);
    }

    @Override
    protected boolean writeSnapshot(Writer writer) throws IOException {
        String writePath = writer.getPath();
        String outputFile = Paths.get(writePath, this.getSnapshotArchive()).toString();
        CRC64 checksum = new CRC64();
        try (InputStream inputStream = this.dumpSnapshot();){
            DiskUtils.compressIntoZipFile((String)METADATA_CHILD_NAME, (InputStream)inputStream, (String)outputFile, (Checksum)checksum);
        }
        LocalFileMeta meta = new LocalFileMeta();
        meta.append((Object)"checksum", (Object)Long.toHexString(checksum.getValue()));
        return writer.addFile(this.getSnapshotArchive(), meta);
    }

    @Override
    protected boolean readSnapshot(Reader reader) throws Exception {
        String readerPath = reader.getPath();
        String sourceFile = Paths.get(readerPath, this.getSnapshotArchive()).toString();
        CRC64 checksum = new CRC64();
        byte[] snapshotBytes = DiskUtils.decompress((String)sourceFile, (Checksum)checksum);
        LocalFileMeta fileMeta = reader.getFileMeta(this.getSnapshotArchive());
        if (fileMeta.getFileMeta().containsKey("checksum") && !Objects.equals((Object)Long.toHexString(checksum.getValue()), (Object)fileMeta.get("checksum"))) {
            throw new IllegalArgumentException("Snapshot checksum failed");
        }
        this.loadSnapshot(snapshotBytes);
        return true;
    }

    protected abstract String getSnapshotArchive();

    protected abstract InputStream dumpSnapshot();

    protected abstract void loadSnapshot(byte[] var1);
}

