/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.manager.impl;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientSyncAttributes;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component(value="persistentIpPortClientManager")
public class PersistentIpPortClientManager
implements ClientManager {
    private ConcurrentMap<String, IpPortBasedClient> clients = new ConcurrentHashMap<String, IpPortBasedClient>();

    @Override
    public boolean clientConnected(Client client) {
        Loggers.SRV_LOG.info("Client connection {} connect", (Object)client.getClientId());
        if (!this.clients.containsKey(client.getClientId())) {
            this.clients.putIfAbsent(client.getClientId(), (IpPortBasedClient)client);
        }
        return true;
    }

    @Override
    public boolean syncClientConnected(String clientId, ClientSyncAttributes attributes) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public boolean clientDisconnected(String clientId) {
        Loggers.SRV_LOG.info("Persistent client connection {} disconnect", (Object)clientId);
        IpPortBasedClient client = (IpPortBasedClient)this.clients.remove(clientId);
        if (null == client) {
            return true;
        }
        NotifyCenter.publishEvent((Event)new ClientEvent.ClientDisconnectEvent(client));
        client.release();
        return true;
    }

    @Override
    public Client getClient(String clientId) {
        return (Client)this.clients.get(clientId);
    }

    @Override
    public boolean contains(String clientId) {
        return this.clients.containsKey(clientId);
    }

    public Client computeIfAbsent(String clientId, Supplier<IpPortBasedClient> supplier) {
        this.clients.computeIfAbsent(clientId, (? super K s) -> (IpPortBasedClient)supplier.get());
        Loggers.SRV_LOG.info("Client connection {} connect", (Object)clientId);
        return this.getClient(clientId);
    }

    @Override
    public Collection<String> allClientId() {
        ArrayList<String> clientIds = new ArrayList<String>(this.clients.size());
        clientIds.addAll(this.clients.keySet());
        return clientIds;
    }

    @Override
    public boolean isResponsibleClient(Client client) {
        return true;
    }

    @Override
    public boolean verifyClient(String clientId) {
        throw new UnsupportedOperationException("");
    }

    public Map<String, IpPortBasedClient> showClients() {
        return Collections.unmodifiableMap(this.clients);
    }

    public void loadFromSnapshot(ConcurrentMap<String, IpPortBasedClient> clients) {
        ConcurrentMap<String, IpPortBasedClient> oldClients = this.clients;
        this.clients = clients;
        oldClients.clear();
    }
}

