/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.impl;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.client.AbstractClient;
import com.alibaba.nacos.naming.core.v2.client.ClientSyncData;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.HealthCheckReactor;
import com.alibaba.nacos.naming.healthcheck.heartbeat.ClientBeatCheckTaskV2;
import com.alibaba.nacos.naming.healthcheck.v2.HealthCheckTaskV2;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import java.util.Collection;
import java.util.List;

public class IpPortBasedClient
extends AbstractClient {
    public static final String ID_DELIMITER = "#";
    private final String clientId;
    private final boolean ephemeral;
    private final String responsibleId;
    private ClientBeatCheckTaskV2 beatCheckTask;
    private HealthCheckTaskV2 healthCheckTaskV2;

    public IpPortBasedClient(String clientId, boolean ephemeral) {
        this.ephemeral = ephemeral;
        this.clientId = clientId;
        this.responsibleId = this.getResponsibleTagFromId();
        if (ephemeral) {
            this.beatCheckTask = new ClientBeatCheckTaskV2(this);
            HealthCheckReactor.scheduleCheck(this.beatCheckTask);
        } else {
            this.healthCheckTaskV2 = new HealthCheckTaskV2(this);
            HealthCheckReactor.scheduleCheck(this.healthCheckTaskV2);
        }
    }

    private String getResponsibleTagFromId() {
        int index = this.clientId.indexOf(ID_DELIMITER);
        return this.clientId.substring(0, index);
    }

    public static String getClientId(String address, boolean ephemeral) {
        return address + ID_DELIMITER + ephemeral;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public String getResponsibleId() {
        return this.responsibleId;
    }

    @Override
    public boolean addServiceInstance(Service service, InstancePublishInfo instancePublishInfo) {
        return super.addServiceInstance(service, this.parseToHealthCheckInstance(instancePublishInfo));
    }

    @Override
    public boolean isExpire(long currentTime) {
        return this.isEphemeral() && this.getAllPublishedService().isEmpty() && currentTime - this.getLastUpdatedTime() > Constants.DEFAULT_IP_DELETE_TIMEOUT;
    }

    public Collection<InstancePublishInfo> getAllInstancePublishInfo() {
        return this.publishers.values();
    }

    @Override
    public void release() {
        super.release();
        if (this.ephemeral) {
            HealthCheckReactor.cancelCheck(this.beatCheckTask);
        } else {
            this.healthCheckTaskV2.setCancelled(true);
        }
    }

    private HealthCheckInstancePublishInfo parseToHealthCheckInstance(InstancePublishInfo instancePublishInfo) {
        if (instancePublishInfo instanceof HealthCheckInstancePublishInfo) {
            return (HealthCheckInstancePublishInfo)instancePublishInfo;
        }
        HealthCheckInstancePublishInfo result = new HealthCheckInstancePublishInfo();
        result.setIp(instancePublishInfo.getIp());
        result.setPort(instancePublishInfo.getPort());
        result.setHealthy(instancePublishInfo.isHealthy());
        result.setCluster(instancePublishInfo.getCluster());
        result.setExtendDatum(instancePublishInfo.getExtendDatum());
        if (!this.ephemeral) {
            result.initHealthCheck();
        }
        return result;
    }

    public void loadClientSyncData(ClientSyncData client) {
        List<String> namespaces = client.getNamespaces();
        List<String> groupNames = client.getGroupNames();
        List<String> serviceNames = client.getServiceNames();
        List<InstancePublishInfo> instances = client.getInstancePublishInfos();
        for (int i = 0; i < namespaces.size(); ++i) {
            Service service = Service.newService(namespaces.get(i), groupNames.get(i), serviceNames.get(i), this.ephemeral);
            Service singleton = ServiceManager.getInstance().getSingleton(service);
            HealthCheckInstancePublishInfo instance = this.parseToHealthCheckInstance(instances.get(i));
            instance.initHealthCheck();
            this.publishers.put(singleton, instance);
            MetricsMonitor.incrementInstanceCount();
        }
    }
}

