/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.impl;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.naming.core.v2.client.AbstractClient;

public class ConnectionBasedClient
extends AbstractClient {
    private final String connectionId;
    private final boolean isNative;
    private volatile long lastRenewTime;

    public ConnectionBasedClient(String connectionId, boolean isNative) {
        this.connectionId = connectionId;
        this.isNative = isNative;
        this.lastRenewTime = this.getLastUpdatedTime();
    }

    @Override
    public String getClientId() {
        return this.connectionId;
    }

    @Override
    public boolean isEphemeral() {
        return true;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public long getLastRenewTime() {
        return this.lastRenewTime;
    }

    public void setLastRenewTime() {
        this.lastRenewTime = System.currentTimeMillis();
    }

    @Override
    public boolean isExpire(long currentTime) {
        return !this.isNative() && currentTime - this.getLastRenewTime() > Constants.DEFAULT_IP_DELETE_TIMEOUT;
    }
}

