/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientSyncData;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.pojo.Subscriber;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractClient
implements Client {
    protected final ConcurrentHashMap<Service, InstancePublishInfo> publishers = new ConcurrentHashMap(16, 0.75f, 1);
    protected final ConcurrentHashMap<Service, Subscriber> subscribers = new ConcurrentHashMap(16, 0.75f, 1);
    protected volatile long lastUpdatedTime = System.currentTimeMillis();

    @Override
    public void setLastUpdatedTime() {
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    @Override
    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Override
    public boolean addServiceInstance(Service service, InstancePublishInfo instancePublishInfo) {
        if (null == this.publishers.put(service, instancePublishInfo)) {
            MetricsMonitor.incrementInstanceCount();
        }
        NotifyCenter.publishEvent((Event)new ClientEvent.ClientChangedEvent(this));
        Loggers.SRV_LOG.info("Client change for service {}, {}", (Object)service, (Object)this.getClientId());
        return true;
    }

    @Override
    public InstancePublishInfo removeServiceInstance(Service service) {
        InstancePublishInfo result = this.publishers.remove(service);
        if (null != result) {
            MetricsMonitor.decrementInstanceCount();
            NotifyCenter.publishEvent((Event)new ClientEvent.ClientChangedEvent(this));
        }
        Loggers.SRV_LOG.info("Client remove for service {}, {}", (Object)service, (Object)this.getClientId());
        return result;
    }

    @Override
    public InstancePublishInfo getInstancePublishInfo(Service service) {
        return this.publishers.get(service);
    }

    @Override
    public Collection<Service> getAllPublishedService() {
        return this.publishers.keySet();
    }

    @Override
    public boolean addServiceSubscriber(Service service, Subscriber subscriber) {
        if (null == this.subscribers.put(service, subscriber)) {
            MetricsMonitor.incrementSubscribeCount();
        }
        return true;
    }

    @Override
    public boolean removeServiceSubscriber(Service service) {
        if (null != this.subscribers.remove(service)) {
            MetricsMonitor.decrementSubscribeCount();
        }
        return true;
    }

    @Override
    public Subscriber getSubscriber(Service service) {
        return this.subscribers.get(service);
    }

    @Override
    public Collection<Service> getAllSubscribeService() {
        return this.subscribers.keySet();
    }

    @Override
    public ClientSyncData generateSyncData() {
        LinkedList<String> namespaces = new LinkedList<String>();
        LinkedList<String> groupNames = new LinkedList<String>();
        LinkedList<String> serviceNames = new LinkedList<String>();
        LinkedList<InstancePublishInfo> instances = new LinkedList<InstancePublishInfo>();
        for (Map.Entry<Service, InstancePublishInfo> entry : this.publishers.entrySet()) {
            namespaces.add(entry.getKey().getNamespace());
            groupNames.add(entry.getKey().getGroup());
            serviceNames.add(entry.getKey().getName());
            instances.add(entry.getValue());
        }
        return new ClientSyncData(this.getClientId(), namespaces, groupNames, serviceNames, instances);
    }

    @Override
    public void release() {
        MetricsMonitor.getIpCountMonitor().addAndGet(-1 * this.publishers.size());
        MetricsMonitor.getSubscriberCount().addAndGet(-1 * this.subscribers.size());
    }
}

