/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.cleaner;

import com.alibaba.nacos.naming.core.v2.cleaner.AbstractNamingCleaner;
import com.alibaba.nacos.naming.core.v2.metadata.ExpiredMetadataInfo;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataOperateService;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class ExpiredMetadataCleaner
extends AbstractNamingCleaner {
    private static final String EXPIRED_METADATA = "expiredMetadata";
    private final NamingMetadataManager metadataManager;
    private final NamingMetadataOperateService metadataOperateService;

    public ExpiredMetadataCleaner(NamingMetadataManager metadataManager, NamingMetadataOperateService metadataOperateService) {
        this.metadataManager = metadataManager;
        this.metadataOperateService = metadataOperateService;
        GlobalExecutor.scheduleExpiredClientCleaner((Runnable)((Object)this), 5000L, GlobalConfig.getExpiredMetadataCleanInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public String getType() {
        return EXPIRED_METADATA;
    }

    @Override
    public void doClean() {
        long currentTime = System.currentTimeMillis();
        for (ExpiredMetadataInfo each : this.metadataManager.getExpiredMetadataInfos()) {
            if (currentTime - each.getCreateTime() <= GlobalConfig.getExpiredMetadataExpiredTime()) continue;
            this.removeExpiredMetadata(each);
        }
    }

    private void removeExpiredMetadata(ExpiredMetadataInfo expiredInfo) {
        Loggers.SRV_LOG.info("Remove expired metadata {}", (Object)expiredInfo);
        if (null == expiredInfo.getMetadataId()) {
            if (this.metadataManager.containServiceMetadata(expiredInfo.getService())) {
                this.metadataOperateService.deleteServiceMetadata(expiredInfo.getService());
            }
        } else if (this.metadataManager.containInstanceMetadata(expiredInfo.getService(), expiredInfo.getMetadataId())) {
            this.metadataOperateService.deleteInstanceMetadata(expiredInfo.getService(), expiredInfo.getMetadataId());
        }
    }
}

