/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.cleaner;

import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.cleaner.AbstractNamingCleaner;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.Map;
import java.util.stream.Stream;

public class EmptyServiceAutoCleaner
extends AbstractNamingCleaner {
    private static final int MAX_FINALIZE_COUNT = 3;
    private final ServiceManager serviceManager;
    private final DistroMapper distroMapper;

    public EmptyServiceAutoCleaner(ServiceManager serviceManager, DistroMapper distroMapper) {
        this.serviceManager = serviceManager;
        this.distroMapper = distroMapper;
    }

    @Override
    public void run() {
        int parallelSize = 100;
        for (String each : this.serviceManager.getAllNamespaces()) {
            Map<String, Service> serviceMap = this.serviceManager.chooseServiceMap(each);
            Stream stream = null;
            stream = serviceMap.size() > parallelSize ? serviceMap.entrySet().parallelStream() : serviceMap.entrySet().stream();
            stream.filter(entry -> {
                String serviceName = (String)entry.getKey();
                return this.distroMapper.responsible(serviceName);
            }).forEach(entry -> serviceMap.computeIfPresent((String)entry.getKey(), (serviceName, service) -> {
                if (service.isEmpty()) {
                    if (service.getFinalizeCount() > 3) {
                        Loggers.SRV_LOG.warn("namespace : {}, [{}] services are automatically cleaned", (Object)each, serviceName);
                        try {
                            this.serviceManager.easyRemoveService(each, (String)serviceName);
                        }
                        catch (Exception e) {
                            Loggers.SRV_LOG.error("namespace : {}, [{}] services are automatically clean has error : {}", new Object[]{each, serviceName, e});
                        }
                    }
                    service.setFinalizeCount(service.getFinalizeCount() + 1);
                    Loggers.SRV_LOG.debug("namespace : {}, [{}] The number of times the current service experiences an empty instance is : {}", new Object[]{each, serviceName, service.getFinalizeCount()});
                } else {
                    service.setFinalizeCount(0);
                }
                return service;
            }));
        }
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void doClean() {
    }
}

