/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.naming.core.HealthOperator;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

@Component
public class HealthOperatorV1Impl
implements HealthOperator {
    private final ServiceManager serviceManager;
    private final UdpPushService pushService;

    public HealthOperatorV1Impl(ServiceManager serviceManager, UdpPushService pushService) {
        this.serviceManager = serviceManager;
        this.pushService = pushService;
    }

    @Override
    public void updateHealthStatusForPersistentInstance(String namespace, String fullServiceName, String clusterName, String ip, int port, boolean healthy) throws NacosException {
        Service service = this.serviceManager.getService(namespace, fullServiceName);
        if (HealthCheckType.NONE.name().equals(service.getClusterMap().get(clusterName).getHealthChecker().getType())) {
            for (Instance instance : service.allIPs(Lists.newArrayList((Object[])new String[]{clusterName}))) {
                if (!instance.getIp().equals(ip) || instance.getPort() != port) continue;
                instance.setHealthy(healthy);
                Loggers.EVT_LOG.info((healthy ? "[IP-ENABLED]" : "[IP-DISABLED]") + " ips: " + instance.getIp() + ":" + instance.getPort() + "@" + instance.getClusterName() + ", service: " + fullServiceName + ", msg: update thought HealthController api");
                this.pushService.serviceChanged(service);
                break;
            }
        } else {
            throw new NacosException(400, "health check is still working, service: " + fullServiceName);
        }
    }
}

