/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Cluster;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.core.CatalogService;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.pojo.ServiceView;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CatalogServiceV2Impl
implements CatalogService {
    private final ServiceStorage serviceStorage;
    private final NamingMetadataManager metadataManager;

    public CatalogServiceV2Impl(ServiceStorage serviceStorage, NamingMetadataManager metadataManager) {
        this.serviceStorage = serviceStorage;
        this.metadataManager = metadataManager;
    }

    @Override
    public Object getServiceDetail(String namespaceId, String groupName, String serviceName) throws NacosException {
        Service service = Service.newService(namespaceId, groupName, serviceName);
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(404, String.format("service %s@@%s is not found!", groupName, serviceName));
        }
        Optional<ServiceMetadata> metadata = this.metadataManager.getServiceMetadata(service);
        ServiceMetadata detailedService = metadata.orElseGet(ServiceMetadata::new);
        ObjectNode serviceObject = JacksonUtils.createEmptyJsonNode();
        serviceObject.put("name", serviceName);
        serviceObject.put("groupName", groupName);
        serviceObject.put("protectThreshold", detailedService.getProtectThreshold());
        serviceObject.replace("selector", JacksonUtils.transferToJsonNode((Object)detailedService.getSelector()));
        serviceObject.replace("metadata", JacksonUtils.transferToJsonNode(detailedService.getExtendData()));
        ObjectNode detailView = JacksonUtils.createEmptyJsonNode();
        detailView.replace("service", (JsonNode)serviceObject);
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (String each : this.serviceStorage.getClusters(service)) {
            ClusterMetadata clusterMetadata = detailedService.getClusters().containsKey(each) ? detailedService.getClusters().get(each) : new ClusterMetadata();
            Cluster clusterView = new Cluster();
            clusterView.setName(each);
            clusterView.setHealthChecker(clusterMetadata.getHealthChecker());
            clusterView.setMetadata(clusterMetadata.getExtendData());
            clusterView.setUseIPPort4Check(clusterMetadata.isUseInstancePortForCheck());
            clusterView.setDefaultPort(80);
            clusterView.setDefaultCheckPort(clusterMetadata.getHealthyCheckPort());
            clusterView.setServiceName(service.getGroupedServiceName());
            clusters.add(clusterView);
        }
        detailView.replace("clusters", JacksonUtils.transferToJsonNode(clusters));
        return detailView;
    }

    @Override
    public List<? extends Instance> listInstances(String namespaceId, String groupName, String serviceName, String clusterName) throws NacosException {
        Service service = Service.newService(namespaceId, groupName, serviceName);
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(404, String.format("service %s@@%s is not found!", groupName, serviceName));
        }
        if (!this.serviceStorage.getClusters(service).contains(clusterName)) {
            throw new NacosException(404, "cluster " + clusterName + " is not found!");
        }
        ServiceInfo serviceInfo = this.serviceStorage.getData(service);
        ServiceInfo result = ServiceUtil.selectInstances(serviceInfo, clusterName);
        return result.getHosts();
    }

    @Override
    public Object pageListService(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize, String instancePattern, boolean ignoreEmptyService) throws NacosException {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        LinkedList<ServiceView> serviceViews = new LinkedList<ServiceView>();
        Collection<Service> services = this.patternServices(namespaceId, groupName, serviceName);
        if (ignoreEmptyService) {
            services = services.stream().filter(each -> 0 != this.serviceStorage.getData((Service)each).ipCount()).collect(Collectors.toList());
        }
        result.put("count", services.size());
        services = this.doPage(services, pageNo - 1, pageSize);
        for (Service each2 : services) {
            ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(each2).orElseGet(ServiceMetadata::new);
            ServiceView serviceView = new ServiceView();
            serviceView.setName(each2.getName());
            serviceView.setGroupName(each2.getGroup());
            serviceView.setClusterCount(this.serviceStorage.getClusters(each2).size());
            serviceView.setIpCount(this.serviceStorage.getData(each2).ipCount());
            serviceView.setHealthyInstanceCount(this.countHealthyInstance(this.serviceStorage.getData(each2)));
            serviceView.setTriggerFlag(this.isProtectThreshold(serviceView, serviceMetadata) ? "true" : "false");
            serviceViews.add(serviceView);
        }
        result.set("serviceList", JacksonUtils.transferToJsonNode(serviceViews));
        return result;
    }

    private int countHealthyInstance(ServiceInfo data) {
        int result = 0;
        for (Instance each : data.getHosts()) {
            if (!each.isHealthy()) continue;
            ++result;
        }
        return result;
    }

    private boolean isProtectThreshold(ServiceView serviceView, ServiceMetadata metadata) {
        return (double)serviceView.getHealthyInstanceCount() * 1.0 / (double)serviceView.getIpCount() <= (double)metadata.getProtectThreshold();
    }

    @Override
    public Object pageListServiceDetail(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize) throws NacosException {
        return null;
    }

    private Collection<Service> patternServices(String namespaceId, String group, String serviceName) {
        boolean noFilter;
        boolean bl = noFilter = StringUtils.isBlank((CharSequence)serviceName) && StringUtils.isBlank((CharSequence)group);
        if (noFilter) {
            return ServiceManager.getInstance().getSingletons(namespaceId);
        }
        LinkedList<Service> result = new LinkedList<Service>();
        StringJoiner regex = new StringJoiner("@@");
        regex.add(this.getRegexString(group));
        regex.add(this.getRegexString(serviceName));
        String regexString = regex.toString();
        for (Service each : ServiceManager.getInstance().getSingletons(namespaceId)) {
            if (!each.getGroupedServiceName().matches(regexString)) continue;
            result.add(each);
        }
        return result;
    }

    private String getRegexString(String target) {
        return StringUtils.isBlank((CharSequence)target) ? ".*" : ".*" + target + ".*";
    }

    private Collection<Service> doPage(Collection<Service> services, int pageNo, int pageSize) {
        if (services.size() < pageSize) {
            return services;
        }
        LinkedList<Service> result = new LinkedList<Service>();
        int i = 0;
        for (Service each : services) {
            if (i++ < pageNo * pageSize) continue;
            result.add(each);
            if (result.size() < pageSize) continue;
            break;
        }
        return result;
    }
}

