/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.core.CatalogService;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.pojo.ClusterInfo;
import com.alibaba.nacos.naming.pojo.IpAddressInfo;
import com.alibaba.nacos.naming.pojo.ServiceDetailInfo;
import com.alibaba.nacos.naming.pojo.ServiceView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CatalogServiceV1Impl
implements CatalogService {
    private final ServiceManager serviceManager;

    public CatalogServiceV1Impl(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public Object getServiceDetail(String namespaceId, String groupName, String serviceName) throws NacosException {
        Service detailedService = this.serviceManager.getService(namespaceId, NamingUtils.getGroupedName((String)serviceName, (String)groupName));
        if (detailedService == null) {
            throw new NacosException(404, String.format("service %s@@%s is not found!", groupName, serviceName));
        }
        ObjectNode serviceObject = JacksonUtils.createEmptyJsonNode();
        serviceObject.put("name", serviceName);
        serviceObject.put("protectThreshold", detailedService.getProtectThreshold());
        serviceObject.put("groupName", groupName);
        serviceObject.replace("selector", JacksonUtils.transferToJsonNode((Object)detailedService.getSelector()));
        serviceObject.replace("metadata", JacksonUtils.transferToJsonNode((Object)detailedService.getMetadata()));
        ObjectNode detailView = JacksonUtils.createEmptyJsonNode();
        detailView.replace("service", (JsonNode)serviceObject);
        detailView.replace("clusters", JacksonUtils.transferToJsonNode(detailedService.getClusterMap().values()));
        return detailView;
    }

    @Override
    public List<? extends com.alibaba.nacos.api.naming.pojo.Instance> listInstances(String namespaceId, String groupName, String serviceName, String clusterName) throws NacosException {
        Service service = this.serviceManager.getService(namespaceId, NamingUtils.getGroupedName((String)serviceName, (String)groupName));
        if (service == null) {
            throw new NacosException(404, String.format("service %s@@%s is not found!", groupName, serviceName));
        }
        if (!service.getClusterMap().containsKey(clusterName)) {
            throw new NacosException(404, "cluster " + clusterName + " is not found!");
        }
        return service.getClusterMap().get(clusterName).allIPs();
    }

    @Override
    public Object pageListService(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize, String instancePattern, boolean ignoreEmptyService) throws NacosException {
        String param = StringUtils.isBlank((CharSequence)serviceName) && StringUtils.isBlank((CharSequence)groupName) ? "" : NamingUtils.getGroupedNameOptional((String)serviceName, (String)groupName);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayList<Service> services = new ArrayList<Service>();
        int total = this.serviceManager.getPagedService(namespaceId, pageNo - 1, pageSize, param, instancePattern, services, ignoreEmptyService);
        if (CollectionUtils.isEmpty(services)) {
            result.replace("serviceList", JacksonUtils.transferToJsonNode(Collections.emptyList()));
            result.put("count", 0);
            return result;
        }
        LinkedList<ServiceView> serviceViews = new LinkedList<ServiceView>();
        for (Service each : services) {
            ServiceView serviceView = new ServiceView();
            serviceView.setName(NamingUtils.getServiceName((String)each.getName()));
            serviceView.setGroupName(NamingUtils.getGroupName((String)each.getName()));
            serviceView.setClusterCount(each.getClusterMap().size());
            serviceView.setIpCount(each.allIPs().size());
            serviceView.setHealthyInstanceCount(each.healthyInstanceCount());
            serviceView.setTriggerFlag(each.triggerFlag() ? "true" : "false");
            serviceViews.add(serviceView);
        }
        result.set("serviceList", JacksonUtils.transferToJsonNode(serviceViews));
        result.put("count", total);
        return result;
    }

    @Override
    public Object pageListServiceDetail(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize) throws NacosException {
        String param = StringUtils.isBlank((CharSequence)serviceName) && StringUtils.isBlank((CharSequence)groupName) ? "" : NamingUtils.getGroupedNameOptional((String)serviceName, (String)groupName);
        ArrayList<ServiceDetailInfo> serviceDetailInfoList = new ArrayList<ServiceDetailInfo>();
        ArrayList<Service> services = new ArrayList<Service>(8);
        this.serviceManager.getPagedService(namespaceId, pageNo, pageSize, param, "", services, false);
        for (Service each : services) {
            ServiceDetailInfo serviceDetailInfo = new ServiceDetailInfo();
            serviceDetailInfo.setServiceName(NamingUtils.getServiceName((String)each.getName()));
            serviceDetailInfo.setGroupName(NamingUtils.getGroupName((String)each.getName()));
            serviceDetailInfo.setMetadata(each.getMetadata());
            Map<String, ClusterInfo> clusterInfoMap = this.getStringClusterInfoMap(each);
            serviceDetailInfo.setClusterMap(clusterInfoMap);
            serviceDetailInfoList.add(serviceDetailInfo);
        }
        return serviceDetailInfoList;
    }

    private Map<String, ClusterInfo> getStringClusterInfoMap(Service service) {
        HashMap<String, ClusterInfo> clusterInfoMap = new HashMap<String, ClusterInfo>(8);
        service.getClusterMap().forEach((clusterName, cluster) -> {
            ClusterInfo clusterInfo = new ClusterInfo();
            List<IpAddressInfo> ipAddressInfos = this.getIpAddressInfos(cluster.allIPs());
            clusterInfo.setHosts(ipAddressInfos);
            clusterInfoMap.put((String)clusterName, clusterInfo);
        });
        return clusterInfoMap;
    }

    private List<IpAddressInfo> getIpAddressInfos(List<Instance> instances) {
        ArrayList<IpAddressInfo> ipAddressInfos = new ArrayList<IpAddressInfo>();
        instances.forEach(ipAddress -> {
            IpAddressInfo ipAddressInfo = new IpAddressInfo();
            ipAddressInfo.setIp(ipAddress.getIp());
            ipAddressInfo.setPort(ipAddress.getPort());
            ipAddressInfo.setMetadata(ipAddress.getMetadata());
            ipAddressInfo.setValid(ipAddress.isHealthy());
            ipAddressInfo.setWeight(ipAddress.getWeight());
            ipAddressInfo.setEnabled(ipAddress.isEnabled());
            ipAddressInfos.add(ipAddressInfo);
        });
        return ipAddressInfos;
    }
}

