/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.InstanceOperator;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.InstanceOperatorServiceImpl;
import com.alibaba.nacos.naming.core.InstancePatchObject;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.InstanceOperationInfo;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/instance"})
public class InstanceController {
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private InstanceOperatorClientImpl instanceServiceV2;
    @Autowired
    private InstanceOperatorServiceImpl instanceServiceV1;
    @Autowired
    private UpgradeJudgement upgradeJudgement;

    @CanDistro
    @PostMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String register(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Instance instance = this.parseInstance(request);
        this.getInstanceOperator().registerInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @DeleteMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String deregister(HttpServletRequest request) throws Exception {
        Instance instance = this.getIpAddress(request);
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        this.getInstanceOperator().removeInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @PutMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String update(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        this.getInstanceOperator().updateInstance(namespaceId, serviceName, this.parseInstance(request));
        return "ok";
    }

    @CanDistro
    @PutMapping(value={"/metadata/batch"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode batchUpdateInstanceMetadata(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String consistencyType = WebUtils.optional((HttpServletRequest)request, (String)"consistencyType", (String)"");
        String instances = WebUtils.optional((HttpServletRequest)request, (String)"instances", (String)"");
        List<Instance> targetInstances = this.parseBatchInstances(instances);
        String metadata = WebUtils.required((HttpServletRequest)request, (String)"metadata");
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(metadata);
        InstanceOperationInfo instanceOperationInfo = this.buildOperationInfo(serviceName, consistencyType, targetInstances);
        List<String> operatedInstances = this.getInstanceOperator().batchUpdateMetadata(namespaceId, instanceOperationInfo, targetMetadata);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (String ip : operatedInstances) {
            ipArray.add(ip);
        }
        result.replace("updated", (JsonNode)ipArray);
        return result;
    }

    @CanDistro
    @DeleteMapping(value={"/metadata/batch"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode batchDeleteInstanceMetadata(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String consistencyType = WebUtils.optional((HttpServletRequest)request, (String)"consistencyType", (String)"");
        String instances = WebUtils.optional((HttpServletRequest)request, (String)"instances", (String)"");
        List<Instance> targetInstances = this.parseBatchInstances(instances);
        String metadata = WebUtils.required((HttpServletRequest)request, (String)"metadata");
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(metadata);
        InstanceOperationInfo instanceOperationInfo = this.buildOperationInfo(serviceName, consistencyType, targetInstances);
        List<String> operatedInstances = this.getInstanceOperator().batchDeleteMetadata(namespaceId, instanceOperationInfo, targetMetadata);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (String ip : operatedInstances) {
            ipArray.add(ip);
        }
        result.replace("updated", (JsonNode)ipArray);
        return result;
    }

    private InstanceOperationInfo buildOperationInfo(String serviceName, String consistencyType, List<Instance> instances) {
        if (!CollectionUtils.isEmpty(instances)) {
            for (Instance instance : instances) {
                if (!StringUtils.isBlank((CharSequence)instance.getClusterName())) continue;
                instance.setClusterName("DEFAULT");
            }
        }
        return new InstanceOperationInfo(serviceName, consistencyType, instances);
    }

    private List<Instance> parseBatchInstances(String instances) {
        try {
            return (List)JacksonUtils.toObj((String)instances, (TypeReference)new TypeReference<List<Instance>>(){});
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("UPDATE-METADATA: Param 'instances' is illegal, ignore this operation", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @CanDistro
    @PatchMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String patch(HttpServletRequest request) throws Exception {
        String enabledString;
        String healthy;
        String weight;
        String app;
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        String port = WebUtils.required((HttpServletRequest)request, (String)"port");
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"");
        if (StringUtils.isBlank((CharSequence)cluster)) {
            cluster = WebUtils.optional((HttpServletRequest)request, (String)"cluster", (String)"DEFAULT");
        }
        InstancePatchObject patchObject = new InstancePatchObject(cluster, ip, Integer.parseInt(port));
        String metadata = WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"");
        if (StringUtils.isNotBlank((CharSequence)metadata)) {
            patchObject.setMetadata(UtilsAndCommons.parseMetadata(metadata));
        }
        if (StringUtils.isNotBlank((CharSequence)(app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"")))) {
            patchObject.setApp(app);
        }
        if (StringUtils.isNotBlank((CharSequence)(weight = WebUtils.optional((HttpServletRequest)request, (String)"weight", (String)"")))) {
            patchObject.setWeight(Double.parseDouble(weight));
        }
        if (StringUtils.isNotBlank((CharSequence)(healthy = WebUtils.optional((HttpServletRequest)request, (String)"healthy", (String)"")))) {
            patchObject.setHealthy(BooleanUtils.toBoolean((String)healthy));
        }
        if (StringUtils.isNotBlank((CharSequence)(enabledString = WebUtils.optional((HttpServletRequest)request, (String)"enabled", (String)"")))) {
            patchObject.setEnabled(BooleanUtils.toBoolean((String)enabledString));
        }
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        this.getInstanceOperator().patchInstance(namespaceId, serviceName, patchObject);
        return "ok";
    }

    @GetMapping(value={"/list"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public Object list(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String agent = WebUtils.getUserAgent((HttpServletRequest)request);
        String clusters = WebUtils.optional((HttpServletRequest)request, (String)"clusters", (String)"");
        String clientIP = WebUtils.optional((HttpServletRequest)request, (String)"clientIP", (String)"");
        int udpPort = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)"udpPort", (String)"0"));
        boolean healthyOnly = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"healthyOnly", (String)"false"));
        boolean isCheck = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"isCheck", (String)"false"));
        String app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"");
        String env = WebUtils.optional((HttpServletRequest)request, (String)"env", (String)"");
        String tenant = WebUtils.optional((HttpServletRequest)request, (String)"tid", (String)"");
        Subscriber subscriber = new Subscriber(clientIP + ":" + udpPort, agent, app, clientIP, namespaceId, serviceName, udpPort, clusters);
        return this.getInstanceOperator().listInstance(namespaceId, serviceName, subscriber, clusters, healthyOnly);
    }

    @GetMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode detail(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"DEFAULT");
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        int port = Integer.parseInt(WebUtils.required((HttpServletRequest)request, (String)"port"));
        com.alibaba.nacos.api.naming.pojo.Instance instance = this.getInstanceOperator().getInstance(namespaceId, serviceName, cluster, ip, port);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("service", serviceName);
        result.put("ip", ip);
        result.put("port", port);
        result.put("clusterName", cluster);
        result.put("weight", instance.getWeight());
        result.put("healthy", instance.isHealthy());
        result.put("instanceId", instance.getInstanceId());
        result.set("metadata", JacksonUtils.transferToJsonNode((Object)instance.getMetadata()));
        return result;
    }

    @CanDistro
    @PutMapping(value={"/beat"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode beat(HttpServletRequest request) throws Exception {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("clientBeatInterval", this.switchDomain.getClientBeatInterval());
        String beat = WebUtils.optional((HttpServletRequest)request, (String)"beat", (String)"");
        RsInfo clientBeat = null;
        if (StringUtils.isNotBlank((CharSequence)beat)) {
            clientBeat = (RsInfo)JacksonUtils.toObj((String)beat, RsInfo.class);
        }
        String clusterName = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"DEFAULT");
        String ip = WebUtils.optional((HttpServletRequest)request, (String)"ip", (String)"");
        int port = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)"port", (String)"0"));
        if (clientBeat != null) {
            if (StringUtils.isNotBlank((CharSequence)clientBeat.getCluster())) {
                clusterName = clientBeat.getCluster();
            } else {
                clientBeat.setCluster(clusterName);
            }
            ip = clientBeat.getIp();
            port = clientBeat.getPort();
        }
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Loggers.SRV_LOG.debug("[CLIENT-BEAT] full arguments: beat: {}, serviceName: {}", (Object)clientBeat, (Object)serviceName);
        int resultCode = this.getInstanceOperator().handleBeat(namespaceId, serviceName, ip, port, clusterName, clientBeat);
        result.put("code", resultCode);
        result.put("clientBeatInterval", this.getInstanceOperator().getHeartBeatInterval(namespaceId, serviceName, ip, port, clusterName));
        result.put("lightBeatEnabled", this.switchDomain.isLightBeatEnabled());
        return result;
    }

    @RequestMapping(value={"/statuses"})
    public ObjectNode listWithHealthStatus(@RequestParam String key) throws NacosException {
        String serviceName;
        String namespaceId;
        if (key.contains("##")) {
            namespaceId = key.split("##")[0];
            serviceName = key.split("##")[1];
        } else {
            namespaceId = "public";
            serviceName = key;
        }
        NamingUtils.checkServiceNameFormat((String)serviceName);
        List<? extends com.alibaba.nacos.api.naming.pojo.Instance> ips = this.getInstanceOperator().listAllInstances(namespaceId, serviceName);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (com.alibaba.nacos.api.naming.pojo.Instance instance : ips) {
            ipArray.add(instance.toInetAddr() + "_" + instance.isHealthy());
        }
        result.replace("ips", (JsonNode)ipArray);
        return result;
    }

    private Instance parseInstance(HttpServletRequest request) throws Exception {
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"DEFAULT");
        Instance instance = this.getIpAddress(request);
        instance.setApp(app);
        instance.setServiceName(serviceName);
        instance.setInstanceId(instance.generateInstanceId());
        instance.setLastBeat(System.currentTimeMillis());
        String metadata = WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"");
        if (StringUtils.isNotEmpty((CharSequence)metadata)) {
            instance.setMetadata(UtilsAndCommons.parseMetadata(metadata));
        }
        instance.validate();
        return instance;
    }

    private Instance getIpAddress(HttpServletRequest request) {
        String enabledString = WebUtils.optional((HttpServletRequest)request, (String)"enabled", (String)"");
        boolean enabled = StringUtils.isBlank((CharSequence)enabledString) ? BooleanUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"enable", (String)"true")) : BooleanUtils.toBoolean((String)enabledString);
        String weight = WebUtils.optional((HttpServletRequest)request, (String)"weight", (String)"1");
        boolean healthy = BooleanUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"healthy", (String)"true"));
        Instance instance = this.getBasicIpAddress(request);
        instance.setWeight(Double.parseDouble(weight));
        instance.setHealthy(healthy);
        instance.setEnabled(enabled);
        return instance;
    }

    private Instance getBasicIpAddress(HttpServletRequest request) {
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        String port = WebUtils.required((HttpServletRequest)request, (String)"port");
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"");
        if (StringUtils.isBlank((CharSequence)cluster)) {
            cluster = WebUtils.optional((HttpServletRequest)request, (String)"cluster", (String)"DEFAULT");
        }
        boolean ephemeral = BooleanUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"ephemeral", (String)String.valueOf(this.switchDomain.isDefaultInstanceEphemeral())));
        Instance instance = new Instance();
        instance.setPort(Integer.parseInt(port));
        instance.setIp(ip);
        instance.setEphemeral(ephemeral);
        instance.setClusterName(cluster);
        return instance;
    }

    private InstanceOperator getInstanceOperator() {
        return this.upgradeJudgement.isUseGrpcFeatures() ? this.instanceServiceV2 : this.instanceServiceV1;
    }
}

