/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.impl;

import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.core.storage.kv.KvStorage;
import com.alibaba.nacos.naming.consistency.persistent.impl.AbstractSnapshotOperation;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alipay.sofa.jraft.util.CRC64;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.Checksum;

public class NamingSnapshotOperation
extends AbstractSnapshotOperation {
    private static final String NAMING_SNAPSHOT_SAVE = NamingSnapshotOperation.class.getSimpleName() + ".SAVE";
    private static final String NAMING_SNAPSHOT_LOAD = NamingSnapshotOperation.class.getSimpleName() + ".LOAD";
    private final String snapshotDir = "naming_persistent";
    private final String snapshotArchive = "naming_persistent.zip";
    private final KvStorage storage;

    public NamingSnapshotOperation(KvStorage storage, ReentrantReadWriteLock lock) {
        super(lock);
        this.storage = storage;
    }

    @Override
    protected boolean writeSnapshot(Writer writer) throws Exception {
        String writePath = writer.getPath();
        String parentPath = Paths.get(writePath, "naming_persistent").toString();
        DiskUtils.deleteDirectory((String)parentPath);
        DiskUtils.forceMkdir((String)parentPath);
        this.storage.doSnapshot(parentPath);
        String outputFile = Paths.get(writePath, "naming_persistent.zip").toString();
        CRC64 checksum = new CRC64();
        DiskUtils.compress((String)writePath, (String)"naming_persistent", (String)outputFile, (Checksum)checksum);
        DiskUtils.deleteDirectory((String)parentPath);
        LocalFileMeta meta = new LocalFileMeta();
        meta.append((Object)"checksum", (Object)Long.toHexString(checksum.getValue()));
        return writer.addFile("naming_persistent.zip", meta);
    }

    @Override
    protected boolean readSnapshot(Reader reader) throws Exception {
        String readerPath = reader.getPath();
        String sourceFile = Paths.get(readerPath, "naming_persistent.zip").toString();
        CRC64 checksum = new CRC64();
        DiskUtils.decompress((String)sourceFile, (String)readerPath, (Checksum)checksum);
        LocalFileMeta fileMeta = reader.getFileMeta("naming_persistent.zip");
        if (fileMeta.getFileMeta().containsKey("checksum") && !Objects.equals((Object)Long.toHexString(checksum.getValue()), (Object)fileMeta.get("checksum"))) {
            throw new IllegalArgumentException("Snapshot checksum failed");
        }
        String loadPath = Paths.get(readerPath, "naming_persistent").toString();
        this.storage.snapshotLoad(loadPath);
        Loggers.RAFT.info("snapshot load from : {}", (Object)loadPath);
        DiskUtils.deleteDirectory((String)loadPath);
        return true;
    }

    @Override
    protected String getSnapshotSaveTag() {
        return NAMING_SNAPSHOT_SAVE;
    }

    @Override
    protected String getSnapshotLoadTag() {
        return NAMING_SNAPSHOT_LOAD;
    }
}

