/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro.v2;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.cluster.remote.ClusterRpcClientProxy;
import com.alibaba.nacos.core.distributed.distro.component.DistroCallback;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.distributed.distro.exception.DistroException;
import com.alibaba.nacos.naming.cluster.remote.request.DistroDataRequest;
import com.alibaba.nacos.naming.cluster.remote.response.DistroDataResponse;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.concurrent.Executor;

public class DistroClientTransportAgent
implements DistroTransportAgent {
    private final ClusterRpcClientProxy clusterRpcClientProxy;
    private final ServerMemberManager memberManager;

    public DistroClientTransportAgent(ClusterRpcClientProxy clusterRpcClientProxy, ServerMemberManager serverMemberManager) {
        this.clusterRpcClientProxy = clusterRpcClientProxy;
        this.memberManager = serverMemberManager;
    }

    public boolean supportCallbackTransport() {
        return true;
    }

    public boolean syncData(DistroData data, String targetServer) {
        if (this.isNoExistTarget(targetServer)) {
            return true;
        }
        DistroDataRequest request = new DistroDataRequest(data, data.getType());
        Member member = this.memberManager.find(targetServer);
        if (this.checkTargetServerStatusUnhealthy(member)) {
            Loggers.DISTRO.warn("[DISTRO] Cancel distro sync caused by target server {} unhealthy", (Object)targetServer);
            return false;
        }
        try {
            Response response = this.clusterRpcClientProxy.sendRequest(member, (Request)request);
            return this.checkResponse(response);
        }
        catch (NacosException e) {
            Loggers.DISTRO.error("[DISTRO-FAILED] Sync distro data failed! ", (Throwable)e);
            return false;
        }
    }

    public void syncData(DistroData data, String targetServer, DistroCallback callback) {
        if (this.isNoExistTarget(targetServer)) {
            callback.onSuccess();
        }
        DistroDataRequest request = new DistroDataRequest(data, data.getType());
        Member member = this.memberManager.find(targetServer);
        try {
            this.clusterRpcClientProxy.asyncRequest(member, (Request)request, (RequestCallBack)new DistroRpcCallbackWrapper(callback));
        }
        catch (NacosException nacosException) {
            callback.onFailed((Throwable)nacosException);
        }
    }

    public boolean syncVerifyData(DistroData verifyData, String targetServer) {
        if (this.isNoExistTarget(targetServer)) {
            return true;
        }
        verifyData.getDistroKey().setTargetServer(this.memberManager.getSelf().getAddress());
        DistroDataRequest request = new DistroDataRequest(verifyData, DataOperation.VERIFY);
        Member member = this.memberManager.find(targetServer);
        if (this.checkTargetServerStatusUnhealthy(member)) {
            Loggers.DISTRO.warn("[DISTRO] Cancel distro verify caused by target server {} unhealthy", (Object)targetServer);
            return false;
        }
        try {
            Response response = this.clusterRpcClientProxy.sendRequest(member, (Request)request);
            return this.checkResponse(response);
        }
        catch (NacosException e) {
            Loggers.DISTRO.error("[DISTRO-FAILED] Verify distro data failed! ", (Throwable)e);
            return false;
        }
    }

    public void syncVerifyData(DistroData verifyData, String targetServer, DistroCallback callback) {
        if (this.isNoExistTarget(targetServer)) {
            callback.onSuccess();
        }
        DistroDataRequest request = new DistroDataRequest(verifyData, DataOperation.VERIFY);
        Member member = this.memberManager.find(targetServer);
        try {
            DistroVerifyCallbackWrapper wrapper = new DistroVerifyCallbackWrapper(targetServer, verifyData.getDistroKey().getResourceKey(), callback);
            this.clusterRpcClientProxy.asyncRequest(member, (Request)request, (RequestCallBack)wrapper);
        }
        catch (NacosException nacosException) {
            callback.onFailed((Throwable)nacosException);
        }
    }

    public DistroData getData(DistroKey key, String targetServer) {
        Member member = this.memberManager.find(targetServer);
        if (this.checkTargetServerStatusUnhealthy(member)) {
            throw new DistroException(String.format("[DISTRO] Cancel get snapshot caused by target server %s unhealthy", targetServer));
        }
        DistroDataRequest request = new DistroDataRequest();
        DistroData distroData = new DistroData();
        distroData.setDistroKey(key);
        distroData.setType(DataOperation.QUERY);
        request.setDistroData(distroData);
        request.setDataOperation(DataOperation.QUERY);
        try {
            Response response = this.clusterRpcClientProxy.sendRequest(member, (Request)request);
            if (this.checkResponse(response)) {
                return ((DistroDataResponse)response).getDistroData();
            }
            throw new DistroException(String.format("[DISTRO-FAILED] Get data request to %s failed, code: %d, message: %s", targetServer, response.getErrorCode(), response.getMessage()));
        }
        catch (NacosException e) {
            throw new DistroException("[DISTRO-FAILED] Get distro data failed! ", (Throwable)e);
        }
    }

    public DistroData getDatumSnapshot(String targetServer) {
        Member member = this.memberManager.find(targetServer);
        if (this.checkTargetServerStatusUnhealthy(member)) {
            throw new DistroException(String.format("[DISTRO] Cancel get snapshot caused by target server %s unhealthy", targetServer));
        }
        DistroDataRequest request = new DistroDataRequest();
        request.setDataOperation(DataOperation.SNAPSHOT);
        try {
            Response response = this.clusterRpcClientProxy.sendRequest(member, (Request)request);
            if (this.checkResponse(response)) {
                return ((DistroDataResponse)response).getDistroData();
            }
            throw new DistroException(String.format("[DISTRO-FAILED] Get snapshot request to %s failed, code: %d, message: %s", targetServer, response.getErrorCode(), response.getMessage()));
        }
        catch (NacosException e) {
            throw new DistroException("[DISTRO-FAILED] Get distro snapshot failed! ", (Throwable)e);
        }
    }

    private boolean isNoExistTarget(String target) {
        return !this.memberManager.hasMember(target);
    }

    private boolean checkTargetServerStatusUnhealthy(Member member) {
        return null == member || !NodeState.UP.equals((Object)member.getState());
    }

    private boolean checkResponse(Response response) {
        return ResponseCode.SUCCESS.getCode() == response.getResultCode();
    }

    private class DistroVerifyCallbackWrapper
    implements RequestCallBack<Response> {
        private final String targetServer;
        private final String clientId;
        private final DistroCallback distroCallback;

        private DistroVerifyCallbackWrapper(String targetServer, String clientId, DistroCallback distroCallback) {
            this.targetServer = targetServer;
            this.clientId = clientId;
            this.distroCallback = distroCallback;
        }

        public Executor getExecutor() {
            return GlobalExecutor.getCallbackExecutor();
        }

        public long getTimeout() {
            return 3000L;
        }

        public void onResponse(Response response) {
            if (DistroClientTransportAgent.this.checkResponse(response)) {
                this.distroCallback.onSuccess();
            } else {
                Loggers.DISTRO.info("Target {} verify client {} failed, sync new client", (Object)this.targetServer, (Object)this.clientId);
                NotifyCenter.publishEvent((Event)new ClientEvent.ClientVerifyFailedEvent(this.clientId, this.targetServer));
                this.distroCallback.onFailed(null);
            }
        }

        public void onException(Throwable e) {
            this.distroCallback.onFailed(e);
        }
    }

    private class DistroRpcCallbackWrapper
    implements RequestCallBack<Response> {
        private final DistroCallback distroCallback;

        public DistroRpcCallbackWrapper(DistroCallback distroCallback) {
            this.distroCallback = distroCallback;
        }

        public Executor getExecutor() {
            return GlobalExecutor.getCallbackExecutor();
        }

        public long getTimeout() {
            return 3000L;
        }

        public void onResponse(Response response) {
            if (DistroClientTransportAgent.this.checkResponse(response)) {
                this.distroCallback.onSuccess();
            } else {
                this.distroCallback.onFailed(null);
            }
        }

        public void onException(Throwable e) {
            this.distroCallback.onFailed(e);
        }
    }
}

